/*
 * Decompiled with CFR 0.152.
 */
package com.diamssword.greenresurgence.systems.equipement;

import com.diamssword.greenresurgence.GreenResurgence;
import com.diamssword.greenresurgence.items.weapons.ICustomPoseWeapon;
import com.diamssword.greenresurgence.systems.equipement.Equipments;
import com.diamssword.greenresurgence.systems.equipement.IEquipmentDef;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;

public class EquipmentSkins {
    public static Map<String, Map<class_1792, ItemSkinModelDef>> skins = new HashMap<String, Map<class_1792, ItemSkinModelDef>>();

    public static void init() {
        EquipmentSkins.forAll("bone_hammer", "hammer/medium,hammer/long");
        EquipmentSkins.forAll("bone_axe", "hammer/medium,hammer/long");
        EquipmentSkins.forAll("bone_mace", "hammer/medium,hammer/long");
        EquipmentSkins.forAll("bone_knuckles", "hammer/short");
        EquipmentSkins.forAll("bat", "hammer/medium,hammer/long");
        EquipmentSkins.forAll("work_tool", "hammer/*,spike/long");
        EquipmentSkins.forAll("fire_axe", "hammer/long");
        EquipmentSkins.forAll("iron_pipe", "hammer/short,hammer/medium");
        EquipmentSkins.forAll("upgraded_bat", "hammer/medium,hammer/long");
        EquipmentSkins.forAll("street_sign", "hammer/long");
        EquipmentSkins.forAll("makeshift_axe", "hammer/medium,hammer/long");
        EquipmentSkins.forAll("makeshift_mace", "hammer/medium,hammer/long");
        EquipmentSkins.forAll("makeshift_hammer", "hammer/medium,hammer/long");
        EquipmentSkins.forAll("makeshift_knuckles", "hammer/short");
        EquipmentSkins.forAll("wrench", "hammer/medium,hammer/short");
        EquipmentSkins.forAll("bone_blade", "blade/*");
        EquipmentSkins.forAll("bone_matchet", "blade/short,blade/medium");
        EquipmentSkins.forAll("bone_katana", "blade/long");
        EquipmentSkins.forAll("combat_knife", "blade/short");
        EquipmentSkins.forAll("kukri", "blade/medium");
        EquipmentSkins.forAll("makeshift_blade", "blade/*");
        EquipmentSkins.forAll("makeshift_matchet", "blade/short,blade/medium");
        EquipmentSkins.forAll("makeshift_katana", "blade/long");
        EquipmentSkins.forAll("bone_spear", "spike/medium,spike/long");
        EquipmentSkins.forAll("makeshift_spear", "spike/medium,spike/long");
        EquipmentSkins.forAll("screwdriver_flat", "spike/short");
        EquipmentSkins.forAll("screwdriver_cross", "spike/short");
        EquipmentSkins.forAll("chainsaw", "electric/cutter", true);
        EquipmentSkins.forAll("weedwacker", "electric/cutter", true);
        EquipmentSkins.forAll("flame_sword", "electric/hot", true);
    }

    public static Optional<ItemSkinModelDef> get(String skin, class_1792 item) {
        Map<class_1792, ItemSkinModelDef> s = skins.get(skin);
        if (s != null) {
            return Optional.ofNullable(s.get(item));
        }
        return Optional.empty();
    }

    public static Optional<String> getDefault(class_1792 item) {
        for (String s : skins.keySet()) {
            if (!skins.get(s).containsKey(item)) continue;
            return Optional.of(s);
        }
        return Optional.empty();
    }

    public static Optional<ItemSkinModelDef> get(String skin, long worldtime) {
        Map<class_1792, ItemSkinModelDef> s = skins.get(skin);
        if (s != null) {
            List arr = s.keySet().stream().toList();
            return arr.isEmpty() ? Optional.empty() : Optional.of(s.get(arr.get(class_3532.method_15375((float)((float)worldtime / 40.0f)) % arr.size())));
        }
        return Optional.empty();
    }

    private static void forAll(String id, String allowed) {
        EquipmentSkins.forAll(id, allowed, false, null, 0);
    }

    private static void forAll(String id, String allowed, boolean isGecko) {
        EquipmentSkins.forAll(id, allowed, isGecko, null, 0);
    }

    private static void forAll(String id, String allowed, boolean isGecko, @Nullable class_2960 texture, int modeForTwoHanded) {
        for (String s : allowed.split(",")) {
            String[] ps = s.split("/");
            if (ps[0].equals("*")) {
                Equipments.equipments.forEach((k, v) -> {
                    if (ps[1].equals("*")) {
                        v.forEach((k1, v1) -> EquipmentSkins.createOne(id, v1, isGecko, texture, modeForTwoHanded));
                    } else if (v.containsKey(ps[1])) {
                        EquipmentSkins.createOne(id, (IEquipmentDef)v.get(ps[1]), isGecko, texture, modeForTwoHanded);
                    }
                });
                continue;
            }
            Map<String, IEquipmentDef> eq = Equipments.equipments.get(ps[0]);
            if (eq == null) continue;
            if (ps[1].equals("*")) {
                eq.forEach((k1, v1) -> EquipmentSkins.createOne(id, v1, isGecko, texture, modeForTwoHanded));
                continue;
            }
            if (!eq.containsKey(ps[1])) continue;
            EquipmentSkins.createOne(id, eq.get(ps[1]), isGecko, texture, modeForTwoHanded);
        }
    }

    private static void createOne(String skin, IEquipmentDef equipment, boolean isGecko, @Nullable class_2960 texture, int modeForTwoHanded) {
        ICustomPoseWeapon wep;
        skins.putIfAbsent(skin, new HashMap());
        class_1792 item = equipment.getEquipmentItem();
        if (item instanceof ICustomPoseWeapon && (wep = (ICustomPoseWeapon)item).shouldRemoveOffHand()) {
            skins.get(skin).put(equipment.getEquipmentItem(), new ItemSkinModelDef(isGecko, skin, equipment, texture, modeForTwoHanded));
        } else {
            skins.get(skin).put(equipment.getEquipmentItem(), new ItemSkinModelDef(isGecko, skin, equipment, texture));
        }
    }

    public static class ItemSkinModelDef {
        public final boolean isGecko;
        public final class_2960 model;
        public final int extra;
        @Nullable
        public final class_2960 texture;

        public ItemSkinModelDef(boolean isGecko, String skin, IEquipmentDef equipment, @Nullable class_2960 texture) {
            this(isGecko, skin, equipment, texture, 0);
        }

        public ItemSkinModelDef(boolean isGecko, String skin, IEquipmentDef equipment, @Nullable class_2960 texture, int extra) {
            this.isGecko = isGecko;
            this.model = !isGecko ? GreenResurgence.asRessource("equipments/skins/" + skin + "/" + equipment.getEquipmentType() + "_" + equipment.getEquipmentSubtype()) : GreenResurgence.asRessource(skin + "/" + equipment.getEquipmentType() + "_" + equipment.getEquipmentSubtype());
            this.texture = texture;
            this.extra = extra;
        }

        public class_2960 getVanillaPath() {
            if (!this.isGecko) {
                return this.model;
            }
            return this.model.method_45138("equipments/skins/");
        }

        public ItemSkinModelDef(boolean isGecko, class_2960 model, class_2960 texture) {
            this.isGecko = isGecko;
            this.model = model;
            this.texture = texture;
            this.extra = 0;
        }
    }
}

