/*
 * Decompiled with CFR 0.152.
 */
package com.diamssword.greenresurgence.systems.equipement;

import com.diamssword.greenresurgence.items.equipment.EquipmentSecondHand;
import com.diamssword.greenresurgence.items.equipment.EquipmentToolElectric;
import com.diamssword.greenresurgence.items.equipment.EquipmentToolElectricTwoHanded;
import com.diamssword.greenresurgence.items.equipment.EquipmentToolHammer;
import com.diamssword.greenresurgence.items.equipment.EquipmentTwoHanded;
import com.diamssword.greenresurgence.systems.equipement.EquipmentDef;
import com.diamssword.greenresurgence.systems.equipement.EquipmentEffects;
import com.diamssword.greenresurgence.systems.equipement.EquipmentEnergyStorage;
import com.diamssword.greenresurgence.systems.equipement.EquipmentSkins;
import com.diamssword.greenresurgence.systems.equipement.IEquipmentDef;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import team.reborn.energy.api.EnergyStorage;

public class Equipments {
    public static Map<String, Map<String, IEquipmentDef>> equipments = new HashMap<String, Map<String, IEquipmentDef>>();
    public static final String P_SKIN = "skin";
    public static final String P_BLADE = "blade";
    public static final String P_HEAD = "head";
    public static final String P_SPIKE = "spike";
    public static final String P_BATTERY = "battery";
    public static final String P_HANDLE = "handle";
    public static final String P_EXTRA = "extra";

    public static void init() {
        Equipments.register(P_BLADE, "short", new String[]{P_SKIN, P_BLADE, P_HANDLE}, P_EXTRA);
        Equipments.register(P_BLADE, "medium", new String[]{P_SKIN, P_BLADE, P_HANDLE}, P_EXTRA);
        Equipments.register(P_BLADE, "long", new String[]{P_SKIN, P_BLADE, P_HANDLE}, P_EXTRA);
        Equipments.register("hammer", "short", new String[]{P_SKIN, P_HEAD, P_HANDLE}, P_EXTRA);
        Equipments.register("hammer", "medium", new String[]{P_SKIN, P_HEAD, P_HANDLE}, P_EXTRA);
        Equipments.register("hammer", "long", new String[]{P_SKIN, P_HEAD, P_HANDLE}, P_EXTRA);
        Equipments.register(P_SPIKE, "short", new String[]{P_SKIN, P_SPIKE, P_HANDLE}, P_EXTRA);
        Equipments.register(P_SPIKE, "medium", new String[]{P_SKIN, P_SPIKE, P_HANDLE}, P_EXTRA);
        Equipments.register(P_SPIKE, "long", new String[]{P_SKIN, P_SPIKE, P_HANDLE}, P_EXTRA);
        Equipments.register("electric", "cutter", new String[]{P_SKIN, P_BATTERY}, P_EXTRA);
        Equipments.register("electric", "hot", new String[]{P_SKIN, P_BATTERY}, P_EXTRA);
        Equipments.registers();
        EquipmentSkins.init();
        EquipmentEffects.init();
    }

    public static Optional<IEquipmentDef> getEquipment(String type, String subtype) {
        Map<String, IEquipmentDef> t = equipments.get(type);
        if (t != null) {
            return Optional.ofNullable(t.get(subtype));
        }
        return Optional.empty();
    }

    private static void registers() {
        equipments.forEach((k, v) -> v.forEach((k1, v1) -> {
            if (v1.getBlueprintItem() != null) {
                class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)new class_2960("green_resurgence", "equipments/bp_" + k + "_" + k1), (Object)v1.getBlueprintItem());
            }
            if (v1.getEquipmentItem() != null) {
                class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)new class_2960("green_resurgence", "equipments/" + k + "_" + k1), (Object)v1.getEquipmentItem());
            }
            if (v1.getEquipmentItem() instanceof EquipmentToolElectric) {
                EnergyStorage.ITEM.registerForItems((a, c) -> EquipmentEnergyStorage.createEquipmentStorage(c, a), new class_1935[]{v1.getEquipmentItem()});
            }
        }));
    }

    public static void register(String type, String subType, String[] requiredSlots, String ... extraSlots) {
        equipments.putIfAbsent(type, new HashMap());
        BiFunction<String, String, class_1792> gen = EquipmentSecondHand::new;
        if (type.equals("hammer") && subType.equals("medium")) {
            gen = EquipmentToolHammer::new;
        } else if (subType.equals("long")) {
            gen = EquipmentTwoHanded::new;
        } else if (subType.equals("short")) {
            gen = EquipmentSecondHand::new;
        } else if (type.equals("electric")) {
            gen = subType.equals("cutter") ? (a, b) -> new EquipmentToolElectricTwoHanded((String)a, (String)b, false) : (a, b) -> new EquipmentToolElectric((String)a, (String)b, true);
        }
        equipments.get(type).put(subType, new EquipmentDef(type, subType, gen, requiredSlots, extraSlots));
    }
}

