/*
 * Decompiled with CFR 0.152.
 */
package com.diamssword.greenresurgence.systems.equipement;

import com.diamssword.greenresurgence.GreenResurgence;
import com.diamssword.greenresurgence.items.equipment.EquipmentUpgradeItem;
import com.diamssword.greenresurgence.systems.equipement.AdvEquipmentSlot;
import com.diamssword.greenresurgence.systems.equipement.EffectLevel;
import com.diamssword.greenresurgence.systems.equipement.EquipmentEffects;
import com.diamssword.greenresurgence.systems.equipement.Equipments;
import com.diamssword.greenresurgence.systems.equipement.IEquipmentDef;
import com.diamssword.greenresurgence.systems.equipement.IEquipmentEffect;
import com.diamssword.greenresurgence.systems.equipement.IEquipmentUpgrade;
import com.diamssword.greenresurgence.systems.equipement.IUpgradableEquipment;
import com.diamssword.greenresurgence.systems.equipement.TooltipHelper;
import com.diamssword.greenresurgence.systems.equipement.UpgradeActionContext;
import com.diamssword.greenresurgence.systems.equipement.UpgradeGroundActionContext;
import com.diamssword.greenresurgence.utils.Utils;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_239;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3468;
import net.minecraft.class_3966;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class StackBasedEquipment
implements IUpgradableEquipment {
    private final String subcategory;
    private final String category;
    private final Map<String, class_1799> content = new HashMap<String, class_1799>();
    private final Map<String, class_1792> broken = new HashMap<String, class_1792>();
    private String skin;
    public final class_1799 stack;
    private final IEquipmentDef equipment;
    private Map<String, EffectLevel> baseUpgrades = new HashMap<String, EffectLevel>();
    private final Map<IEquipmentEffect, EffectLevel> combinedEffects = new HashMap<IEquipmentEffect, EffectLevel>();
    private final Map<String, EffectLevel> combinedEffectsString = new HashMap<String, EffectLevel>();
    private boolean isComputed = false;

    public StackBasedEquipment(String category, String subcategory, class_1799 stack) {
        this.category = category;
        this.subcategory = subcategory;
        this.stack = stack;
        this.equipment = Equipments.getEquipment(category, subcategory).get();
        this.fromNBT(stack.method_7948());
    }

    public StackBasedEquipment(IEquipmentDef def, class_1799 stack) {
        this.category = def.getEquipmentType();
        this.subcategory = def.getEquipmentSubtype();
        this.stack = stack;
        this.equipment = def;
        this.fromNBT(stack.method_7948());
    }

    public StackBasedEquipment(String category, String subcategory, class_1799 stack, Map<String, EffectLevel> upgrades) {
        this.category = category;
        this.subcategory = subcategory;
        this.stack = stack;
        this.equipment = Equipments.getEquipment(category, subcategory).get();
        this.baseUpgrades = upgrades;
        this.fromNBT(stack.method_7948());
    }

    public StackBasedEquipment(IEquipmentDef def, class_1799 stack, Map<String, EffectLevel> upgrades) {
        this.category = def.getEquipmentType();
        this.subcategory = def.getEquipmentSubtype();
        this.stack = stack;
        this.equipment = def;
        this.baseUpgrades = upgrades;
        this.fromNBT(stack.method_7948());
    }

    public StackBasedEquipment setBaseToolUpgrades(Map<String, EffectLevel> upgrades) {
        this.baseUpgrades = upgrades;
        return this;
    }

    protected void fromNBT(class_2487 tag) {
        Object st;
        class_2487 ut;
        this.content.clear();
        this.broken.clear();
        if (tag.method_10545("upgrades")) {
            ut = tag.method_10562("upgrades");
            for (String k : ut.method_10541()) {
                st = ut.method_10562(k);
                this.content.put(k, class_1799.method_7915((class_2487)st));
            }
        }
        if (tag.method_10545("broken")) {
            ut = tag.method_10562("broken");
            for (String k : ut.method_10541()) {
                st = ut.method_10558(k);
                this.broken.put(k, (class_1792)class_7923.field_41178.method_10223(new class_2960((String)st)));
            }
        }
        if (tag.method_10545("skin")) {
            this.skin = tag.method_10558("skin");
        }
    }

    public class_1799 getUpgradeItem(String slot) {
        return this.content.getOrDefault(slot, class_1799.field_8037);
    }

    public void setUpgrade(class_1799 upgradeItem) {
        class_1792 class_17922 = upgradeItem.method_7909();
        if (class_17922 instanceof EquipmentUpgradeItem) {
            EquipmentUpgradeItem up = (EquipmentUpgradeItem)class_17922;
            if (this.equipment != null && up.canBeApplied(this.equipment, upgradeItem)) {
                this.content.put(up.slot(this.equipment), upgradeItem);
                this.broken.remove(up.slot(this.equipment));
                if (up.slot(this.equipment).equals("skin")) {
                    this.skin = upgradeItem.method_7948().method_10558("skin");
                }
                this.computeEffects();
            }
        }
    }

    @Override
    public IEquipmentDef getEquipment() {
        return this.equipment;
    }

    @Override
    public List<class_6862<class_1792>> getTags() {
        if (!this.isComputed) {
            this.computeEffects();
        }
        UpgradeActionContext ctx = new UpgradeActionContext(null, null, UpgradeActionContext.ItemContext.TOOL).setLevels(this.combinedEffectsString);
        ArrayList<class_6862<class_1792>> res = new ArrayList<class_6862<class_1792>>();
        this.combinedEffects.forEach((k, v) -> res.addAll(k.getTags(ctx)));
        return res;
    }

    public void setUpgrade(class_1799 upgradeItem, String slot) {
        if (upgradeItem.method_7960()) {
            this.clearUpgrade(slot);
        } else {
            this.setUpgrade(upgradeItem);
        }
    }

    public boolean isMinimalUpgradesSet() {
        for (String requiredSlot : this.equipment.getRequiredSlots()) {
            if (this.content.containsKey(requiredSlot)) continue;
            return false;
        }
        return true;
    }

    public void clearUpgrade(String slot) {
        this.content.remove(slot);
        if (slot.equals("skin")) {
            this.skin = "";
        }
        this.computeEffects();
    }

    public void save() {
        class_2487 nbt = this.stack.method_7948();
        class_2487 ups = new class_2487();
        this.content.forEach((k, v) -> ups.method_10566(k, (class_2520)v.method_7953(new class_2487())));
        nbt.method_10566("upgrades", (class_2520)ups);
        if (this.skin != null) {
            nbt.method_10582("skin", this.skin);
        }
        class_2487 brokens = new class_2487();
        this.broken.forEach((k, v) -> brokens.method_10582(k, class_7923.field_41178.method_10221(v).toString()));
        nbt.method_10566("broken", (class_2520)brokens);
    }

    @Override
    public String getEquipmentType() {
        return this.category;
    }

    @Override
    public String getEquipmentSubtype() {
        return this.subcategory;
    }

    @Override
    public String getSkin() {
        return this.skin;
    }

    @Override
    public Multimap<class_1320, class_1322> getAttributeModifiers(AdvEquipmentSlot slot, @Nullable class_1657 player) {
        if (!this.isComputed) {
            this.computeEffects();
        }
        ArrayListMultimap map = ArrayListMultimap.create();
        UpgradeActionContext ctx = new UpgradeActionContext(player, null, UpgradeActionContext.ItemContext.TOOL).setLevels(this.combinedEffectsString);
        this.combinedEffects.forEach((arg_0, arg_1) -> StackBasedEquipment.lambda$getAttributeModifiers$3((Multimap)map, slot, ctx, arg_0, arg_1));
        return map;
    }

    protected void computeEffects() {
        this.isComputed = true;
        this.combinedEffects.clear();
        this.combinedEffectsString.clear();
        this.content.keySet().forEach(v -> {
            Optional<EquipmentUpgradeItem> eq = this.getAsEquipment((String)v);
            eq.ifPresent(equipmentUpgradeItem -> equipmentUpgradeItem.getEffectsLevels().forEach((k1, v1) -> EquipmentEffects.get(k1).ifPresent(a -> {
                if (!this.combinedEffects.containsKey(a)) {
                    this.combinedEffects.put((IEquipmentEffect)a, (EffectLevel)v1);
                } else {
                    this.combinedEffects.get(a).add((EffectLevel)v1);
                }
                if (!this.combinedEffectsString.containsKey(k1)) {
                    this.combinedEffectsString.put((String)k1, (EffectLevel)v1);
                }
            })));
        });
        this.baseUpgrades.forEach((k, v) -> EquipmentEffects.get(k).ifPresent(a -> {
            if (!this.combinedEffects.containsKey(a)) {
                this.combinedEffects.put((IEquipmentEffect)a, (EffectLevel)v);
            } else {
                this.combinedEffects.get(a).add((EffectLevel)v);
            }
            if (!this.combinedEffectsString.containsKey(k)) {
                this.combinedEffectsString.put((String)k, (EffectLevel)v);
            }
        }));
    }

    protected Optional<EquipmentUpgradeItem> getAsEquipment(String slot) {
        class_1792 class_17922 = this.getUpgradeItem(slot).method_7909();
        if (class_17922 instanceof EquipmentUpgradeItem) {
            EquipmentUpgradeItem up = (EquipmentUpgradeItem)class_17922;
            return Optional.of(up);
        }
        return Optional.empty();
    }

    @Override
    public void onInteraction(class_1657 wearer, AdvEquipmentSlot slot, IEquipmentUpgrade.InteractType interaction, class_239 context) {
        class_3966 res;
        class_1297 class_12972;
        if (!this.isComputed) {
            this.computeEffects();
        }
        if (context instanceof class_3966 && (class_12972 = (res = (class_3966)context).method_17782()) instanceof class_1309) {
            class_1309 li = (class_1309)class_12972;
            UpgradeActionContext ctx = new UpgradeActionContext(wearer, li, UpgradeActionContext.ItemContext.TOOL).setLevels(this.combinedEffectsString);
            this.combinedEffects.forEach((k, v) -> k.onInteraction(ctx, slot, interaction));
        }
    }

    public boolean onToolDamage(class_1309 owner, AdvEquipmentSlot slot) {
        if (this.content.isEmpty()) {
            return true;
        }
        Stream<String> keys = this.content.keySet().stream().filter(v -> this.getAsEquipment((String)v).map(EquipmentUpgradeItem::method_7846).orElse(false));
        String picked = Utils.selectRandomWeighted(keys.toList(), k -> this.getAsEquipment((String)k).map(EquipmentUpgradeItem::damageWeight).orElse(Float.valueOf(0.0f)));
        int dura = this.content.get(picked).method_7919() + 1;
        if (dura >= this.getAsEquipment(picked).get().maxDurability()) {
            if (owner instanceof class_1657) {
                ((class_1657)owner).method_7259(class_3468.field_15383.method_14956((Object)this.getAsEquipment(picked).get()));
            }
            this.broken.put(picked, this.content.remove(picked).method_7909());
            if (this.content.isEmpty()) {
                return true;
            }
            class_1304 vsl = slot.getParent();
            if (vsl != null) {
                owner.method_20235(vsl);
            }
        } else {
            this.content.get(picked).method_7974(dura);
        }
        return false;
    }

    public void appendTooltip(List<class_2561> tooltip) {
        if (!this.isComputed) {
            this.computeEffects();
        }
        UpgradeActionContext ctx = new UpgradeActionContext(null, null, UpgradeActionContext.ItemContext.TOOL).setLevels(this.combinedEffectsString);
        for (AdvEquipmentSlot value : AdvEquipmentSlot.values()) {
            ArrayList subList = new ArrayList();
            this.combinedEffectsString.forEach((k, v) -> {
                Optional<IEquipmentEffect> eff = EquipmentEffects.get(k);
                eff.ifPresent(p -> p.addTooltips(ctx, value, subList));
            });
            if (subList.isEmpty()) continue;
            TooltipHelper.appendUpgradeHeader(value, ctx.context == UpgradeActionContext.ItemContext.UPGRADE, tooltip);
            tooltip.addAll(subList);
        }
        if (!GreenResurgence.clientHelper.isShiftPressed()) {
            tooltip.add((class_2561)class_2561.method_43471((String)"equipment.green_resurgence.tooltip.press_shift").method_27695(new class_124[]{class_124.field_1080, class_124.field_1056}));
        } else if (!this.broken.isEmpty()) {
            tooltip.add((class_2561)class_2561.method_43471((String)"equipment.green_resurgence.tooltip.broken_parts").method_27692(class_124.field_1061));
            for (String s : this.broken.keySet()) {
                tooltip.add((class_2561)class_2561.method_43470((String)" - ").method_10852((class_2561)class_2561.method_43471((String)("equipment.green_resurgence.gui." + s))).method_27692(class_124.field_1076));
            }
        }
    }

    @Override
    public void onTick(class_1297 parent, AdvEquipmentSlot slot) {
        UpgradeActionContext ctx;
        if (!this.isComputed) {
            this.computeEffects();
        }
        if (parent instanceof class_1657) {
            class_1657 pl = (class_1657)parent;
            ctx = new UpgradeActionContext(pl, null, UpgradeActionContext.ItemContext.TOOL).setLevels(this.combinedEffectsString);
        } else {
            ctx = new UpgradeGroundActionContext(parent, UpgradeActionContext.ItemContext.TOOL).setLevels(this.combinedEffectsString);
        }
        this.combinedEffects.forEach((k, v) -> k.onInteraction(ctx, slot, IEquipmentUpgrade.InteractType.TICK));
    }

    public float getDurabilityProgress() {
        List<String> ls = this.content.keySet().stream().filter(v -> this.getAsEquipment((String)v).map(EquipmentUpgradeItem::method_7846).orElse(false)).toList();
        int act = 0;
        int max = 0;
        for (String k : ls) {
            max += this.getAsEquipment(k).get().maxDurability();
            act += this.content.get(k).method_7919();
        }
        for (String k : this.broken.keySet()) {
            class_1792 v2 = this.broken.get(k);
            if (!(v2 instanceof EquipmentUpgradeItem)) continue;
            EquipmentUpgradeItem up = (EquipmentUpgradeItem)v2;
            max += up.maxDurability();
            act += up.maxDurability();
        }
        if (max == 0) {
            return 1.0f;
        }
        return 1.0f - (float)act / (float)max;
    }

    private static /* synthetic */ void lambda$getAttributeModifiers$3(Multimap map, AdvEquipmentSlot slot, UpgradeActionContext ctx, IEquipmentEffect k, EffectLevel v) {
        k.getAttributeModifiers((Multimap<class_1320, class_1322>)map, slot, ctx);
    }
}

