/*
 * Decompiled with CFR 0.152.
 */
package com.diamssword.greenresurgence.systems.faction.perimeter.components;

import com.diamssword.greenresurgence.systems.faction.perimeter.components.FactionGuild;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import org.jetbrains.annotations.Nullable;

public class FactionMember {
    private class_1657 player;
    private final String name;
    private final UUID id;
    private final boolean isGuild;
    private FactionGuild guild;

    public class_1937 getWorld() {
        if (this.player != null) {
            return this.player.method_37908();
        }
        if (this.guild != null) {
            return this.guild.getOwner().getWorld();
        }
        return null;
    }

    public Optional<class_1657> asPlayer(@Nullable class_1937 w) {
        if (this.isGuild) {
            return Optional.empty();
        }
        if (this.player != null) {
            return Optional.of(this.player);
        }
        if (w == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(w.method_18470(this.id));
    }

    public boolean isPlayer() {
        return !this.isGuild;
    }

    public boolean isGuild() {
        return this.isGuild;
    }

    public FactionMember(FactionGuild guild) {
        this.id = guild.getId();
        this.guild = guild;
        this.isGuild = true;
        this.name = guild.getName();
    }

    public FactionMember(UUID id, String name, boolean isGuild) {
        this.id = id;
        this.isGuild = isGuild;
        this.name = name;
    }

    public FactionMember(class_1657 player) {
        this.id = player.method_5667();
        this.player = player;
        this.isGuild = false;
        this.name = player.method_5477().getString();
    }

    public FactionMember(class_2487 tag) {
        this.id = tag.method_25926("id");
        this.isGuild = tag.method_10577("isGuild");
        this.name = tag.method_10558("name");
    }

    public UUID getId() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FactionMember that = (FactionMember)o;
        return this.isGuild == that.isGuild && Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.isGuild);
    }

    public void writeNbt(class_2487 tag) {
        tag.method_25927("id", this.id);
        tag.method_10582("name", this.name);
        tag.method_10556("isGuild", this.isGuild);
    }

    public String getName() {
        return this.name;
    }

    public static void serializer(class_2540 write, FactionMember val) {
        write.method_10797(val.getId());
        write.method_10814(val.getName());
        write.writeBoolean(val.isGuild);
    }

    public static FactionMember unserializer(class_2540 read) {
        return new FactionMember(read.method_10790(), read.method_19772(), read.readBoolean());
    }
}

