/*
 * Decompiled with CFR 0.152.
 */
package com.diamssword.greenresurgence.systems.faction.perimeter.components;

import com.diamssword.greenresurgence.systems.faction.perimeter.components.Perms;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import net.minecraft.class_2487;
import net.minecraft.class_2540;

public class FactionPerm {
    public static final FactionPerm ALL = new FactionPerm("ALL");
    public static final FactionPerm NONE = new FactionPerm("NONE");
    private String name;
    private final List<Perms> allowed = new ArrayList<Perms>();

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public boolean needSurvival() {
        for (Perms d : this.allowed) {
            if (!d.needSurvival) continue;
            return true;
        }
        return false;
    }

    public boolean isAllowed(Perms perm) {
        return this.allowed.contains((Object)perm);
    }

    public boolean isAllowed(Perms ... perm) {
        return new HashSet<Perms>(this.allowed).containsAll(Arrays.stream(perm).toList());
    }

    public class_2487 toNBT() {
        class_2487 tag = new class_2487();
        tag.method_10582("name", this.name);
        tag.method_10539("perms", this.toIntArray());
        return tag;
    }

    public static FactionPerm fromNBT(class_2487 tag) {
        String name = tag.method_10558("name");
        if (name != null) {
            FactionPerm f = new FactionPerm(name);
            f.fromIntArray(tag.method_10561("perms"));
            return f;
        }
        return null;
    }

    public void setPerm(Perms perm, boolean allowed) {
        if (!allowed) {
            this.allowed.remove((Object)perm);
        } else if (!this.allowed.contains((Object)perm)) {
            this.allowed.add(perm);
        }
    }

    public FactionPerm(String name) {
        this.name = name;
    }

    public int[] toIntArray() {
        int[] res = new int[this.allowed.size()];
        for (int i = 0; i < res.length; ++i) {
            res[i] = this.allowed.get((int)i).id;
        }
        return res;
    }

    public void fromIntArray(int[] perms) {
        this.allowed.clear();
        for (int perm : perms) {
            Perms p = Perms.getByID(perm);
            if (p == null) continue;
            this.allowed.add(p);
        }
    }

    public static void serializer(class_2540 write, FactionPerm val) {
        write.method_10814(val.name);
        write.method_10806(val.toIntArray());
    }

    public static FactionPerm unserializer(class_2540 read) {
        FactionPerm p = new FactionPerm(read.method_19772());
        p.fromIntArray(read.method_10787());
        return p;
    }

    static {
        FactionPerm.ALL.allowed.addAll(Arrays.asList(Perms.values()));
    }
}

