/*
 * Decompiled with CFR 0.152.
 */
package com.diamssword.greenresurgence.systems.faction.perimeter.components;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1263;
import net.minecraft.class_1265;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import org.jetbrains.annotations.Nullable;

public class FormattedInventory
implements class_1263 {
    public final class_1263 parent;
    private final List<class_1799> items = new ArrayList<class_1799>();
    @Nullable
    private List<class_1265> listeners;

    public FormattedInventory(class_1263 parent) {
        this.parent = parent;
        this.refresh();
    }

    void refresh() {
        this.items.clear();
        for (int i = 0; i < this.parent.method_5439(); ++i) {
            class_1799 d = this.parent.method_5438(i);
            if (d.method_7960()) continue;
            Optional<class_1799> d3 = this.items.stream().filter(v -> class_1799.method_31577((class_1799)v, (class_1799)d)).findAny();
            if (d3.isPresent()) {
                d3.get().method_7939(d3.get().method_7947() + d.method_7947());
                continue;
            }
            this.items.add(d.method_7972());
        }
        this.items.sort(Comparator.comparingInt(class_1799::method_7947).reversed());
        if (this.items.isEmpty()) {
            this.items.add(class_1799.field_8037);
        }
        this.method_5431();
    }

    public void addListener(class_1265 listener) {
        if (this.listeners == null) {
            this.listeners = Lists.newArrayList();
        }
        this.listeners.add(listener);
    }

    public void removeListener(class_1265 listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    public int method_5439() {
        return this.items.size();
    }

    public boolean method_5442() {
        return this.items.isEmpty();
    }

    public class_1799 method_5438(int slot) {
        return this.getDisplayInSlot(slot);
    }

    private int findStackInParent(class_1799 stack) {
        for (int i = 0; i < this.parent.method_5439(); ++i) {
            if (!class_1799.method_31577((class_1799)this.parent.method_5438(i), (class_1799)stack)) continue;
            return i;
        }
        return -1;
    }

    public class_1799 method_5434(int slot, int amount) {
        class_1799 stack = this.getDisplayInSlot(slot);
        int s1 = this.findStackInParent(stack);
        class_1799 re = this.parent.method_5434(s1, amount);
        if (re.method_7947() < amount) {
            s1 = this.findStackInParent(stack);
            class_1799 re1 = this.parent.method_5434(s1, amount - re.method_7947());
            re.method_7939(re.method_7947() + re1.method_7947());
        }
        return re;
    }

    public class_1799 method_5441(int slot) {
        return this.method_5434(slot, this.getDisplayInSlot(slot).method_7914());
    }

    public boolean canInsert(class_1799 stack) {
        for (int i = 0; i < this.parent.method_5439(); ++i) {
            class_1799 st1 = this.parent.method_5438(i);
            if (st1.method_7960()) {
                return true;
            }
            if (!class_1799.method_31577((class_1799)st1, (class_1799)stack) || st1.method_7947() >= st1.method_7914()) continue;
            return true;
        }
        return false;
    }

    public int inserStack(class_1799 stack) {
        class_1799 st1;
        int i;
        int ret = stack.method_7947();
        for (i = 0; i < this.parent.method_5439(); ++i) {
            int ins;
            st1 = this.parent.method_5438(i);
            if (!class_1799.method_31577((class_1799)st1, (class_1799)stack) || (ins = Math.min(st1.method_7914() - st1.method_7947(), stack.method_7947())) <= 0) continue;
            if (ret < ins) {
                ins = ret;
            }
            st1.method_7933(ins);
            if ((ret -= ins) != 0) continue;
            this.refresh();
            return 0;
        }
        for (i = 0; i < this.parent.method_5439(); ++i) {
            st1 = this.parent.method_5438(i);
            if (!st1.method_7960()) continue;
            class_1799 s1 = stack.method_7972();
            s1.method_7939(ret);
            this.parent.method_5447(i, s1);
            this.refresh();
            return 0;
        }
        return ret;
    }

    public class_1799 getDisplayStack(class_1799 stack) {
        Optional<class_1799> d = this.items.stream().filter(v -> class_1799.method_31577((class_1799)stack, (class_1799)v)).findAny();
        return d.orElse(class_1799.field_8037);
    }

    public class_1799 getDisplayInSlot(int slot) {
        if (slot >= this.items.size()) {
            return class_1799.field_8037;
        }
        return this.items.get(slot);
    }

    public void method_5447(int slot, class_1799 stack) {
        int i;
        if (stack.method_7960()) {
            int s1 = this.findStackInParent(this.getDisplayInSlot(slot));
            if (s1 > -1) {
                this.parent.method_5447(s1, stack);
                this.refresh();
            }
            return;
        }
        for (i = 0; i < this.parent.method_5439(); ++i) {
            class_1799 i1 = this.parent.method_5438(i);
            if (!class_1799.method_31577((class_1799)i1, (class_1799)stack)) continue;
            int ins = Math.min(i1.method_7914() - i1.method_7947(), stack.method_7947());
            stack.method_7934(ins);
            i1.method_7933(ins);
            if (stack.method_7960()) break;
        }
        if (!stack.method_7960()) {
            for (i = 0; i < this.parent.method_5439(); ++i) {
                if (!this.parent.method_5438(i).method_7960()) continue;
                this.parent.method_5447(i, stack);
                break;
            }
        }
        this.refresh();
    }

    public void method_5431() {
        this.parent.method_5431();
        if (this.listeners != null) {
            for (class_1265 inventoryChangedListener : this.listeners) {
                inventoryChangedListener.method_5453((class_1263)this);
            }
        }
    }

    public int method_5444() {
        return Integer.MAX_VALUE;
    }

    public boolean method_5443(class_1657 player) {
        return true;
    }

    public void method_5448() {
    }

    public static class MySlot
    extends class_1735 {
        private final FormattedInventory inv;

        public MySlot(FormattedInventory inventory, int index, int x, int y) {
            super((class_1263)inventory, index, x, y);
            this.inv = inventory;
        }

        public class_1799 method_7677() {
            return this.inv.getDisplayInSlot(this.method_34266());
        }

        public void method_7673(class_1799 stack) {
            if (this.inv.items.size() <= this.method_34266()) {
                this.inv.items.add(stack);
            } else {
                this.inv.items.set(this.method_34266(), stack);
            }
        }

        public void method_48931(class_1799 stack) {
            this.inv.method_5447(this.method_34266(), stack);
        }

        public class_1799 method_7671(int amount) {
            return this.inv.method_5434(this.method_34266(), amount);
        }

        public class_1799 getRealStack() {
            return this.field_7871.method_5438(this.method_34266());
        }

        public void method_7667(class_1657 player, class_1799 stack) {
        }

        public int method_7676(class_1799 stack) {
            return stack.method_7914();
        }

        public boolean method_7680(class_1799 stack) {
            return this.inv.canInsert(stack);
        }

        public class_1799 method_32755(class_1799 stack, int count) {
            class_1799 stack1 = stack.method_7972();
            stack1.method_7939(count);
            if (!stack.method_7960() && this.method_7680(stack)) {
                int r = this.inv.inserStack(stack1);
                stack.method_7939(stack.method_7947() - (count - r));
            }
            return stack;
        }

        public Optional<class_1799> method_34264(int min, int max, class_1657 player) {
            if (!this.method_7674(player)) {
                return Optional.empty();
            }
            if (!this.method_32754(player) && max < this.method_7677().method_7947()) {
                return Optional.empty();
            }
            class_1799 itemStack = this.method_7671(min = Math.min(min, Math.min(this.method_7677().method_7914(), max)));
            if (itemStack.method_7960()) {
                return Optional.empty();
            }
            if (this.method_7677().method_7960()) {
                this.method_48931(class_1799.field_8037);
            }
            return Optional.of(itemStack);
        }
    }
}

