/*
 * Decompiled with CFR 0.152.
 */
package com.diamssword.greenresurgence.textures;

import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.logging.LogUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Base64;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1011;
import net.minecraft.class_1049;
import net.minecraft.class_156;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Environment(value=EnvType.CLIENT)
public class B64PlayerSkinTexture
extends class_1049 {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int WIDTH = 64;
    private static final int HEIGHT = 64;
    private static final int OLD_HEIGHT = 32;
    @Nullable
    private final File cacheFile;
    private final String base64;
    @Nullable
    private final Runnable loadedCallback;
    @Nullable
    private CompletableFuture<?> loader;
    private boolean loaded;

    public B64PlayerSkinTexture(@Nullable File cacheFile, String base64, class_2960 fallbackSkin, @Nullable Runnable callback) {
        super(fallbackSkin);
        this.cacheFile = cacheFile;
        this.base64 = base64;
        this.loadedCallback = callback;
    }

    private void onTextureLoaded(class_1011 image) {
        if (this.loadedCallback != null) {
            this.loadedCallback.run();
        }
        class_310.method_1551().execute(() -> {
            this.loaded = true;
            if (!RenderSystem.isOnRenderThread()) {
                RenderSystem.recordRenderCall(() -> this.uploadTexture(image));
            } else {
                this.uploadTexture(image);
            }
        });
    }

    private void uploadTexture(class_1011 image) {
        TextureUtil.prepareImage((int)this.method_4624(), (int)image.method_4307(), (int)image.method_4323());
        image.method_4301(0, 0, 0, true);
    }

    public void method_4625(class_3300 manager) throws IOException {
        class_310.method_1551().execute(() -> {
            if (!this.loaded) {
                try {
                    super.method_4625(manager);
                }
                catch (IOException var3x) {
                    LOGGER.warn("Failed to load texture: {}", (Object)this.field_5224, (Object)var3x);
                }
                this.loaded = true;
            }
        });
        if (this.loader == null) {
            class_1011 nativeImage;
            if (this.cacheFile != null && this.cacheFile.isFile()) {
                LOGGER.debug("Loading http texture from local cache ({})", (Object)this.cacheFile);
                FileInputStream fileInputStream = new FileInputStream(this.cacheFile);
                nativeImage = this.loadTexture(fileInputStream);
            } else {
                nativeImage = null;
            }
            if (nativeImage != null) {
                this.onTextureLoaded(nativeImage);
            } else {
                this.loader = CompletableFuture.runAsync(() -> {
                    LOGGER.debug("Getting base64 texture from {} to {}", (Object)this.base64, (Object)this.cacheFile);
                    try {
                        InputStream inputStream = this.base64ToString(this.base64);
                        if (this.cacheFile != null && inputStream != null) {
                            FileUtils.copyInputStreamToFile((InputStream)inputStream, (File)this.cacheFile);
                            inputStream = new FileInputStream(this.cacheFile);
                        }
                        InputStream finalInputStream = inputStream;
                        class_310.method_1551().execute(() -> {
                            class_1011 nativeImagex = this.loadTexture(finalInputStream);
                            if (nativeImagex != null) {
                                this.onTextureLoaded(nativeImagex);
                            }
                        });
                    }
                    catch (Exception var6) {
                        LOGGER.error("Couldn't download http texture", (Throwable)var6);
                    }
                }, class_156.method_18349());
            }
        }
    }

    @Nullable
    private class_1011 loadTexture(InputStream stream) {
        class_1011 nativeImage = null;
        try {
            nativeImage = class_1011.method_4309((InputStream)stream);
        }
        catch (Exception var4) {
            LOGGER.warn("Error while loading the skin texture", (Throwable)var4);
        }
        return nativeImage;
    }

    @Nullable
    private InputStream base64ToString(String base64String) {
        ByteArrayInputStream byteArrayInputStream;
        byte[] imageBytes = Base64.getDecoder().decode(base64String);
        ByteArrayInputStream bais = new ByteArrayInputStream(imageBytes);
        try {
            byteArrayInputStream = bais;
        }
        catch (Throwable throwable) {
            try {
                try {
                    bais.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                LOGGER.warn("Error while loading the base64 stream's texture", (Throwable)e);
                return null;
            }
        }
        bais.close();
        return byteArrayInputStream;
    }
}

