/*
 * Decompiled with CFR 0.152.
 */
package com.diamssword.greenresurgence.utils;

import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.function.Function;

public class Utils {
    public static UUID parseUUID(String uuid) {
        if (uuid.contains("-")) {
            return UUID.fromString(uuid);
        }
        return UUID.fromString(uuid.replaceFirst("(\\p{XDigit}{8})(\\p{XDigit}{4})(\\p{XDigit}{4})(\\p{XDigit}{4})(\\p{XDigit}+)", "$1-$2-$3-$4-$5"));
    }

    public static String UUIDToString(UUID uuid) {
        return uuid.toString().replaceAll("-", "");
    }

    public static <T> T selectRandomWeighted(List<T> items, Function<T, Float> weightFunction) {
        float totalWeight = 0.0f;
        for (T item : items) {
            totalWeight += weightFunction.apply(item).floatValue();
        }
        if (totalWeight == 0.0f) {
            return null;
        }
        float random = new Random().nextFloat() * totalWeight;
        float cumulativeWeight = 0.0f;
        for (T item : items) {
            if (!(random <= (cumulativeWeight += weightFunction.apply(item).floatValue()))) continue;
            return item;
        }
        return null;
    }
}

