/*
 * Decompiled with CFR 0.152.
 */
package com.diamssword.greenresurgence.blockEntities;

import com.diamssword.greenresurgence.GreenResurgence;
import com.diamssword.greenresurgence.containers.GridContainer;
import com.diamssword.greenresurgence.systems.lootables.IAdvancedLootableBlock;
import java.util.ArrayList;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import org.jetbrains.annotations.Nullable;

public class LootableShelfEntity
extends class_2586
implements IAdvancedLootableBlock {
    private final class_2371<class_1799> items = class_2371.method_10213((int)9, (Object)class_1799.field_8037);
    private int selectedIndex = -1;
    private int selectedCount = 0;
    private boolean isOff = false;
    private long lastBreak = 0L;

    public LootableShelfEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        nbt.method_10551("item");
        nbt.method_10569("selected", this.selectedIndex);
        nbt.method_10569("selectedCount", this.selectedCount);
        nbt.method_10556("isOff", this.isOff);
        class_1262.method_5426((class_2487)nbt, this.items);
    }

    @Override
    public boolean canBeInteracted() {
        return !this.isOff && !this.getItem().method_7960();
    }

    @Override
    public void lootBlock(class_1657 pl) {
        if (!this.isOff) {
            class_1799 st = this.getItem().method_7972();
            if (this.selectedCount == 0) {
                this.selectedCount = (int)(1.0 + Math.random() * (double)st.method_7947());
            }
            st.method_7939(this.selectedCount);
            this.isOff = true;
            this.lastBreak = System.currentTimeMillis();
            if (!pl.method_7270(st)) {
                pl.method_5775(st);
            }
            this.method_10997().method_8396(null, this.field_11867, class_3417.field_15197, class_3419.field_15245, 0.3f, 0.5f + (float)Math.random());
            this.saveAndUpdate();
        }
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887() {
        return this.method_38244();
    }

    protected void saveAndUpdate() {
        this.method_5431();
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            class_3218 sw = (class_3218)class_19372;
            sw.method_14178().method_14128(this.field_11867);
        }
    }

    public static <T extends class_2586> void tick(class_1937 world, class_2338 pos, class_2680 blockState, LootableShelfEntity t) {
        if (world.method_8510() % 100L == 0L && t.isOff && !world.field_9236 && System.currentTimeMillis() > t.lastBreak + (long)GreenResurgence.CONFIG.serverOptions.cooldowns.respawnShelvesLootInSec() * 1000L) {
            t.isOff = false;
            for (int i = 0; i < 100; ++i) {
                t.selectedIndex = t.selectASlot();
                t.selectedCount = (int)(1.0 + Math.random() * (double)((class_1799)t.items.get(t.selectedIndex)).method_7947());
                if (!t.getItem().method_7960()) break;
            }
            t.saveAndUpdate();
        }
    }

    private int selectASlot() {
        ArrayList<Integer> ls = new ArrayList<Integer>();
        for (int i = 0; i < this.items.size(); ++i) {
            if (((class_1799)this.items.get(i)).method_7960()) continue;
            ls.add(i);
        }
        if (ls.isEmpty()) {
            return -1;
        }
        return (Integer)ls.get((int)(Math.random() * (double)ls.size()));
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        class_1262.method_5429((class_2487)nbt, this.items);
        this.selectedIndex = Math.min(nbt.method_10550("selected"), this.items.size());
        this.selectedCount = nbt.method_10550("selectedCount");
        this.isOff = nbt.method_10577("isOff");
        if (this.selectedIndex < 0 || this.getItem().method_7960()) {
            this.selectedIndex = this.selectASlot();
        }
    }

    public class_1799 getItem() {
        if (this.isOff || this.selectedIndex < 0 || this.selectedIndex >= this.items.size()) {
            return class_1799.field_8037;
        }
        return ((class_1799)this.items.get(this.selectedIndex)).method_46651(this.selectedCount);
    }

    public GridContainer getContainer() {
        class_1277 inv = new class_1277((class_1799[])this.items.toArray((Object[])new class_1799[0]));
        inv.method_5489(c -> {
            for (int i = 0; i < c.method_5439(); ++i) {
                this.items.set(i, (Object)c.method_5438(i));
                this.selectedCount = (int)(1.0 + Math.random() * (double)this.getItem().method_7947());
            }
            this.saveAndUpdate();
        });
        return new GridContainer("container", (class_1263)inv, 9, 1);
    }
}

