/*
 * Decompiled with CFR 0.152.
 */
package com.diamssword.greenresurgence.blockEntities;

import com.diamssword.greenresurgence.GreenResurgence;
import com.diamssword.greenresurgence.containers.Containers;
import com.diamssword.greenresurgence.containers.GridContainer;
import com.diamssword.greenresurgence.containers.IGridContainer;
import com.diamssword.greenresurgence.containers.MultiInvScreenHandler;
import com.diamssword.greenresurgence.systems.lootables.LootableLogic;
import com.diamssword.greenresurgence.systems.lootables.Lootables;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3917;
import net.minecraft.class_7871;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class LootedBlockEntity
extends class_2586 {
    public static final int MAX = 5;
    public int durability = 5;
    public long lastBreak = 0L;
    public class_1277 inventory;
    public class_2680 block;
    public class_2680 emptyBlock;

    public LootedBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public class_2680 getRealBlock() {
        return this.block != null ? this.block : class_2246.field_10124.method_9564();
    }

    public class_2680 getDisplayBlock() {
        if (this.emptyBlock == null && this.block != null) {
            this.emptyBlock = LootableLogic.copyStateProperties(this.block, Lootables.getEmptyBlock(this.block.method_26204()));
        }
        if (this.durability <= 0) {
            return this.emptyBlock;
        }
        return this.getRealBlock();
    }

    public void setRealBlock(class_2680 state) {
        this.block = state;
        this.emptyBlock = LootableLogic.copyStateProperties(state, Lootables.getEmptyBlock(this.block.method_26204()));
        boolean w = false;
        class_2680 db = this.getDisplayBlock();
        if (db.method_28501().contains(class_2741.field_12508)) {
            w = (Boolean)db.method_11654((class_2769)class_2741.field_12508);
        }
        this.field_11863.method_8501(this.field_11867, (class_2680)this.method_10997().method_8320(this.field_11867).method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(w)));
        this.method_5431();
        this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 3);
    }

    public void restoreDurability() {
        this.field_11863.method_8501(this.field_11867, this.getRealBlock());
    }

    public void attackBlock(class_3222 player) {
        if (this.durability > 0) {
            LootableLogic.giveLoot(player, this.field_11867, this.getRealBlock());
            this.method_10997().method_8396(null, this.field_11867, class_3417.field_14742, class_3419.field_15245, 0.5f, 1.0f + (float)Math.random());
            this.method_10997().method_20290(2001, this.field_11867, class_2248.method_9507((class_2680)this.getRealBlock()));
            --this.durability;
            if (this.durability == 0) {
                this.inventory = null;
            }
            this.lastBreak = System.currentTimeMillis();
            this.method_5431();
            this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 3);
        }
    }

    public void openInventory(class_3222 player) {
        if (this.inventory == null) {
            this.createInventory(player);
        }
        Containers.createHandler((class_1657)player, this.field_11867, (sync, inv, p1) -> new Container(sync, (class_1657)player, new GridContainer("loot", (class_1263)this.inventory, 3, 3)));
    }

    private void createInventory(class_3222 player) {
        this.lastBreak = System.currentTimeMillis();
        this.inventory = new class_1277(9);
        this.inventory.method_5489(ls -> this.method_5431());
        LootableLogic.createLootInventory(player, this.field_11867, this.getRealBlock(), (class_1263)this.inventory);
        this.method_5431();
    }

    public void method_11007(class_2487 nbt) {
        nbt.method_10569("durability", this.durability);
        nbt.method_10544("lastBreak", this.lastBreak);
        if (this.block == null) {
            this.block = class_2246.field_10124.method_9564();
        }
        nbt.method_10566("block", (class_2520)class_2512.method_10686((class_2680)this.block));
        if (this.inventory != null) {
            nbt.method_10566("inventory", (class_2520)this.inventory.method_7660());
        }
        super.method_11007(nbt);
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.durability = nbt.method_10550("durability");
        this.lastBreak = nbt.method_10537("lastBreak");
        this.block = class_2512.method_10681((class_7871)class_7923.field_41175.method_46771(), (class_2487)nbt.method_10562("block"));
        this.emptyBlock = LootableLogic.copyStateProperties(this.block, Lootables.getEmptyBlock(this.block.method_26204()));
        if (nbt.method_10545("inventory")) {
            this.inventory = new class_1277(9);
            this.inventory.method_7659(nbt.method_10554("inventory", 10));
            this.inventory.method_5489(ls -> this.method_5431());
        }
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887() {
        return this.method_38244();
    }

    public static <T extends class_2586> void tick(class_1937 world, class_2338 pos, class_2680 blockState, LootedBlockEntity t) {
        if (world.method_8510() % 100L == 0L && System.currentTimeMillis() > t.lastBreak + (long)GreenResurgence.CONFIG.serverOptions.cooldowns.respawnLootedBlockInSec() * 1000L) {
            t.restoreDurability();
        }
    }

    public static class Container
    extends MultiInvScreenHandler {
        public Container(int syncId, class_1661 playerInventory) {
            super(syncId, playerInventory);
        }

        public Container(int syncId, class_1657 player, IGridContainer ... inventories) {
            super(syncId, player, inventories);
        }

        @Override
        public class_3917<Container> type() {
            return Containers.LOOTABLE_INV;
        }
    }
}

