/*
 * Decompiled with CFR 0.152.
 */
package com.diamssword.greenresurgence.containers;

import com.diamssword.greenresurgence.containers.AbstractMultiInvScreenHandler;
import com.diamssword.greenresurgence.containers.GridContainerSyncer;
import com.diamssword.greenresurgence.containers.IGridContainer;
import com.diamssword.greenresurgence.containers.player.CustomPlayerInventory;
import com.diamssword.greenresurgence.entities.BackpackEntity;
import com.diamssword.greenresurgence.items.AbstractBackpackItem;
import com.diamssword.greenresurgence.systems.Components;
import com.diamssword.greenresurgence.systems.character.PlayerInventoryData;
import io.wispforest.owo.client.screens.SyncedProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_3222;
import net.minecraft.class_3917;
import org.jetbrains.annotations.Nullable;

public abstract class MultiInvScreenHandler
extends AbstractMultiInvScreenHandler<MultiInvScreenHandler> {
    private final SyncedProperty<GridContainerSyncer> props;
    private CustomPlayerInventory playerInventory;
    protected IGridContainer[] inventories;
    protected final Map<String, List<class_1735>> inventoriesMap = new HashMap<String, List<class_1735>>();
    protected final Map<String, Integer[]> sizeMap = new HashMap<String, Integer[]>();
    @Nullable
    private class_2338 inventoryPos;
    private boolean ready = false;
    private final List<Consumer<MultiInvScreenHandler>> listeners = new ArrayList<Consumer<MultiInvScreenHandler>>();

    public MultiInvScreenHandler(int syncId, class_1661 playerInventory) {
        super(null, syncId);
        this.props = this.createProperty(GridContainerSyncer.class, new GridContainerSyncer());
        this.props.observe(c -> {
            this.inventoryPos = ((GridContainerSyncer)this.props.get()).inventoryPos;
            for (IGridContainer inventory : this.inventories = this.containersFromProps((GridContainerSyncer)c)) {
                this.addSlotsFor(inventory);
            }
            this.ready = true;
            this.listeners.forEach(v -> v.accept(this));
        });
    }

    public class_1661 getPlayerInventory() {
        IGridContainer pl = this.getInventory("player");
        if (pl instanceof class_1661) {
            return (class_1661)pl;
        }
        return null;
    }

    @Override
    public List<String> getInventoriesNames() {
        return this.inventoriesMap.keySet().stream().toList();
    }

    @Override
    public IGridContainer[] containersFromProps(GridContainerSyncer prop) {
        return prop.getContainers();
    }

    public void method_7595(class_1657 player) {
        class_1799 itemStack;
        if (player instanceof class_3222 && !(itemStack = this.method_34255()).method_7960()) {
            if (player.method_5805() && !((class_3222)player).method_14239()) {
                if (!this.playerInventory.InventoryScreenNeedRefresh && itemStack.method_7909() instanceof AbstractBackpackItem) {
                    BackpackEntity.dropItemBackpack(player, itemStack);
                } else {
                    this.playerInventory.setCursorStack(itemStack);
                }
            } else {
                player.method_7328(itemStack, false);
            }
            this.method_34254(class_1799.field_8037);
        }
    }

    public MultiInvScreenHandler(int syncId, class_1657 player, IGridContainer ... inventories) {
        super(null, syncId);
        for (IGridContainer iGridContainer : inventories) {
            MultiInvScreenHandler.method_17359((class_1263)iGridContainer.getInventory(), (int)iGridContainer.getSize());
            iGridContainer.getInventory().method_5435(player);
        }
        this.ready = true;
        this.playerInventory = ((PlayerInventoryData)player.getComponent(Components.PLAYER_INVENTORY)).getInventory();
        this.method_34254(this.playerInventory.getAndClearCursorStack());
        List<IGridContainer> ls = this.playerInventory.getAsContainers();
        ls.addAll(Arrays.asList(inventories));
        this.inventories = ls.toArray(new IGridContainer[0]);
        this.props = this.createProperty(GridContainerSyncer.class, new GridContainerSyncer(this.inventoryPos, this.inventories));
        this.props.markDirty();
        for (IGridContainer inventory : this.inventories) {
            this.addSlotsFor(inventory);
        }
    }

    public MultiInvScreenHandler(int syncId, class_1657 player, boolean empty) {
        super(null, syncId);
        this.ready = true;
        this.playerInventory = ((PlayerInventoryData)player.getComponent(Components.PLAYER_INVENTORY)).getInventory();
        this.method_34254(this.playerInventory.getAndClearCursorStack());
        this.inventories = this.playerInventory.getAsContainers().toArray(new IGridContainer[0]);
        this.props = this.createProperty(GridContainerSyncer.class, new GridContainerSyncer(this.inventoryPos, this.inventories));
        this.props.markDirty();
        for (IGridContainer inventory : this.inventories) {
            this.addSlotsFor(inventory);
        }
    }

    @Override
    public MultiInvScreenHandler setPos(class_2338 pos) {
        this.inventoryPos = pos;
        ((GridContainerSyncer)this.props.get()).inventoryPos = pos;
        this.props.markDirty();
        return this;
    }

    @Override
    public class_2338 getPos() {
        return this.inventoryPos;
    }

    @Override
    public abstract class_3917<? extends MultiInvScreenHandler> type();

    public class_3917<?> method_17358() {
        return this.type();
    }

    @Override
    public boolean isReady() {
        return this.ready;
    }

    @Override
    public void onReady(Consumer<MultiInvScreenHandler> consumer) {
        if (this.isReady()) {
            consumer.accept(this);
        } else {
            this.listeners.add(consumer);
        }
    }

    protected void addSlotsFor(IGridContainer container) {
        if (container.revert()) {
            for (int m = container.getHeight() - 1; m >= 0; --m) {
                for (int l = container.getWidth() - 1; l >= 0; --l) {
                    class_1735 s = this.createSlot(container, container.getStartIndex() + l + m * container.getWidth(), l * 18, m * 18);
                    this.method_7621(s);
                    this.inventoriesMap.putIfAbsent(container.getName(), new ArrayList());
                    this.inventoriesMap.get(container.getName()).add(s);
                }
            }
        } else {
            for (int m = 0; m < container.getHeight(); ++m) {
                for (int l = 0; l < container.getWidth(); ++l) {
                    class_1735 s = this.createSlot(container, container.getStartIndex() + l + m * container.getWidth(), l * 18, m * 18);
                    this.method_7621(s);
                    this.inventoriesMap.putIfAbsent(container.getName(), new ArrayList());
                    this.inventoriesMap.get(container.getName()).add(s);
                }
            }
        }
        this.sizeMap.put(container.getName(), new Integer[]{container.getWidth(), container.getHeight()});
    }

    protected class_1735 createSlot(IGridContainer container, int index, int x, int y) {
        return container.createSlotFor(index, x, y);
    }

    @Override
    public List<class_1735> getSlotForInventory(String name) {
        return this.inventoriesMap.getOrDefault(name, new ArrayList());
    }

    @Override
    public String getInventoryForSlot(class_1735 s) {
        for (String id : this.inventoriesMap.keySet()) {
            if (!this.inventoriesMap.get(id).contains(s)) continue;
            return id;
        }
        return null;
    }

    @Override
    public String getInventoryForSlot(int slotID) {
        for (String id : this.inventoriesMap.keySet()) {
            if (!this.inventoriesMap.get(id).stream().anyMatch(s -> s.method_34266() == slotID)) continue;
            return id;
        }
        return null;
    }

    @Override
    public IGridContainer getInventory(String name) {
        for (IGridContainer inventory : this.inventories) {
            if (!inventory.getName().equals(name)) continue;
            return inventory;
        }
        return null;
    }

    @Override
    public IGridContainer getContainerFor(int slot) {
        class_1735 s = (class_1735)this.field_7761.get(slot);
        for (String string : this.inventoriesMap.keySet()) {
            List<class_1735> b = this.inventoriesMap.get(string);
            if (!b.contains(s)) continue;
            return this.getInventory(string);
        }
        return null;
    }

    public boolean method_7597(class_1657 player) {
        for (IGridContainer inventory : this.inventories) {
            if (inventory.getInventory().method_5443(player)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean canUse(class_1657 player, String containerID) {
        IGridContainer inv = this.getInventory(containerID);
        if (inv != null) {
            return inv.getInventory().method_5443(player);
        }
        return false;
    }

    @Override
    public int totalSize() {
        int s = 0;
        for (IGridContainer inventory : this.inventories) {
            s += inventory.getInventory().method_5439();
        }
        return s;
    }

    public class_1799 method_7601(class_1657 player, int invSlot) {
        class_1799 newStack = class_1799.field_8037;
        class_1735 slot = (class_1735)this.field_7761.get(invSlot);
        if (slot != null && slot.method_7681()) {
            class_1799 originalStack = slot.method_7677();
            newStack = originalStack.method_7972();
            IGridContainer cont = this.getContainerFor(invSlot);
            if (cont != null && !this.insertItem(cont, originalStack, !cont.isPlayerContainer())) {
                return class_1799.field_8037;
            }
            if (originalStack.method_7960()) {
                slot.method_48931(class_1799.field_8037);
            } else {
                slot.method_7668();
            }
        }
        return newStack;
    }

    protected boolean insertItem(IGridContainer origin, class_1799 stack, boolean fromContainer) {
        boolean bl;
        block13: {
            List<IGridContainer> invs;
            block14: {
                bl = false;
                invs = Arrays.stream(this.inventories).filter(v -> v.isPlayerContainer() == fromContainer).toList();
                if (invs.isEmpty() && !fromContainer) {
                    invs = Arrays.stream(this.inventories).filter(v -> v != origin).sorted((a, b) -> b.getQuickSlotPriority(stack) - a.getQuickSlotPriority(stack)).toList();
                }
                if (!stack.method_7946()) break block14;
                for (IGridContainer inv : invs) {
                    for (class_1735 slot : this.getSlotForInventory(inv.getName())) {
                        class_1799 itemstack = slot.method_7677();
                        if (!itemstack.method_7960() && class_1799.method_31577((class_1799)stack, (class_1799)itemstack)) {
                            int j = itemstack.method_7947() + stack.method_7947();
                            if (j <= stack.method_7914()) {
                                stack.method_7939(0);
                                itemstack.method_7939(j);
                                slot.method_7668();
                                bl = true;
                            } else if (itemstack.method_7947() < stack.method_7914()) {
                                stack.method_7934(stack.method_7914() - itemstack.method_7947());
                                itemstack.method_7939(stack.method_7914());
                                slot.method_7668();
                                bl = true;
                            }
                        }
                        if (itemstack.method_7960() && slot.method_7680(stack)) {
                            if (stack.method_7947() <= slot.method_7675()) {
                                slot.method_48931(stack.method_7971(stack.method_7947()));
                                return true;
                            }
                            slot.method_48931(stack.method_7971(slot.method_7675()));
                            slot.method_7668();
                            bl = true;
                        }
                        if (!stack.method_7960()) continue;
                        break;
                    }
                    if (!stack.method_7960()) continue;
                    break block13;
                }
                break block13;
            }
            if (stack.method_7960()) break block13;
            for (IGridContainer inv : invs) {
                for (class_1735 slot : this.getSlotForInventory(inv.getName())) {
                    class_1799 itemstack = slot.method_7677();
                    if (!itemstack.method_7960() || !slot.method_7680(stack)) continue;
                    if (stack.method_7947() > slot.method_7675()) {
                        slot.method_48931(stack.method_7971(slot.method_7675()));
                    } else {
                        slot.method_48931(stack.method_7971(stack.method_7947()));
                    }
                    slot.method_7668();
                    return true;
                }
            }
        }
        return bl;
    }
}

