/*
 * Decompiled with CFR 0.152.
 */
package com.diamssword.greenresurgence.datagen;

import com.diamssword.greenresurgence.datagen.LangGenerator;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Map;
import net.minecraft.class_2248;
import net.minecraft.class_4917;

public record SchematicBlockStateSupplier(class_2248 block, String baseModel, Map<String, String> searchAndReplace) implements class_4917
{
    public class_2248 method_25743() {
        return this.block;
    }

    public JsonElement get() {
        return this.deepCopyWithStringReplace((JsonElement)this.getModel(), this.searchAndReplace);
    }

    private JsonElement deepCopyWithStringReplace(JsonElement input, Map<String, String> replacement) {
        if (input == null || input.isJsonNull()) {
            return JsonNull.INSTANCE;
        }
        if (input.isJsonObject()) {
            JsonObject obj = input.getAsJsonObject();
            JsonObject newObj = new JsonObject();
            for (Map.Entry entry : obj.entrySet()) {
                newObj.add((String)entry.getKey(), this.deepCopyWithStringReplace((JsonElement)entry.getValue(), replacement));
            }
            return newObj;
        }
        if (input.isJsonArray()) {
            JsonArray arr = input.getAsJsonArray();
            JsonArray newArr = new JsonArray();
            for (JsonElement item : arr) {
                newArr.add(this.deepCopyWithStringReplace(item, replacement));
            }
            return newArr;
        }
        if (input.isJsonPrimitive()) {
            JsonPrimitive prim = input.getAsJsonPrimitive();
            if (prim.isString()) {
                String str = prim.getAsString();
                for (Map.Entry<String, String> d : replacement.entrySet()) {
                    str = str.replace("$" + d.getKey(), d.getValue());
                }
                return new JsonPrimitive(str);
            }
            return prim.deepCopy();
        }
        return input.deepCopy();
    }

    private JsonObject getModel() {
        JsonObject jsonObject;
        block8: {
            Gson gson = new Gson();
            Path path = LangGenerator.getDevPath("models/blockstates/" + this.baseModel + ".json");
            BufferedReader reader = Files.newBufferedReader(path);
            try {
                jsonObject = (JsonObject)gson.fromJson((Reader)reader, JsonObject.class);
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return null;
                }
            }
            ((Reader)reader).close();
        }
        return jsonObject;
    }
}

