/*
 * Decompiled with CFR 0.152.
 */
package com.diamssword.greenresurgence.gui;

import com.diamssword.characters.api.CharactersApi;
import com.diamssword.characters.api.ComponentManager;
import com.diamssword.characters.api.IPlayerComponent;
import com.diamssword.characters.api.appearence.Cloth;
import com.diamssword.characters.api.appearence.LayerDef;
import com.diamssword.greenresurgence.GreenResurgence;
import com.diamssword.greenresurgence.gui.OutfitPopupGui;
import com.diamssword.greenresurgence.gui.components.ClothButtonComponent;
import com.diamssword.greenresurgence.gui.components.FreeRowGridLayout;
import com.diamssword.greenresurgence.gui.components.PlayerComponent;
import com.diamssword.greenresurgence.gui.components.RButtonComponent;
import io.wispforest.owo.ui.base.BaseUIModelScreen;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.component.SlimSliderComponent;
import io.wispforest.owo.ui.component.TextBoxComponent;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3545;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_5250;

@Environment(value=EnvType.CLIENT)
public class WardrobeGui
extends BaseUIModelScreen<FlowLayout> {
    public static final String CHSHEET_ID = "character_sheet";
    private final List<class_3545<String, LayerDef[]>> layerBts = new ArrayList<class_3545<String, LayerDef[]>>();
    private final boolean shouldShowOutifits;
    private final Function<class_1657, Map<String, Cloth>> equippedProvider;
    private class_3545<String, LayerDef[]> currentLayer;
    private Map<String, Cloth> oldCloths;
    private String lastSearch = "";

    public WardrobeGui(String type) {
        super(FlowLayout.class, BaseUIModelScreen.DataSource.asset((class_2960)GreenResurgence.asRessource("wardrobe")));
        List<LayerDef> layers;
        if (type == null || type.equals("default")) {
            this.shouldShowOutifits = true;
            layers = CharactersApi.clothing().getClothLayers();
            this.layerBts.add((class_3545<String, LayerDef[]>)new class_3545((Object)"all", (Object)layers.toArray(new LayerDef[0])));
            this.layerBts.add((class_3545<String, LayerDef[]>)new class_3545((Object)"current", (Object)layers.toArray(new LayerDef[0])));
            this.equippedProvider = p -> ComponentManager.getPlayerDatas((class_1657)p).getAppearence().getEquippedCloths();
        } else {
            this.shouldShowOutifits = false;
            layers = CharactersApi.clothing().getLayers().values().stream().filter(v -> type.equals(v.getSpecialEditor())).toList();
            this.equippedProvider = p -> ComponentManager.getPlayerDatas((class_1657)p).getAppearence().getEquippedLayers();
        }
        for (LayerDef l : layers) {
            this.layerBts.add((class_3545<String, LayerDef[]>)new class_3545((Object)l.getId(), (Object)new LayerDef[]{l}));
        }
        this.currentLayer = this.layerBts.get(0);
    }

    private void loadCloths(FreeRowGridLayout layout, PlayerComponent playerComp, String filter) {
        this.lastSearch = filter;
        class_1657 player = playerComp.entity();
        IPlayerComponent dt = ComponentManager.getPlayerDatas((class_1657)player);
        this.oldCloths = this.equippedProvider.apply(player);
        List<Cloth> equip = this.oldCloths.values().stream().filter(Objects::nonNull).toList();
        List<Cloth> list = ((String)this.currentLayer.method_15442()).equals("current") ? equip : CharactersApi.clothing().getAvailablesClothsCollectionForPlayer((class_1657)class_310.method_1551().field_1724, "all", (LayerDef[])this.currentLayer.method_15441());
        if (!filter.isEmpty()) {
            list = list.stream().filter(v -> v.name().toLowerCase().contains(filter) || !v.collection().equals("default") && v.collection().toLowerCase().contains(filter)).toList();
        }
        layout.clear();
        for (Cloth c : list) {
            ClothButtonComponent bt = new ClothButtonComponent(c);
            bt.onPress(__ -> {
                Cloth v = bt.getCloth();
                if (this.oldCloths.containsValue(v)) {
                    dt.getAppearence().setCloth(v.layer().id, null);
                    CharactersApi.clothing().clientAskEquipCloth(new class_2960("null", "null"), v.layer().getId());
                } else {
                    dt.getAppearence().setCloth(v.layer().id, v);
                    CharactersApi.clothing().clientAskEquipCloth(v.id(), v.layer().toString());
                }
                this.oldCloths = this.equippedProvider.apply(player);
                this.updateSelected(layout, this.oldCloths.values().stream().filter(Objects::nonNull).toList());
            });
            bt.onClothHovered().subscribe(v -> {
                if (v != null) {
                    dt.getAppearence().setCloth(v);
                } else {
                    this.oldCloths.forEach((a, v1) -> dt.getAppearence().setCloth(a, v1));
                }
            });
            layout.child(bt.sizing(Sizing.fixed((int)30), Sizing.fixed((int)50)).margins(Insets.of((int)1)));
        }
        this.updateSelected(layout, equip);
    }

    private void updateSelected(FreeRowGridLayout layout, List<Cloth> equipped) {
        for (Component child : layout.children()) {
            if (!(child instanceof ClothButtonComponent)) continue;
            ClothButtonComponent cb = (ClothButtonComponent)child;
            cb.setSelected(equipped.stream().anyMatch(v -> v.id().equals((Object)cb.getCloth().id())));
        }
    }

    protected void build(FlowLayout rootComponent) {
        FreeRowGridLayout wardLay = (FreeRowGridLayout)rootComponent.childById(FreeRowGridLayout.class, "clothContainer");
        TextBoxComponent search = (TextBoxComponent)rootComponent.childById(TextBoxComponent.class, "search");
        FreeRowGridLayout flow = (FreeRowGridLayout)rootComponent.childById(FreeRowGridLayout.class, "layerLayout");
        LabelComponent txt1 = (LabelComponent)rootComponent.childById(LabelComponent.class, "title_right");
        PlayerComponent playerComp = (PlayerComponent)rootComponent.childById(PlayerComponent.class, "player");
        SlimSliderComponent slider = (SlimSliderComponent)rootComponent.childById(SlimSliderComponent.class, "slider");
        class_1657 player = playerComp.entity();
        IPlayerComponent dt = ComponentManager.getPlayerDatas((class_1657)player);
        dt.getAppearence().clonePlayerAppearance((class_1657)class_310.method_1551().field_1724);
        this.loadCloths(wardLay, playerComp, "");
        search.onChanged().subscribe(v -> this.loadCloths(wardLay, playerComp, v.toLowerCase()));
        search.method_47404((class_2561)class_2561.method_43470((String)"Recherche"));
        wardLay.focusGained().subscribe(v -> this.method_25395((class_364)search));
        List outfits = dt.getAppearence().getOutfits();
        slider.value(0.5);
        slider.onChanged().subscribe(v -> playerComp.rotation((int)(-180.0 + v * 360.0)));
        if (!this.shouldShowOutifits) {
            FlowLayout c = (FlowLayout)rootComponent.childById(FlowLayout.class, "outfits");
            c.clearChildren();
            c.surface(Surface.flat((int)0));
        } else {
            for (int i = 1; i <= 7; ++i) {
                class_5250 v2 = class_2561.method_43469((String)"character_sheet.wardrobe.outfitbt", (Object[])new Object[]{i});
                int i1 = i - 1;
                if (i1 < outfits.size()) {
                    v2 = class_2561.method_43470((String)((String)((class_3545)outfits.get(i1)).method_15442()));
                }
                ArrayList<class_5250> ar = new ArrayList<class_5250>();
                ar.add(v2);
                ar.add(class_2561.method_43471((String)"character_sheet.wardrobe.outfitbt.tooltip").method_27695(new class_124[]{class_124.field_1080, class_124.field_1056}));
                RButtonComponent bt = (RButtonComponent)rootComponent.childById(RButtonComponent.class, "memory" + i);
                bt.onPress(v1 -> {
                    if (class_437.method_25442()) {
                        this.createOutfitWindow((RButtonComponent)((Object)v1), i1);
                    } else {
                        CharactersApi.clothing().clientAskEquipOutfit(i1);
                        dt.getAppearence().equipOutfit(i1);
                        this.loadCloths(wardLay, playerComp, this.lastSearch);
                    }
                }).tooltip(ar);
                bt.method_25355((class_2561)v2);
            }
        }
        if (flow != null) {
            ArrayList<RButtonComponent> bts = new ArrayList<RButtonComponent>();
            for (class_3545<String, LayerDef[]> value : this.layerBts) {
                RButtonComponent bt = new RButtonComponent((class_2561)class_2561.method_43473(), o -> {
                    for (RButtonComponent d : bts) {
                        d.setActivated(false);
                    }
                    o.setActivated(true);
                    this.currentLayer = value;
                    txt1.text((class_2561)class_2561.method_43471((String)("green_resurgence.wardrobe.collection." + (String)this.currentLayer.method_15442())));
                    this.loadCloths(wardLay, playerComp, this.lastSearch);
                });
                if (((String)value.method_15442()).equals("all")) {
                    bt.setActivated(true);
                }
                bt.icon((String)value.method_15442()).sizing(Sizing.fixed((int)20)).tooltip((class_2561)class_2561.method_43471((String)("green_resurgence.wardrobe.layerbt." + (String)value.method_15442()))).margins(Insets.of((int)2, (int)0, (int)2, (int)0));
                flow.child((Component)bt);
                bts.add(bt);
            }
        }
    }

    private void createOutfitWindow(RButtonComponent bt, int index) {
        class_310.method_1551().method_1507((class_437)new OutfitPopupGui(this, index, bt));
    }

    public boolean method_25421() {
        return false;
    }
}

