/*
 * Decompiled with CFR 0.152.
 */
package com.diamssword.greenresurgence.gui.components;

import com.diamssword.greenresurgence.GreenResurgence;
import com.diamssword.greenresurgence.gui.RessourceGuiHelper;
import com.diamssword.greenresurgence.systems.crafting.RecipeCollection;
import com.diamssword.greenresurgence.systems.crafting.Recipes;
import com.diamssword.greenresurgence.systems.crafting.SimpleRecipe;
import com.diamssword.greenresurgence.systems.crafting.UniversalResource;
import com.mojang.blaze3d.systems.RenderSystem;
import io.wispforest.owo.ui.base.BaseComponent;
import io.wispforest.owo.ui.core.Color;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.OwoUIDrawContext;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.parsing.UIModel;
import io.wispforest.owo.ui.parsing.UIParsing;
import io.wispforest.owo.ui.util.UISounds;
import io.wispforest.owo.util.EventSource;
import io.wispforest.owo.util.EventStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_746;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Environment(value=EnvType.CLIENT)
public class ButtonInventoryComponentOld
extends BaseComponent {
    private final int slotSize = 18;
    public static final class_2960 SLOT_TEXTURE = GreenResurgence.asRessource("textures/gui/highlight.png");
    private final class_342 textField;
    private final EventStream<RecipePicked> onPicked = RecipePicked.newPickStream();
    private int scroll = 0;
    public class_2960 collectionID;
    private UniversalResource hovered;
    private RecipeCollection collection;
    private int columns = 3;
    private List<SimpleRecipe> items = new ArrayList<SimpleRecipe>();
    private Comparator<SimpleRecipe> sorter;
    private String lastResearch = "";
    protected boolean blend = false;
    private float time = 0.0f;

    protected ButtonInventoryComponentOld(Sizing size, class_2960 collectionID, RecipeCollection collection) {
        this.collectionID = collectionID;
        this.collection = collection;
        this.items = this.collection.getRecipes((class_1657)class_310.method_1551().field_1724);
        this.sizing(size);
        this.textField = new class_342(class_310.method_1551().field_1772, 1, 1, this.width, 10, (class_2561)class_2561.method_43473());
        this.textField.method_25365(true);
        this.textField.method_1888(true);
        this.textField.method_1858(false);
    }

    public void setCollection(RecipeCollection collection, class_2960 id) {
        this.collection = collection;
        this.collectionID = id;
        this.refreshSearch();
    }

    public Comparator<SimpleRecipe> getSorter() {
        return this.sorter;
    }

    public void setSorter(Comparator<SimpleRecipe> sorter) {
        this.sorter = sorter;
    }

    public void refreshSearch() {
        class_746 pl = class_310.method_1551().field_1724;
        this.items = this.lastResearch.isBlank() ? this.collection.getRecipes((class_1657)pl) : new ArrayList<SimpleRecipe>(this.collection.getRecipes((class_1657)pl).stream().filter(arg_0 -> this.lambda$refreshSearch$0((class_1657)pl, arg_0)).toList());
        if (this.sorter != null) {
            this.items.sort(this.sorter);
        }
    }

    public boolean canFocus(Component.FocusSource source) {
        return source == Component.FocusSource.MOUSE_CLICK;
    }

    public boolean onMouseDrag(double mouseX, double mouseY, double deltaX, double deltaY, int button) {
        if (this.isOnTextField(mouseX, mouseY)) {
            return this.textField.onMouseDrag(mouseX, mouseY, deltaX, deltaY, button);
        }
        if (mouseX > (double)(this.width - 10)) {
            float perc = Math.min(Math.max((float)mouseY / (float)this.width, 0.0f), 1.0f);
            this.scroll = (int)(perc * (float)(this.items.size() / this.columns)) / 2;
            return true;
        }
        return false;
    }

    public void applySizing() {
        super.applySizing();
        this.textField.method_25358(this.width - 12);
        this.columns = (this.width - 10) / 18;
    }

    public boolean onMouseDown(double mouseX, double mouseY, int button) {
        int d;
        super.onMouseDown(mouseX, mouseY, button);
        int x = (int)mouseX / 18;
        int y = (int)(mouseY - 10.0) / 18;
        int h = (this.height - 10) / 18;
        if (this.isOnTextField(mouseX, mouseY)) {
            return this.textField.onMouseDown(mouseX, mouseY, button);
        }
        if (x < this.columns && y < h && (d = this.scroll * this.columns + x + y * this.columns) < this.items.size()) {
            UISounds.playButtonSound();
            ((RecipePicked)this.onPicked.sink()).onPicked(this.items.get(d), this.collection, this.collectionID);
            return true;
        }
        return false;
    }

    public EventSource<RecipePicked> onRecipePicked() {
        return this.onPicked.source();
    }

    public void draw(OwoUIDrawContext context, int mouseX, int mouseY, float partialTicks, float delta) {
        if (!class_437.method_25441()) {
            this.time += delta;
        }
        RenderSystem.enableDepthTest();
        if (this.blend) {
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
        }
        class_4587 matrices = context.method_51448();
        matrices.method_22903();
        matrices.method_46416((float)this.x, (float)this.y, 0.0f);
        int h = (this.height - 10) / 18;
        this.hovered = null;
        context.method_25294(1, 1, this.width - 10, this.height - 1, -2710161);
        context.method_25294(this.width - 10, 1, this.width, this.height - 1, -6918590);
        int i = 0;
        int j = 0;
        this.hovered = null;
        for (int i1 = this.scroll * this.columns; i1 < Math.min(this.scroll * this.columns + h * this.columns, this.items.size()); ++i1) {
            UniversalResource it = this.items.get(i1).result((class_1657)class_310.method_1551().field_1724);
            int w1 = 1 + i * 18;
            int h1 = 10 + j * 18;
            if (mouseX >= this.x + w1 && mouseX <= this.x + w1 + 18 && mouseY >= this.y + h1 && mouseY <= this.y + h1 + 18) {
                this.hovered = it;
                context.method_25290(SLOT_TEXTURE, w1, h1, 0.0f, 0.0f, 18, 18, 32, 32);
            }
            this.drawResource(it, context, w1 + 1, h1 + 1);
            if (++i < this.columns) continue;
            ++j;
            i = 0;
        }
        context.method_25290(SLOT_TEXTURE, this.width - 9, (int)(1.0f + (float)(this.height - 13) * this.getScrollPercent()), 18.0f, 0.0f, 8, 11, 32, 32);
        context.drawRectOutline(0, 0, this.width, this.height, -5012142);
        context.drawLine(this.width - 10, 1, this.width - 10, this.height, 1.0, Color.ofArgb((int)-5012142));
        context.drawLine(0, 10, this.width - 10, 10, 1.0, Color.ofArgb((int)-5012142));
        this.textField.method_25394((class_332)context, mouseX, mouseY, delta);
        if (this.blend) {
            RenderSystem.disableBlend();
        }
        matrices.method_22909();
    }

    protected void drawResource(UniversalResource resource, OwoUIDrawContext context, int x, int y) {
        RessourceGuiHelper.drawRessource(context, resource, x, y, this.time);
    }

    public void drawTooltip(OwoUIDrawContext context, int mouseX, int mouseY, float partialTicks, float delta) {
        super.drawTooltip(context, mouseX, mouseY, partialTicks, delta);
        RessourceGuiHelper.drawTooltip(context, this.hovered, mouseX, mouseY, this.time);
    }

    public float getScrollPercent() {
        if (this.items.isEmpty()) {
            return 0.0f;
        }
        float f = this.scroll * this.columns;
        return Math.min(f * 2.0f / (float)(this.items.size() + 4), 1.0f);
    }

    public void scroll(int value) {
        float perc = this.getScrollPercent();
        if (value < 0 && perc < 1.0f) {
            ++this.scroll;
        } else if (value > 0) {
            this.scroll = Math.max(0, this.scroll - 1);
        }
    }

    private boolean isOnTextField(double mouseX, double mouseY) {
        return mouseY < 10.0 && mouseX < (double)(this.width - 10);
    }

    public boolean onMouseScroll(double mouseX, double mouseY, double amount) {
        this.scroll((int)amount);
        if (this.isOnTextField(mouseX, mouseY)) {
            return this.textField.onMouseScroll(mouseX, mouseY, amount);
        }
        super.onMouseScroll(mouseX, mouseY, amount);
        return true;
    }

    public boolean onKeyPress(int keyCode, int scanCode, int modifiers) {
        boolean v = this.textField.onKeyPress(keyCode, scanCode, modifiers);
        if (!this.textField.method_1882().trim().equals(this.lastResearch)) {
            this.lastResearch = this.textField.method_1882().toLowerCase().trim();
            this.refreshSearch();
        }
        return v;
    }

    public boolean onCharTyped(char chr, int modifiers) {
        boolean v = this.textField.method_25400(chr, modifiers);
        if (!this.textField.method_1882().trim().equals(this.lastResearch)) {
            this.lastResearch = this.textField.method_1882().toLowerCase().trim();
            this.refreshSearch();
        }
        return v;
    }

    public void parseProperties(UIModel model, Element element, Map<String, Element> children) {
        super.parseProperties(model, element, children);
    }

    public static ButtonInventoryComponentOld parse(Element element) {
        UIParsing.expectAttributes((Element)element, (String[])new String[]{"collection"});
        class_2960 invId = UIParsing.parseIdentifier((Node)element.getAttributeNode("collection"));
        RecipeCollection r = Recipes.get(invId).orElse(new RecipeCollection(new class_2960("minecraft:void")));
        return new ButtonInventoryComponentOld(Sizing.fill((int)100), invId, r);
    }

    private /* synthetic */ boolean lambda$refreshSearch$0(class_1657 pl, SimpleRecipe v) {
        return v.result(pl).getName().getString().toLowerCase().trim().contains(this.lastResearch);
    }

    @Environment(value=EnvType.CLIENT)
    public static interface RecipePicked {
        public boolean onPicked(SimpleRecipe var1, RecipeCollection var2, class_2960 var3);

        public static EventStream<RecipePicked> newPickStream() {
            return new EventStream(subscribers -> (picked, collection, collectionID) -> {
                boolean anyTriggered = false;
                for (RecipePicked subscriber : subscribers) {
                    anyTriggered |= subscriber.onPicked(picked, collection, collectionID);
                }
                return anyTriggered;
            });
        }
    }
}

