/*
 * Decompiled with CFR 0.152.
 */
package com.diamssword.greenresurgence.gui.components;

import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.OwoUIDrawContext;
import io.wispforest.owo.ui.core.ParentComponent;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import io.wispforest.owo.ui.parsing.UIModel;
import io.wispforest.owo.ui.parsing.UIParsing;
import io.wispforest.owo.ui.util.UISounds;
import java.util.Map;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.w3c.dom.Element;

@Environment(value=EnvType.CLIENT)
public class ClickableLayoutComponent
extends FlowLayout {
    private Surface surface2;
    private Consumer<ClickableLayoutComponent> onPress = v -> {};

    public ClickableLayoutComponent(Sizing horizontalSizing, Sizing verticalSizing, FlowLayout.Algorithm algorithm) {
        super(horizontalSizing, verticalSizing, algorithm);
    }

    public void parseProperties(UIModel model, Element element, Map<String, Element> children) {
        super.parseProperties(model, element, children);
        UIParsing.apply(children, (String)"surface2", Surface::parse, this::surface2);
    }

    protected void updateLayout() {
        super.updateLayout();
        this.children.forEach(v -> v.cursorStyle(this.cursorStyle));
    }

    public ClickableLayoutComponent onPress(Consumer<ClickableLayoutComponent> onPress) {
        this.onPress = onPress;
        return this;
    }

    public ParentComponent surface2(Surface surface) {
        this.surface2 = surface;
        return this;
    }

    public void draw(OwoUIDrawContext context, int mouseX, int mouseY, float partialTicks, float delta) {
        if (mouseX >= this.x && mouseY >= this.y && mouseX <= this.x + this.width && mouseY <= this.y + this.height && this.surface2 != null) {
            this.surface2.draw(context, (ParentComponent)this);
        } else {
            this.surface.draw(context, (ParentComponent)this);
        }
        this.drawChildren(context, mouseX, mouseY, partialTicks, delta, this.children);
    }

    public boolean onMouseDown(double mouseX, double mouseY, int button) {
        super.onMouseDown(mouseX, mouseY, button);
        UISounds.playButtonSound();
        if (this.onPress != null) {
            this.onPress.accept(this);
        }
        return true;
    }

    public boolean canFocus(Component.FocusSource source) {
        return source == Component.FocusSource.MOUSE_CLICK;
    }

    public static FlowLayout parse(Element element) {
        UIParsing.expectAttributes((Element)element, (String[])new String[]{"direction"});
        return switch (element.getAttribute("direction")) {
            case "horizontal" -> new ClickableLayoutComponent(Sizing.content(), Sizing.content(), FlowLayout.Algorithm.HORIZONTAL);
            case "ltr-text-flow" -> new ClickableLayoutComponent(Sizing.content(), Sizing.content(), FlowLayout.Algorithm.LTR_TEXT);
            default -> new ClickableLayoutComponent(Sizing.content(), Sizing.content(), FlowLayout.Algorithm.VERTICAL);
        };
    }
}

