/*
 * Decompiled with CFR 0.152.
 */
package com.diamssword.greenresurgence.gui.components;

import io.wispforest.owo.ui.base.BaseParentComponent;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.OwoUIDrawContext;
import io.wispforest.owo.ui.core.ParentComponent;
import io.wispforest.owo.ui.core.Size;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.parsing.UIModel;
import io.wispforest.owo.ui.parsing.UIParsing;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.apache.commons.lang3.mutable.MutableInt;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Environment(value=EnvType.CLIENT)
public class FreeRowGridLayout
extends BaseParentComponent {
    protected final int columns;
    private boolean inverted = false;
    protected final List<Component> children = new ArrayList<Component>();
    protected Size contentSize = Size.zero();

    protected FreeRowGridLayout(Sizing horizontalSizing, Sizing verticalSizing, int columns) {
        super(horizontalSizing, verticalSizing);
        this.columns = columns;
    }

    protected int determineHorizontalContentSize(Sizing sizing) {
        return this.contentSize.width() + ((Insets)this.padding.get()).right();
    }

    protected int determineVerticalContentSize(Sizing sizing) {
        return this.contentSize.height() + ((Insets)this.padding.get()).bottom();
    }

    public void layout(Size space) {
        int[] columnSizes = new int[this.columns];
        int[] rowSizes = new int[this.rows()];
        Size childSpace = this.calculateChildSpace(space);
        for (Component child2 : this.children) {
            if (child2 == null) continue;
            child2.inflate(childSpace);
        }
        this.determineSizes(columnSizes, false);
        this.determineSizes(rowSizes, true);
        Size mountingOffset = this.childMountingOffset();
        MutableInt layoutX = new MutableInt(this.x + mountingOffset.width());
        MutableInt layoutY = new MutableInt(this.y + mountingOffset.height());
        MutableInt layoutYInv = new MutableInt(this.y + mountingOffset.height());
        if (this.inverted) {
            for (int dy : rowSizes) {
                layoutYInv.add(dy);
            }
        }
        for (int row = 0; row < this.rows(); ++row) {
            layoutX.setValue(this.x + mountingOffset.width());
            if (this.inverted) {
                layoutYInv.add(-rowSizes[row]);
            }
            for (int column = 0; column < this.columns; ++column) {
                int columnSize = columnSizes[column];
                int rowSize = rowSizes[row];
                this.mountChild(this.getChild(row * this.columns + column), childSpace, child -> {
                    int yC = this.inverted ? layoutYInv.intValue() + ((Insets)child.margins().get()).top() + this.verticalAlignment().align(child.fullSize().height(), rowSize) : layoutY.intValue() + ((Insets)child.margins().get()).bottom() + this.verticalAlignment().align(child.fullSize().height(), rowSize);
                    child.mount((ParentComponent)this, layoutX.intValue() + ((Insets)child.margins().get()).left() + this.horizontalAlignment().align(child.fullSize().width(), columnSize), yC);
                });
                layoutX.add(columnSizes[column]);
            }
            layoutY.add(rowSizes[row]);
        }
        this.contentSize = Size.of((int)(layoutX.intValue() - this.x), (int)(layoutY.intValue() - this.y));
    }

    public int rows() {
        return (int)Math.ceil((float)this.children.size() / (float)this.columns);
    }

    public void draw(OwoUIDrawContext context, int mouseX, int mouseY, float partialTicks, float delta) {
        super.draw(context, mouseX, mouseY, partialTicks, delta);
        this.drawChildren(context, mouseX, mouseY, partialTicks, delta, this.children);
    }

    protected void determineSizes(int[] sizes, boolean rows) {
        if (((Sizing)(rows ? this.verticalSizing : this.horizontalSizing).get()).method != Sizing.Method.CONTENT) {
            Arrays.fill(sizes, (rows ? this.height - ((Insets)this.padding().get()).vertical() : this.width - ((Insets)this.padding().get()).horizontal()) / (rows ? this.rows() : this.columns));
        } else {
            for (int row = 0; row < this.rows(); ++row) {
                for (int column = 0; column < this.columns; ++column) {
                    Component child;
                    int d = row * this.columns + column;
                    if (d >= this.children.size() || (child = this.children.get(d)) == null) continue;
                    if (rows) {
                        sizes[row] = Math.max(sizes[row], child.fullSize().height());
                        continue;
                    }
                    sizes[column] = Math.max(sizes[column], child.fullSize().width());
                }
            }
        }
    }

    public Component getChild(int index) {
        if (index < this.children.size()) {
            return this.children.get(index);
        }
        return null;
    }

    public FreeRowGridLayout child(Component child) {
        if (child != null) {
            this.children.add(child);
            this.updateLayout();
        }
        return this;
    }

    public FreeRowGridLayout setInverted(boolean inverted) {
        this.inverted = inverted;
        this.updateLayout();
        return this;
    }

    public FreeRowGridLayout removeChild(int index) {
        Component currentChild = this.children.get(index);
        if (currentChild != null) {
            currentChild.dismount(Component.DismountReason.REMOVED);
            this.children.remove(index);
            this.updateLayout();
        }
        return this;
    }

    public FreeRowGridLayout removeChild(Component child) {
        for (int i = 0; i < this.children.size(); ++i) {
            if (!Objects.equals(this.children.get(i), child)) continue;
            this.removeChild(i);
            break;
        }
        return this;
    }

    public FreeRowGridLayout clear() {
        for (Component child : this.children) {
            child.dismount(Component.DismountReason.REMOVED);
        }
        this.children.clear();
        this.updateLayout();
        return this;
    }

    public List<Component> children() {
        return this.children;
    }

    public void parseProperties(UIModel model, Element element, Map<String, Element> children) {
        super.parseProperties(model, element, children);
        List components = UIParsing.get(children, (String)"children", e -> UIParsing.allChildrenOfType((Element)e, (short)1)).orElse(Collections.emptyList());
        for (Element child : components) {
            this.child(model.parseComponent(Component.class, child));
        }
    }

    public static FreeRowGridLayout parse(Element element) {
        UIParsing.expectAttributes((Element)element, (String[])new String[]{"columns"});
        int columns = UIParsing.parseUnsignedInt((Node)element.getAttributeNode("columns"));
        return new FreeRowGridLayout(Sizing.content(), Sizing.content(), columns);
    }
}

