/*
 * Decompiled with CFR 0.152.
 */
package com.diamssword.greenresurgence.gui.faction;

import com.diamssword.characters.api.CharactersApi;
import com.diamssword.greenresurgence.GreenResurgence;
import com.diamssword.greenresurgence.gui.components.ClickableLayoutComponent;
import com.diamssword.greenresurgence.gui.faction.FactionFriendAddGui;
import com.diamssword.greenresurgence.network.Channels;
import com.diamssword.greenresurgence.network.GuildPackets;
import com.diamssword.greenresurgence.systems.faction.perimeter.components.FactionMember;
import io.wispforest.owo.ui.base.BaseUIModelScreen;
import io.wispforest.owo.ui.component.ButtonComponent;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.component.TextBoxComponent;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.container.ScrollContainer;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import io.wispforest.owo.ui.core.VerticalAlignment;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_2960;

@Environment(value=EnvType.CLIENT)
public class FactionFriendsGui
extends BaseUIModelScreen<FlowLayout> {
    private FlowLayout menu;
    private final UUID guild;
    private final Map<FactionMember, String> members;
    private final Map<String, Integer> roles;
    private final boolean canAdd;
    private final boolean canEdit;

    public FactionFriendsGui(UUID id, Map<FactionMember, String> members, Map<String, Integer> roles, boolean canAdd, boolean canEdit) {
        super(FlowLayout.class, BaseUIModelScreen.DataSource.asset((class_2960)GreenResurgence.asRessource("faction/friends")));
        this.roles = roles;
        this.members = members;
        this.guild = id;
        this.canAdd = canAdd;
        this.canEdit = canEdit;
    }

    public boolean method_25421() {
        return false;
    }

    protected void build(FlowLayout rootComponent) {
        TextBoxComponent search = (TextBoxComponent)rootComponent.childById(TextBoxComponent.class, "search");
        ((ButtonComponent)rootComponent.childById(ButtonComponent.class, "back")).onPress(v -> Channels.MAIN.clientHandle().send((Record)new GuildPackets.RequestGui("main", this.guild)));
        ButtonComponent addBt = (ButtonComponent)rootComponent.childById(ButtonComponent.class, "add");
        if (this.canAdd) {
            addBt.onPress(v -> Channels.MAIN.clientHandle().send((Record)new GuildPackets.RequestGui("addFriends", this.guild)));
        } else {
            addBt.remove();
        }
        this.menu = (FlowLayout)rootComponent.childById(FlowLayout.class, "menu");
        search.method_47404((class_2561)class_2561.method_43470((String)"Recherche"));
        FlowLayout c = (FlowLayout)rootComponent.childById(FlowLayout.class, "list");
        search.onChanged().subscribe(v -> {
            List<FactionMember> list = this.members.keySet().stream().toList();
            if (v.isBlank() || v.isEmpty()) {
                this.updateList(list, c);
            } else {
                list = v.startsWith("#") ? list.stream().filter(m -> m.isGuild() && m.getName().toLowerCase().contains(v.substring(1).toLowerCase())).toList() : list.stream().filter(m -> m.getName().toLowerCase().contains(v.toLowerCase())).toList();
                this.updateList(list, c);
            }
        });
        this.updateList(this.members.keySet().stream().toList(), c);
    }

    private void updateSelectedMenu(FactionMember member, class_2960 texture) {
        this.menu.clearChildren();
        this.menu.gap(4);
        this.menu.horizontalAlignment(HorizontalAlignment.CENTER);
        this.menu.child(Components.texture((class_2960)texture, (int)0, (int)0, (int)8, (int)8, (int)8, (int)8).sizing(Sizing.fixed((int)32)));
        LabelComponent t = Components.label((class_2561)class_2561.method_43470((String)member.getName()));
        if (member.getName().length() > 15) {
            t.horizontalSizing(Sizing.fill((int)100));
        }
        this.menu.child((Component)t);
        this.menu.allowOverflow(true);
        this.menu.child(FactionFriendsGui.cutLongText(this.members.get(member), 20, v -> this.roleMenu(this.menu, (ButtonComponent)v, member)).tooltip((class_2561)class_2561.method_43470((String)"Role")));
    }

    public void roleMenu(FlowLayout menu, ButtonComponent bt, FactionMember member) {
        FlowLayout flow = Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content());
        ScrollContainer scroll = Containers.verticalScroll((Sizing)Sizing.fill((int)100), (Sizing)Sizing.fill((int)50), (Component)flow);
        class_2561 txt = bt.method_25369();
        flow.surface(Surface.DARK_PANEL).padding(Insets.of((int)2));
        bt.method_25355((class_2561)class_2561.method_43470((String)"[Annuler]"));
        bt.onPress(b -> {
            scroll.remove();
            bt.method_25355(txt);
            bt.onPress(v -> this.roleMenu(menu, bt, member));
        });
        for (String d : this.roles.keySet()) {
            flow.child(FactionFriendsGui.cutLongText(d, 20, b -> {
                scroll.remove();
                bt.method_25355((class_2561)class_2561.method_43470((String)d));
                bt.onPress(v -> this.roleMenu(menu, bt, member));
                Channels.MAIN.clientHandle().send((Record)new GuildPackets.ChangeRole(member, d));
            }).horizontalSizing(Sizing.fill((int)100)));
        }
        menu.child((Component)scroll);
    }

    public static ButtonComponent cutLongText(String text, int max, Consumer<ButtonComponent> consumer) {
        ButtonComponent comp = Components.button((class_2561)class_2561.method_43470((String)text), consumer);
        if (text.length() > max) {
            String t1 = text.substring(0, max - 3) + "...";
            comp.method_25355((class_2561)class_2561.method_43470((String)t1));
            comp.tooltip((class_2561)class_2561.method_43470((String)text));
            return comp;
        }
        return comp;
    }

    private void updateList(List<FactionMember> names, FlowLayout parent) {
        parent.clearChildren();
        for (FactionMember n : names) {
            ClickableLayoutComponent l = new ClickableLayoutComponent(Sizing.fill((int)100), Sizing.fixed((int)24), FlowLayout.Algorithm.HORIZONTAL);
            AtomicReference<class_2960> texture = new AtomicReference<class_2960>(n.isGuild() ? FactionFriendAddGui.GUILD_HEAD : FactionFriendAddGui.MISSING_HEAD);
            Component icon = Components.texture((class_2960)texture.get(), (int)0, (int)0, (int)8, (int)8, (int)8, (int)8).sizing(Sizing.fixed((int)16));
            l.child(icon);
            l.gap(4).padding(Insets.horizontal((int)4));
            l.child(Components.label((class_2561)class_2561.method_43470((String)((n.isGuild() ? "#" : "") + n.getName()))).horizontalSizing(Sizing.fill((int)50)));
            l.surface(Surface.PANEL);
            l.surface2(Surface.DARK_PANEL);
            l.child(Components.label((class_2561)class_2561.method_43470((String)this.members.get(n))).horizontalTextAlignment(HorizontalAlignment.RIGHT).horizontalSizing(Sizing.fill((int)30)));
            l.alignment(HorizontalAlignment.LEFT, VerticalAlignment.CENTER);
            l.onPress(v -> this.updateSelectedMenu(n, (class_2960)texture.get()));
            if (n.isPlayer()) {
                CharactersApi.skin().getHeadTexture(n.getId(), v -> {
                    texture.set((class_2960)v);
                    l.removeChild(icon);
                    l.child(0, Components.texture((class_2960)((class_2960)texture.get()), (int)0, (int)0, (int)8, (int)8, (int)8, (int)8).sizing(Sizing.fixed((int)16)));
                });
            }
            parent.child((Component)l);
        }
    }
}

