/*
 * Decompiled with CFR 0.152.
 */
package com.diamssword.greenresurgence.mixin;

import com.diamssword.greenresurgence.network.Channels;
import com.diamssword.greenresurgence.network.PosesPackets;
import com.diamssword.greenresurgence.systems.Components;
import com.diamssword.greenresurgence.systems.attributs.Attributes;
import com.diamssword.greenresurgence.systems.character.HealthManager;
import com.diamssword.greenresurgence.systems.character.PlayerData;
import com.diamssword.greenresurgence.systems.character.customPoses.IPlayerCustomPose;
import com.mojang.authlib.GameProfile;
import java.util.Map;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1819;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3468;
import net.minecraft.class_3532;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5132;
import net.minecraft.class_5712;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1657.class})
public abstract class PlayerEntityMixin
extends class_1309 {
    @Shadow
    @Final
    private static Map<class_4050, class_4048> field_18134;

    protected PlayerEntityMixin(class_1299<? extends class_1309> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Shadow
    public abstract class_2561 method_5476();

    @Shadow
    public abstract void method_5783(class_3414 var1, float var2, float var3);

    @Inject(at={@At(value="TAIL")}, method={"<init>"})
    private void init(class_1937 world, class_2338 pos, float yaw, GameProfile gameProfile, CallbackInfo ci) {
    }

    @Inject(at={@At(value="TAIL")}, method={"canFoodHeal"}, cancellable=true)
    private void canFoodHeal(CallbackInfoReturnable<Boolean> cir) {
        cir.setReturnValue((Object)false);
    }

    @Inject(at={@At(value="HEAD")}, method={"updatePose"}, cancellable=true)
    protected void updatePose(CallbackInfo ci) {
        PlayerData comp = (PlayerData)Components.PLAYER_DATA.get((Object)this);
        if (comp.isForcedPose()) {
            this.method_18380(comp.getPose());
            ci.cancel();
        }
    }

    @Shadow
    public abstract void method_7339(class_2960 var1, int var2);

    @Inject(at={@At(value="HEAD")}, method={"dismountVehicle"})
    public void dismountVehicle(CallbackInfo ci) {
        if (this.method_5854() instanceof class_1657 && !this.method_5770().field_9236) {
            Channels.MAIN.serverHandle((class_1657)this.method_5854()).send((Record)new PosesPackets.DismountedPlayerNotify(this.method_5667()));
        }
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/entity/player/PlayerEntity;onAttacking(Lnet/minecraft/entity/Entity;)V")}, method={"attack"})
    public void attack(class_1297 target, CallbackInfo ci) {
        float g = (float)this.method_26825(Attributes.PLAYER_KNOCKBACK);
        if (g > 0.0f) {
            if (target instanceof class_1309) {
                ((class_1309)target).method_6005((double)g, (double)class_3532.method_15374((float)(this.method_36454() * ((float)Math.PI / 180))), (double)(-class_3532.method_15362((float)(this.method_36454() * ((float)Math.PI / 180)))));
            } else {
                target.method_5762((double)(-class_3532.method_15374((float)(this.method_36454() * ((float)Math.PI / 180))) * g), 0.1, (double)(class_3532.method_15362((float)(this.method_36454() * ((float)Math.PI / 180))) * g));
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"applyDamage"}, cancellable=true)
    protected void applyDamage(class_1282 source, float amount, CallbackInfo ci) {
        if (!this.method_5679(source)) {
            HealthManager man = ((PlayerData)this.getComponent(Components.PLAYER_DATA)).healthManager;
            if (!HealthManager.damageByPassShield(source) && man.getShieldAmount() > 0.0) {
                amount = this.method_6132(source, amount);
                amount = this.method_6036(source, amount);
                float var7 = Math.max(amount - this.method_6067(), 0.0f);
                this.method_6073(this.method_6067() - (amount - var7));
                float g = amount - var7;
                if (g > 0.0f && g < 3.4028235E37f) {
                    this.method_7339(class_3468.field_15365, Math.round(g * 10.0f));
                }
                if (var7 != 0.0f) {
                    this.method_6066().method_5547(source, var7);
                    double r = man.attackShield(var7, (class_1657)this);
                    if (var7 < 3.4028235E37f) {
                        this.method_7339(class_3468.field_15388, Math.round(var7 * 10.0f));
                    }
                    this.method_32876(class_5712.field_28736);
                    if (r < 0.0) {
                        this.method_6033((float)((double)this.method_6032() + r));
                    }
                }
                ci.cancel();
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"damageShield"}, cancellable=true)
    protected void damageShield(float amount, CallbackInfo ci) {
        class_1657 pl = (class_1657)this;
        if (pl.method_6030().method_7909() instanceof class_1819) {
            if (!this.method_37908().field_9236) {
                pl.method_7259(class_3468.field_15372.method_14956((Object)pl.method_6030().method_7909()));
            }
            if (amount >= 3.0f) {
                int i = 1 + class_3532.method_15375((float)amount);
                class_1268 hand = pl.method_6058();
                pl.method_6030().method_7956(i, (class_1309)pl, player -> player.method_20236(hand));
                if (pl.method_6030().method_7960()) {
                    if (hand == class_1268.field_5808) {
                        this.method_5673(class_1304.field_6173, class_1799.field_8037);
                    } else {
                        this.method_5673(class_1304.field_6171, class_1799.field_8037);
                    }
                    pl.method_6021();
                    this.method_5783(class_3417.field_15239, 0.8f, 0.8f + this.method_37908().field_9229.method_43057() * 0.4f);
                }
            }
            ci.cancel();
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"disableShield"})
    public void disableShield(boolean sprinting, CallbackInfo ci) {
        class_1657 pl = (class_1657)this;
        float f = 0.25f + (float)class_1890.method_8234((class_1309)pl) * 0.05f;
        if (sprinting) {
            f += 0.75f;
        }
        if (this.field_5974.method_43057() < f) {
            pl.method_7357().method_7906(pl.method_6030().method_7909(), 100);
            pl.method_6021();
            this.method_37908().method_8421((class_1297)this, (byte)30);
        }
        ci.cancel();
    }

    @Inject(at={@At(value="HEAD")}, method={"getDimensions"}, cancellable=true)
    public void getDimensions(class_4050 pose, CallbackInfoReturnable<class_4048> cir) {
        class_4048 p;
        class_4048 p1;
        PlayerData comp = (PlayerData)this.getComponent(Components.PLAYER_DATA);
        IPlayerCustomPose custpo = comp.getCustomPose();
        if (custpo != null && (p1 = custpo.changeHitBox(comp.player, p = field_18134.get(pose))) != p) {
            cir.setReturnValue((Object)p1);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"getActiveEyeHeight"}, cancellable=true)
    public void getActiveEyeHeight(class_4050 pose, class_4048 dimensions, CallbackInfoReturnable<Float> cir) {
        if (pose == class_4050.field_18076) {
            cir.setReturnValue((Object)Float.valueOf(dimensions.field_18068 * 0.9f));
        } else if (pose == class_4050.field_18081) {
            cir.setReturnValue((Object)Float.valueOf(dimensions.field_18068 * 0.85f));
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"createPlayerAttributes"})
    private static void createLivingAttributes(CallbackInfoReturnable<class_5132.class_5133> cir) {
        Attributes.plAttributes.values().forEach(v -> ((class_5132.class_5133)cir.getReturnValue()).method_26868(v, v.method_6169()));
    }
}

