/*
 * Decompiled with CFR 0.152.
 */
package com.diamssword.greenresurgence.structure;

import com.diamssword.greenresurgence.GreenResurgence;
import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_247;
import net.minecraft.class_2470;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2794;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3341;
import net.minecraft.class_3485;
import net.minecraft.class_3499;
import net.minecraft.class_3748;
import net.minecraft.class_3777;
import net.minecraft.class_3780;
import net.minecraft.class_3784;
import net.minecraft.class_3785;
import net.minecraft.class_3790;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_5468;
import net.minecraft.class_5539;
import net.minecraft.class_5819;
import net.minecraft.class_6626;
import net.minecraft.class_6880;
import net.minecraft.class_7138;
import net.minecraft.class_7924;
import org.apache.commons.lang3.mutable.MutableObject;

public class JigsawHelper {
    public static Optional<class_3195.class_7150> generate(class_3195.class_7149 context, class_6880<class_3785> structurePool, Optional<class_2960> id, int size, class_2338 pos, boolean useExpansionHack, Optional<class_2902.class_2903> projectStartToHeightmap, int maxDistanceFromCenter, class_2470 rotation) {
        class_2338 blockPos;
        class_5455 dynamicRegistryManager = context.comp_561();
        class_2794 chunkGenerator = context.comp_562();
        class_3485 structureTemplateManager = context.comp_565();
        class_5539 heightLimitView = context.comp_569();
        class_5819 chunkRandom = class_5819.method_43047();
        class_2378 registry = dynamicRegistryManager.method_30530(class_7924.field_41249);
        class_3785 structurePool2 = (class_3785)structurePool.comp_349();
        class_3784 structurePoolElement = structurePool2.method_16631(chunkRandom);
        if (structurePoolElement == class_3777.field_16663) {
            return Optional.empty();
        }
        if (id.isPresent()) {
            class_2960 identifier = id.get();
            Optional<class_2338> optional = JigsawHelper.findStartingJigsawPos(structurePoolElement, identifier, pos, rotation, structureTemplateManager, chunkRandom);
            if (optional.isEmpty()) {
                GreenResurgence.LOGGER.error("No starting jigsaw {} found in start pool {}", (Object)identifier, (Object)structurePool.method_40230().map(key -> key.method_29177().toString()).orElse("<unregistered>"));
                return Optional.empty();
            }
            blockPos = optional.get();
        } else {
            blockPos = pos;
        }
        class_2338 vec3i = blockPos.method_10059((class_2382)pos);
        class_2338 blockPos2 = pos.method_10059((class_2382)vec3i);
        class_3790 poolStructurePiece = new class_3790(structureTemplateManager, structurePoolElement, blockPos2, structurePoolElement.method_19308(), rotation, structurePoolElement.method_16628(structureTemplateManager, blockPos2, rotation));
        class_3341 blockBox = poolStructurePiece.method_14935();
        int i = (blockBox.method_35418() + blockBox.method_35415()) / 2;
        int j = (blockBox.method_35420() + blockBox.method_35417()) / 2;
        int k = projectStartToHeightmap.isPresent() ? pos.method_10264() + chunkGenerator.method_20402(i, j, projectStartToHeightmap.get(), heightLimitView, context.comp_564()) : blockPos2.method_10264();
        int l = blockBox.method_35416() + poolStructurePiece.method_16646();
        poolStructurePiece.method_14922(0, k - l, 0);
        int m = k + vec3i.method_10264();
        return Optional.of(new class_3195.class_7150(new class_2338(i, m, j), collector -> {
            ArrayList list = Lists.newArrayList();
            list.add(poolStructurePiece);
            if (size <= 0) {
                return;
            }
            class_238 box = new class_238((double)(i - maxDistanceFromCenter), (double)(m - maxDistanceFromCenter), (double)(j - maxDistanceFromCenter), (double)(i + maxDistanceFromCenter + 1), (double)(m + maxDistanceFromCenter + 1), (double)(j + maxDistanceFromCenter + 1));
            class_265 voxelShape = class_259.method_1072((class_265)class_259.method_1078((class_238)box), (class_265)class_259.method_1078((class_238)class_238.method_19316((class_3341)blockBox)), (class_247)class_247.field_16886);
            JigsawHelper.generate(context.comp_564(), size, useExpansionHack, chunkGenerator, structureTemplateManager, heightLimitView, chunkRandom, (class_2378<class_3785>)registry, poolStructurePiece, list, voxelShape);
            list.forEach(arg_0 -> ((class_6626)collector).method_35462(arg_0));
        }));
    }

    private static Optional<class_2338> findStartingJigsawPos(class_3784 pool, class_2960 id, class_2338 pos, class_2470 rotation, class_3485 structureManager, class_5819 random) {
        List list = pool.method_16627(structureManager, pos, rotation, random);
        Optional<class_2338> optional = Optional.empty();
        for (class_3499.class_3501 structureBlockInfo : list) {
            class_2960 identifier = class_2960.method_12829((String)structureBlockInfo.comp_1343().method_10558("name"));
            if (!id.equals((Object)identifier)) continue;
            optional = Optional.of(structureBlockInfo.comp_1341());
            break;
        }
        return optional;
    }

    private static void generate(class_7138 noiseConfig, int maxSize, boolean modifyBoundingBox, class_2794 chunkGenerator, class_3485 structureTemplateManager, class_5539 heightLimitView, class_5819 random, class_2378<class_3785> structurePoolRegistry, class_3790 firstPiece, List<class_3790> pieces, class_265 pieceShape) {
        StructurePoolGenerator structurePoolGenerator = new StructurePoolGenerator(structurePoolRegistry, maxSize, chunkGenerator, structureTemplateManager, pieces, random);
        structurePoolGenerator.structurePieces.addLast(new ShapedPoolStructurePiece(firstPiece, (MutableObject<class_265>)new MutableObject((Object)pieceShape), 0));
        while (!structurePoolGenerator.structurePieces.isEmpty()) {
            ShapedPoolStructurePiece shapedPoolStructurePiece = structurePoolGenerator.structurePieces.removeFirst();
            structurePoolGenerator.generatePiece(shapedPoolStructurePiece.piece, shapedPoolStructurePiece.pieceShape, shapedPoolStructurePiece.currentSize, modifyBoundingBox, heightLimitView, noiseConfig);
        }
    }

    static final class StructurePoolGenerator {
        private final class_2378<class_3785> registry;
        private final int maxSize;
        private final class_2794 chunkGenerator;
        private final class_3485 structureTemplateManager;
        private final List<? super class_3790> children;
        private final class_5819 random;
        final Deque<ShapedPoolStructurePiece> structurePieces = Queues.newArrayDeque();

        StructurePoolGenerator(class_2378<class_3785> registry, int maxSize, class_2794 chunkGenerator, class_3485 structureTemplateManager, List<? super class_3790> children, class_5819 random) {
            this.registry = registry;
            this.maxSize = maxSize;
            this.chunkGenerator = chunkGenerator;
            this.structureTemplateManager = structureTemplateManager;
            this.children = children;
            this.random = random;
        }

        void generatePiece(class_3790 piece, MutableObject<class_265> pieceShape, int minY, boolean modifyBoundingBox, class_5539 world, class_7138 noiseConfig) {
            class_3784 structurePoolElement = piece.method_16644();
            class_2338 blockPos = piece.method_16648();
            class_2470 blockRotation = piece.method_16888();
            class_3785.class_3786 projection = structurePoolElement.method_16624();
            boolean bl = projection == class_3785.class_3786.field_16687;
            MutableObject<class_265> mutableObject = new MutableObject<class_265>();
            class_3341 blockBox = piece.method_14935();
            int i = blockBox.method_35416();
            block0: for (class_3499.class_3501 structureBlockInfo : structurePoolElement.method_16627(this.structureTemplateManager, blockPos, blockRotation, this.random)) {
                class_3784 structurePoolElement2;
                MutableObject<class_265> mutableObject2;
                class_2350 direction = class_3748.method_26378((class_2680)structureBlockInfo.comp_1342());
                class_2338 blockPos2 = structureBlockInfo.comp_1341();
                class_2338 blockPos3 = blockPos2.method_10093(direction);
                int j = blockPos2.method_10264() - i;
                int k = -1;
                class_5321<class_3785> registryKey = StructurePoolGenerator.getPoolKey(structureBlockInfo);
                Optional optional = this.registry.method_40264(registryKey);
                if (optional.isEmpty()) {
                    GreenResurgence.LOGGER.warn("Empty or non-existent pool: {}", (Object)registryKey.method_29177());
                    continue;
                }
                class_6880 registryEntry = (class_6880)optional.get();
                if (((class_3785)registryEntry.comp_349()).method_16632() == 0 && !registryEntry.method_40225(class_5468.field_26254)) {
                    GreenResurgence.LOGGER.warn("Empty or non-existent pool: {}", (Object)registryKey.method_29177());
                    continue;
                }
                class_6880 registryEntry2 = ((class_3785)registryEntry.comp_349()).method_46736();
                if (((class_3785)registryEntry2.comp_349()).method_16632() == 0 && !registryEntry2.method_40225(class_5468.field_26254)) {
                    GreenResurgence.LOGGER.warn("Empty or non-existent fallback pool: {}", (Object)registryEntry2.method_40230().map(key -> key.method_29177().toString()).orElse("<unregistered>"));
                    continue;
                }
                boolean bl2 = blockBox.method_14662((class_2382)blockPos3);
                if (bl2) {
                    mutableObject2 = mutableObject;
                    if (mutableObject.getValue() == null) {
                        mutableObject.setValue((Object)class_259.method_1078((class_238)class_238.method_19316((class_3341)blockBox)));
                    }
                } else {
                    mutableObject2 = pieceShape;
                }
                ArrayList list = Lists.newArrayList();
                if (minY != this.maxSize) {
                    list.addAll(((class_3785)registryEntry.comp_349()).method_16633(this.random));
                }
                list.addAll(((class_3785)registryEntry2.comp_349()).method_16633(this.random));
                Iterator iterator = list.iterator();
                while (iterator.hasNext() && (structurePoolElement2 = (class_3784)iterator.next()) != class_3777.field_16663) {
                    for (class_2470 blockRotation2 : class_2470.method_16547((class_5819)this.random)) {
                        List list2 = structurePoolElement2.method_16627(this.structureTemplateManager, class_2338.field_10980, blockRotation2, this.random);
                        class_3341 blockBox2 = structurePoolElement2.method_16628(this.structureTemplateManager, class_2338.field_10980, blockRotation2);
                        int l = !modifyBoundingBox || blockBox2.method_14660() > 16 ? 0 : list2.stream().mapToInt(blockInfo -> {
                            if (!blockBox2.method_14662((class_2382)blockInfo.comp_1341().method_10093(class_3748.method_26378((class_2680)blockInfo.comp_1342())))) {
                                return 0;
                            }
                            class_5321<class_3785> registryKey1 = StructurePoolGenerator.getPoolKey(blockInfo);
                            Optional optional1 = this.registry.method_40264(registryKey1);
                            Optional<class_6880> optional2 = optional1.map(entry -> ((class_3785)entry.comp_349()).method_46736());
                            int i1 = optional1.map(entry -> ((class_3785)entry.comp_349()).method_19309(this.structureTemplateManager)).orElse(0);
                            int j1 = optional2.map(entry -> ((class_3785)entry.comp_349()).method_19309(this.structureTemplateManager)).orElse(0);
                            return Math.max(i1, j1);
                        }).max().orElse(0);
                        for (class_3499.class_3501 structureBlockInfo2 : list2) {
                            int t;
                            int r;
                            int p;
                            if (!class_3748.method_16546((class_3499.class_3501)structureBlockInfo, (class_3499.class_3501)structureBlockInfo2)) continue;
                            class_2338 blockPos4 = structureBlockInfo2.comp_1341();
                            class_2338 blockPos5 = blockPos3.method_10059((class_2382)blockPos4);
                            class_3341 blockBox3 = structurePoolElement2.method_16628(this.structureTemplateManager, blockPos5, blockRotation2);
                            int m = blockBox3.method_35416();
                            class_3785.class_3786 projection2 = structurePoolElement2.method_16624();
                            boolean bl3 = projection2 == class_3785.class_3786.field_16687;
                            int n = blockPos4.method_10264();
                            int o = j - n + class_3748.method_26378((class_2680)structureBlockInfo.comp_1342()).method_10164();
                            if (bl && bl3) {
                                p = i + o;
                            } else {
                                if (k == -1) {
                                    k = this.chunkGenerator.method_20402(blockPos2.method_10263(), blockPos2.method_10260(), class_2902.class_2903.field_13194, world, noiseConfig);
                                }
                                p = k - n;
                            }
                            int q = p - m;
                            class_3341 blockBox4 = blockBox3.method_19311(0, q, 0);
                            class_2338 blockPos6 = blockPos5.method_10069(0, q, 0);
                            if (l > 0) {
                                r = Math.max(l + 1, blockBox4.method_35419() - blockBox4.method_35416());
                                blockBox4.method_34389(new class_2338(blockBox4.method_35415(), blockBox4.method_35416() + r, blockBox4.method_35417()));
                            }
                            mutableObject2.setValue((Object)class_259.method_1082((class_265)((class_265)mutableObject2.getValue()), (class_265)class_259.method_1078((class_238)class_238.method_19316((class_3341)blockBox4)), (class_247)class_247.field_16886));
                            r = piece.method_16646();
                            int s = bl3 ? r - o : structurePoolElement2.method_19308();
                            class_3790 poolStructurePiece = new class_3790(this.structureTemplateManager, structurePoolElement2, blockPos6, s, blockRotation2, blockBox4);
                            if (bl) {
                                t = i + j;
                            } else if (bl3) {
                                t = p + n;
                            } else {
                                if (k == -1) {
                                    k = this.chunkGenerator.method_20402(blockPos2.method_10263(), blockPos2.method_10260(), class_2902.class_2903.field_13194, world, noiseConfig);
                                }
                                t = k + o / 2;
                            }
                            piece.method_16647(new class_3780(blockPos3.method_10263(), t - j + r, blockPos3.method_10260(), o, projection2));
                            poolStructurePiece.method_16647(new class_3780(blockPos2.method_10263(), t - n + s, blockPos2.method_10260(), -o, projection));
                            this.children.add((class_3790)poolStructurePiece);
                            if (minY + 1 > this.maxSize) continue block0;
                            this.structurePieces.addLast(new ShapedPoolStructurePiece(poolStructurePiece, mutableObject2, minY + 1));
                            continue block0;
                        }
                    }
                }
            }
        }

        private static class_5321<class_3785> getPoolKey(class_3499.class_3501 blockInfo) {
            return class_5321.method_29179((class_5321)class_7924.field_41249, (class_2960)new class_2960(blockInfo.comp_1343().method_10558("pool")));
        }
    }

    static final class ShapedPoolStructurePiece {
        final class_3790 piece;
        final MutableObject<class_265> pieceShape;
        final int currentSize;

        ShapedPoolStructurePiece(class_3790 piece, MutableObject<class_265> pieceShape, int currentSize) {
            this.piece = piece;
            this.pieceShape = pieceShape;
            this.currentSize = currentSize;
        }
    }
}

