/*
 * Decompiled with CFR 0.152.
 */
package com.diamssword.greenresurgence.systems.character;

import com.diamssword.greenresurgence.systems.attributs.Attributes;
import com.diamssword.greenresurgence.systems.character.PlayerData;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1657;
import net.minecraft.class_1928;
import net.minecraft.class_2487;
import net.minecraft.class_8111;

public class HealthManager {
    private final float shieldHealAmount = 1.0f;
    private final float energyHealAmount = 0.5f;
    private int shieldTickTimer;
    private int energyTickTimer;
    private double shieldAmount = 20.0;
    private double energyAmount = 100.0;
    public final class_1657 player;

    public HealthManager(class_1657 pl) {
        this.player = pl;
    }

    public void update() {
        double old;
        float f;
        boolean needRefresh = false;
        boolean bl = this.player.method_37908().method_8450().method_8355(class_1928.field_19395);
        if (bl) {
            ++this.shieldTickTimer;
            if (this.shieldTickTimer >= 10) {
                f = Math.min(this.shieldHealAmount, 6.0f);
                old = this.shieldAmount;
                this.healShield(f / 6.0f);
                needRefresh = old != this.shieldAmount;
                this.shieldTickTimer = 0;
            }
        } else {
            this.shieldTickTimer = 0;
        }
        if (this.player.method_5624()) {
            this.energyTickTimer = 0;
            if (this.energyAmount > 0.0) {
                this.energyAmount -= 0.5;
                needRefresh = true;
                this.player.method_6092(new class_1293(class_1294.field_5904, 20, 1));
            }
        } else {
            ++this.energyTickTimer;
            if (this.energyTickTimer >= 5) {
                f = Math.min(this.energyHealAmount, 6.0f);
                old = this.energyAmount;
                this.energyAmount = Math.min(this.energyAmount + (double)f, this.getMaxEnergyAmount());
                if (!needRefresh) {
                    needRefresh = old != this.energyAmount;
                }
                this.energyTickTimer = 0;
            }
        }
        if (needRefresh) {
            PlayerData.syncHUD(this.player);
        }
    }

    public double attackShield(double amount, class_1657 owner) {
        if (owner.method_37908().field_9236) {
            return 0.0;
        }
        double m = this.shieldAmount - amount;
        this.shieldAmount = Math.max(m, 0.0);
        this.shieldTickTimer = 0;
        PlayerData.syncHUD(owner);
        if (m < 0.0) {
            return m;
        }
        return 0.0;
    }

    public void readNbt(class_2487 nbt) {
        this.shieldTickTimer = nbt.method_10550("shieldTickTimer");
        this.shieldAmount = nbt.method_10574("shieldAmount");
        this.energyTickTimer = nbt.method_10550("energyTickTimer");
        this.energyAmount = nbt.method_10574("energyAmount");
    }

    public double getShieldAmount() {
        return this.shieldAmount;
    }

    public double getHealthAmount() {
        return this.player.method_6032();
    }

    public double getMaxHealthAmount() {
        return this.player.method_6063();
    }

    public double getEnergyAmount() {
        return this.energyAmount;
    }

    public double getMaxShieldAmount() {
        return this.player.method_26825(Attributes.MAX_SHIELD);
    }

    public double getMaxEnergyAmount() {
        return this.player.method_26825(Attributes.MAX_ENERGY);
    }

    public void setShieldAmount(double shieldAmount) {
        this.shieldAmount = shieldAmount;
    }

    public void setEnergyAmount(double energyAmount) {
        this.energyAmount = energyAmount;
    }

    public void healShield(double amount) {
        this.shieldAmount = Math.min(this.shieldAmount + amount, this.getMaxShieldAmount());
    }

    public void writeNbt(class_2487 nbt) {
        nbt.method_10569("shieldTickTimer", this.shieldTickTimer);
        nbt.method_10549("shieldAmount", this.shieldAmount);
        nbt.method_10549("energyAmount", this.energyAmount);
        nbt.method_10549("energyTickTimer", (double)this.energyTickTimer);
    }

    public static boolean damageByPassShield(class_1282 source) {
        return source.method_49708(class_8111.field_42344) || source.method_49708(class_8111.field_42354) || source.method_49708(class_8111.field_42334) || source.method_49708(class_8111.field_42342) || source.method_49708(class_8111.field_42341) || source.method_49708(class_8111.field_42351) || source.method_49708(class_8111.field_42345) || source.method_49708(class_8111.field_42346) || source.method_49708(class_8111.field_42335) || source.method_49708(class_8111.field_42337) || source.method_49708(class_8111.field_42338) || source.method_49708(class_8111.field_42350) || source.method_49708(class_8111.field_42327);
    }
}

