/*
 * Decompiled with CFR 0.152.
 */
package com.diamssword.greenresurgence.systems.lootables;

import com.diamssword.greenresurgence.GreenResurgence;
import com.diamssword.greenresurgence.network.Channels;
import com.diamssword.greenresurgence.network.DictionaryPackets;
import com.diamssword.greenresurgence.systems.lootables.Lootable;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_2248;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;

public class LootablesReloader
implements SimpleSynchronousResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final Logger LOGGER = LogUtils.getLogger();
    private Map<class_2248, Lootable> lootables = new HashMap<class_2248, Lootable>();
    private boolean shouldSync = false;

    public Optional<Lootable> getTable(class_2248 g) {
        return Optional.ofNullable(this.lootables.get(g));
    }

    public class_2960 getFabricId() {
        return GreenResurgence.asRessource("lootables");
    }

    public void method_14491(class_3300 manager) {
        this.lootables = new HashMap<class_2248, Lootable>();
        class_2960 id = GreenResurgence.asRessource("lootables.json");
        List files = manager.method_14489(id);
        files.forEach(file -> {
            try {
                BufferedReader reader = file.method_43039();
                try {
                    JsonArray jsonElement = (JsonArray)class_3518.method_15276((Gson)GSON, (Reader)reader, JsonArray.class);
                    jsonElement.forEach(v -> {
                        JsonObject ob = v.getAsJsonObject();
                        if (ob.has("block")) {
                            try {
                                JsonObject tables;
                                Lootable table = new Lootable(new class_2960(ob.get("block").getAsString()), new class_2960(ob.get("empty").getAsString()));
                                if (ob.has("tables")) {
                                    tables = ob.get("tables").getAsJsonObject();
                                    tables.keySet().forEach(k -> table.addTool(GreenResurgence.asRessource("lootable/tools/" + k), new class_2960(tables.get(k).getAsString())));
                                }
                                if (ob.has("requirements")) {
                                    tables = ob.get("requirements").getAsJsonObject();
                                    tables.keySet().forEach(k -> {
                                        String[] st1;
                                        for (String d : st1 = tables.get(k).getAsString().split(",")) {
                                            String[] st = d.split(":");
                                            if (st.length <= 1) continue;
                                            table.addRequirement(GreenResurgence.asRessource("lootable/tools/" + k), st[0], Integer.parseInt(st[1]));
                                        }
                                    });
                                }
                                if (ob.has("connected")) {
                                    table.setConnected(new class_2960(ob.get("connected").getAsString()));
                                }
                                this.lootables.put(table.getBlock(), table);
                            }
                            catch (Exception e) {
                                LOGGER.error("Couldn't parse block from file {} for {}", (Object)id, (Object)ob.get("block").getAsString());
                            }
                        } else {
                            LOGGER.error("Empty declaration in file {}", (Object)id);
                        }
                    });
                }
                finally {
                    ((Reader)reader).close();
                    this.shouldSync = true;
                }
            }
            catch (JsonParseException | IOException | IllegalArgumentException exception) {
                LOGGER.error("Couldn't parse data file {} from {}", new Object[]{id, this.getFabricId(), exception});
            }
        });
    }

    public void worldTick(MinecraftServer server) {
        if (this.shouldSync) {
            this.shouldSync = false;
            Channels.serverHandle(server).send((Record)new DictionaryPackets.LootableList(this));
        }
    }

    public static void serializer(class_2540 write, LootablesReloader val) {
        class_2499 list = new class_2499();
        val.lootables.forEach((u, v) -> list.add((Object)v.toNBT()));
        class_2487 comp = new class_2487();
        comp.method_10566("list", (class_2520)list);
        write.method_10794(comp);
    }

    public static LootablesReloader unserializer(class_2540 read) {
        LootablesReloader loader = new LootablesReloader();
        class_2487 comp = read.method_10798();
        class_2499 list = comp.method_10554("list", 10);
        list.forEach(el -> {
            try {
                Lootable t = Lootable.fromNBT((class_2487)el);
                loader.lootables.put(t.getBlock(), t);
            }
            catch (Exception e) {
                LOGGER.error("Couldn't parse packet data for lootable: {}", el, (Object)e);
            }
        });
        return loader;
    }
}

