/*
 * Decompiled with CFR 0.152.
 */
package com.diamssword.greenresurgence.containers.player;

import com.diamssword.characters.api.ICharacterStored;
import com.diamssword.characters.api.http.ApiCharacterValues;
import com.diamssword.greenresurgence.containers.IGridContainer;
import com.diamssword.greenresurgence.containers.SlotedSimpleInventory;
import com.diamssword.greenresurgence.containers.player.VanillaPlayerInvMokup;
import com.diamssword.greenresurgence.containers.player.grids.ArmorGrid;
import com.diamssword.greenresurgence.containers.player.grids.BagsGrid;
import com.diamssword.greenresurgence.containers.player.grids.OffHandGrid;
import com.diamssword.greenresurgence.containers.player.grids.PlayerGrid;
import com.diamssword.greenresurgence.items.AbstractBackpackItem;
import com.diamssword.greenresurgence.network.Channels;
import com.diamssword.greenresurgence.network.InventoryPackets;
import com.diamssword.greenresurgence.systems.Components;
import com.diamssword.greenresurgence.systems.character.PlayerInventoryData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3545;
import net.minecraft.class_3908;
import org.jetbrains.annotations.Nullable;

public class CustomPlayerInventory
implements ICharacterStored {
    private class_1657 parent;
    private SlotedSimpleInventory bags;
    private class_1799 cursorStack = class_1799.field_8037;
    private final Map<String, class_1263> cachedInventories = new HashMap<String, class_1263>();
    private int lastHotbarSize = 0;
    public boolean InventoryScreenNeedRefresh = false;

    public class_1657 getPlayer() {
        return this.parent;
    }

    public List<IGridContainer> getAsContainers() {
        class_3545<Integer, Integer> dim;
        ArrayList<IGridContainer> res = new ArrayList<IGridContainer>();
        OffsetInventory hot = this.getHotBar();
        res.add(new PlayerGrid("hotbar", hot, hot.method_5439(), 1));
        res.add(new OffHandGrid("offhand", this.getOffhand(), 1, 1));
        res.add(new PlayerGrid("player", this.getMain(), 3, 3));
        class_1263 b = this.getBackPack();
        if (b != null) {
            dim = this.invDimsFor(0);
            res.add(new PlayerGrid("backpack", b, (Integer)dim.method_15442(), (Integer)dim.method_15441()));
        }
        if ((b = this.getSatchelLeft()) != null) {
            dim = this.invDimsFor(1);
            res.add(new PlayerGrid("satchelLeft", b, (Integer)dim.method_15442(), (Integer)dim.method_15441()));
        }
        if ((b = this.getSatchelRight()) != null) {
            dim = this.invDimsFor(2);
            res.add(new PlayerGrid("satchelRight", b, (Integer)dim.method_15442(), (Integer)dim.method_15441()));
        }
        res.add(new ArmorGrid("armor", this.getArmor(), 1, 4));
        return res;
    }

    private class_3545<Integer, Integer> invDimsFor(int bagslotid) {
        class_1792 class_17922 = this.getBags().method_5438(bagslotid).method_7909();
        if (class_17922 instanceof AbstractBackpackItem) {
            AbstractBackpackItem be = (AbstractBackpackItem)class_17922;
            return new class_3545((Object)be.inventoryWidth(this.getBags().method_5438(bagslotid)), (Object)be.inventoryHeight(this.getBags().method_5438(bagslotid)));
        }
        return new class_3545((Object)0, (Object)0);
    }

    public void updateItems() {
        this.getAsContainers().forEach(c -> {
            boolean iHotbar = c.getName().equals("hotbar");
            for (int j = 0; j < c.getInventory().method_5439(); ++j) {
                class_1799 s = c.getInventory().method_5438(j);
                if (s == null || s.method_7960()) continue;
                class_1792 patt3311$temp = s.method_7909();
                if (patt3311$temp instanceof AbstractBackpackItem) {
                    AbstractBackpackItem bi = (AbstractBackpackItem)patt3311$temp;
                    if (bi.bagInventoryTick(s, this.parent, j)) continue;
                    c.getInventory().method_5447(j, class_1799.field_8037);
                    continue;
                }
                s.method_7917(this.parent.method_37908(), (class_1297)this.parent, j, iHotbar && this.parent.method_31548().field_7545 == j);
            }
        });
        for (int j = 0; j < this.bags.method_5439(); ++j) {
            class_1792 class_17922;
            class_1799 s = this.bags.method_5438(j);
            if (s == null || s.method_7960() || !((class_17922 = s.method_7909()) instanceof AbstractBackpackItem)) continue;
            AbstractBackpackItem bi = (AbstractBackpackItem)class_17922;
            bi.bagSlotTick(s, this.parent, j);
        }
    }

    public void fromNBT(class_2487 tag, class_1657 player) {
        this.parent = player;
        this.bags = new PlayerLinkedInventory(this.parent, 3);
        if (tag.method_10545("accessories")) {
            this.bags.method_7659(tag.method_10554("accessories", 10));
        }
        if (tag.method_10545("cursorStack")) {
            this.cursorStack = class_1799.method_7915((class_2487)tag.method_10562("cursorStack"));
        }
    }

    public class_2487 toNBT(class_2487 tag) {
        tag.method_10566("accessories", (class_2520)this.bags.method_7660());
        tag.method_10566("cursorStack", (class_2520)this.cursorStack.method_7953(new class_2487()));
        return tag;
    }

    public class_2487 toNBTComplete() {
        class_2487 tag = new class_2487();
        this.toNBT(tag);
        tag.method_10566("main", (class_2520)this.getPlayer().method_31548().method_7384(new class_2499()));
        return tag;
    }

    public void fromNBTComplete(class_2487 tag, class_1657 player) {
        this.fromNBT(tag, player);
        if (tag.method_10545("main")) {
            player.method_31548().method_7397(tag.method_10554("main", 10));
        }
    }

    private <T extends class_1263> T cachedInventory(String name, Supplier<T> builder) {
        if (!this.cachedInventories.containsKey(name)) {
            this.cachedInventories.put(name, (class_1263)builder.get());
        }
        return (T)this.cachedInventories.get(name);
    }

    public void clearCache() {
        this.cachedInventories.clear();
    }

    public class_1263 getBackPack() {
        return this.cachedInventory("backpack", () -> {
            class_1792 patt5187$temp = this.getBags().method_5438(0).method_7909();
            if (patt5187$temp instanceof AbstractBackpackItem) {
                AbstractBackpackItem ba = (AbstractBackpackItem)patt5187$temp;
                return ba.getInventory(this.getBags().method_5438(0));
            }
            return null;
        });
    }

    public class_1263 getSatchelLeft() {
        return this.cachedInventory("satchelLeft", () -> {
            class_1792 patt5440$temp = this.getBags().method_5438(1).method_7909();
            if (patt5440$temp instanceof AbstractBackpackItem) {
                AbstractBackpackItem ba = (AbstractBackpackItem)patt5440$temp;
                return ba.getInventory(this.getBags().method_5438(1));
            }
            return null;
        });
    }

    public class_1277 getBags() {
        return this.cachedInventory("bags", () -> this.bags);
    }

    public class_1263 getSatchelRight() {
        return this.cachedInventory("satchelRight", () -> {
            class_1792 patt5803$temp = this.getBags().method_5438(2).method_7909();
            if (patt5803$temp instanceof AbstractBackpackItem) {
                AbstractBackpackItem ba = (AbstractBackpackItem)patt5803$temp;
                return ba.getInventory(this.getBags().method_5438(2));
            }
            return null;
        });
    }

    public OffsetInventory getHotBar() {
        int c = CustomPlayerInventory.getHotbarSlotCount(this.parent);
        if (this.lastHotbarSize != c) {
            this.clearCache();
            this.lastHotbarSize = c;
        }
        return this.cachedInventory("hotbar", () -> new OffsetInventory((class_1263)this.parent.method_31548(), 0, c));
    }

    public OffsetInventory getArmor() {
        return this.cachedInventory("armor", () -> new OffsetInventory((class_1263)this.parent.method_31548(), 36, 4));
    }

    public OffsetInventory getMain() {
        return this.cachedInventory("main", () -> new OffsetInventory((class_1263)this.parent.method_31548(), 9, 9));
    }

    public OffsetInventory getOffhand() {
        return this.cachedInventory("offhand", () -> new OffsetInventory((class_1263)this.parent.method_31548(), 40, 1));
    }

    public List<class_1263> getAllInventories() {
        ArrayList<class_1263> res = new ArrayList<class_1263>();
        res.add(this.getHotBar());
        res.add(this.getMain());
        res.add(this.getArmor());
        res.add(this.getOffhand());
        class_1263 d = this.getBackPack();
        if (d != null) {
            res.add(d);
        }
        if ((d = this.getSatchelLeft()) != null) {
            res.add(d);
        }
        if ((d = this.getSatchelRight()) != null) {
            res.add(d);
        }
        res.add((class_1263)this.getBags());
        return res;
    }

    public static int getHotbarSlotCount(class_1657 player) {
        if (player.method_7337()) {
            return 9;
        }
        return 6;
    }

    public class_1799 getAndClearCursorStack() {
        return this.cursorStack.method_51164();
    }

    public void setCursorStack(class_1799 cursorStack) {
        this.cursorStack = cursorStack;
    }

    public List<class_1263> getAllPickingInventories() {
        ArrayList<class_1263> res = new ArrayList<class_1263>();
        res.add(this.getHotBar());
        res.add(this.getOffhand());
        res.add(this.getMain());
        class_1263 d = this.getBackPack();
        if (d != null) {
            res.add(d);
        }
        if ((d = this.getSatchelLeft()) != null) {
            res.add(d);
        }
        if ((d = this.getSatchelRight()) != null) {
            res.add(d);
        }
        return res;
    }

    public Optional<class_3545<class_1263, Integer>> getEmptySlotInInventory() {
        for (class_1263 inv : this.getAllPickingInventories()) {
            int v = this.getEmptySlot(inv);
            if (v <= -1) continue;
            return Optional.of(new class_3545((Object)inv, (Object)v));
        }
        return Optional.empty();
    }

    public boolean insterStack(class_1799 stack) {
        if (stack.method_7986()) {
            Optional<class_3545<class_1263, Integer>> p = this.getEmptySlotInInventory();
            if (p.isPresent()) {
                ((class_1263)p.get().method_15442()).method_5447(((Integer)p.get().method_15441()).intValue(), stack.method_51164());
                ((class_1263)p.get().method_15442()).method_5438(((Integer)p.get().method_15441()).intValue()).method_7912(5);
                return true;
            }
        } else {
            int i;
            do {
                i = stack.method_7947();
                stack.method_7939(this.addStack(stack));
            } while (!stack.method_7960() && stack.method_7947() < i);
            return stack.method_7947() < i;
        }
        return false;
    }

    private int addStack(class_1799 stack) {
        Optional<class_3545<class_1263, Integer>> i = this.getOccupiedSlotWithRoomForStack(stack);
        if (i.isEmpty()) {
            i = this.getEmptySlotInInventory();
        }
        return i.isEmpty() ? stack.method_7947() : this.addStack(i.get(), stack);
    }

    public int addStack(class_3545<class_1263, Integer> pair, class_1799 stack) {
        return this.addStack((class_1263)pair.method_15442(), (Integer)pair.method_15441(), stack);
    }

    public int addStack(class_1263 inv, int slot, class_1799 stack) {
        class_1792 item = stack.method_7909();
        int i = stack.method_7947();
        class_1799 itemStack = inv.method_5438(slot);
        if (itemStack.method_7960()) {
            itemStack = new class_1799((class_1935)item, 0);
            if (stack.method_7985()) {
                itemStack.method_7980(stack.method_7969().method_10553());
            }
            inv.method_5447(slot, itemStack);
        }
        int j = i;
        if (i > itemStack.method_7914() - itemStack.method_7947()) {
            j = itemStack.method_7914() - itemStack.method_7947();
        }
        if (j > inv.method_5444() - itemStack.method_7947()) {
            j = inv.method_5444() - itemStack.method_7947();
        }
        if (j == 0) {
            return i;
        }
        itemStack.method_7933(j);
        itemStack.method_7912(5);
        return i -= j;
    }

    public Optional<class_3545<class_1263, Integer>> getOccupiedSlotWithRoomForStack(class_1799 stack) {
        if (this.canStackAddMore(this.getHotBar().method_5438(this.parent.method_31548().field_7545), stack)) {
            return Optional.of(new class_3545((Object)this.getHotBar(), (Object)this.parent.method_31548().field_7545));
        }
        if (this.canStackAddMore(this.getOffhand().method_5438(0), stack)) {
            return Optional.of(new class_3545((Object)this.getOffhand(), (Object)0));
        }
        for (class_1263 inv : this.getAllPickingInventories()) {
            for (int i = 0; i < inv.method_5439(); ++i) {
                if (!this.canStackAddMore(inv.method_5438(i), stack)) continue;
                return Optional.of(new class_3545((Object)inv, (Object)i));
            }
        }
        return Optional.empty();
    }

    private boolean canStackAddMore(class_1799 existingStack, class_1799 stack) {
        return !existingStack.method_7960() && class_1799.method_31577((class_1799)existingStack, (class_1799)stack) && existingStack.method_7946() && existingStack.method_7947() < existingStack.method_7914() && existingStack.method_7947() < 64;
    }

    public int getEmptySlot(class_1263 inventory) {
        for (int i = 0; i < inventory.method_5439(); ++i) {
            if (!inventory.method_5438(i).method_7960()) continue;
            return i;
        }
        return -1;
    }

    public void onCharacterLoad(class_1657 playerEntity, String s, ApiCharacterValues apiCharacterValues, @Nullable String s1) {
        this.clearCache();
    }

    public static class_2487 serializer(CustomPlayerInventory inst) {
        return inst.toNBTComplete();
    }

    public static void unserializer(CustomPlayerInventory inst, class_2487 nbt) {
        inst.fromNBTComplete(nbt, inst.getPlayer());
    }

    public void syncHotbarToServer() {
        if (this.getPlayer().method_7337()) {
            OffsetInventory hot = this.getHotBar();
            class_1799[] cont = new class_1799[hot.method_5439()];
            for (int i = 0; i < hot.method_5439(); ++i) {
                cont[i] = hot.method_5438(i);
            }
            Channels.MAIN.clientHandle().send((Record)new InventoryPackets.SyncCreativeHotbar(cont));
        }
    }

    public static void openInventoryScreen(class_1657 player) {
        class_3908 screen = new class_3908(){

            @Nullable
            public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
                CustomPlayerInventory inv = ((PlayerInventoryData)player.getComponent(Components.PLAYER_INVENTORY)).getInventory();
                return new VanillaPlayerInvMokup(syncId, player, new BagsGrid(inv, "bags", (class_1263)inv.getBags(), 1, 3));
            }

            public class_2561 method_5476() {
                return class_2561.method_43470((String)"Inventory");
            }
        };
        player.method_17355(screen);
    }

    public static class OffsetInventory
    implements class_1263 {
        public final class_1263 parent;
        public final int offset;
        public final int length;

        public OffsetInventory(class_1263 inventory, int startIndex, int size) {
            this.offset = startIndex;
            this.length = size;
            this.parent = inventory;
        }

        public int method_5439() {
            return this.length;
        }

        public boolean method_5442() {
            for (int i = 0; i < this.method_5439(); ++i) {
                if (this.method_5438(i).method_7960()) continue;
                return false;
            }
            return true;
        }

        public class_1799 method_5438(int slot) {
            return this.parent.method_5438(slot + this.offset);
        }

        public class_1799 method_5434(int slot, int amount) {
            return this.parent.method_5434(slot + this.offset, amount);
        }

        public class_1799 method_5441(int slot) {
            return this.parent.method_5441(slot + this.offset);
        }

        public void method_5447(int slot, class_1799 stack) {
            this.parent.method_5447(slot + this.offset, stack);
        }

        public void method_5431() {
            this.parent.method_5431();
        }

        public boolean method_5443(class_1657 player) {
            return this.parent.method_5443(player);
        }

        public void method_5448() {
            this.parent.method_5448();
        }
    }

    public static class PlayerLinkedInventory
    extends SlotedSimpleInventory {
        public final class_1657 player;

        public PlayerLinkedInventory(class_1657 player, int size) {
            super(size);
            this.player = player;
        }
    }
}

