/*
 * Decompiled with CFR 0.152.
 */
package com.diamssword.greenresurgence.datagen;

import com.diamssword.greenresurgence.blocks.SideShelfBlock;
import com.diamssword.greenresurgence.datagen.MyVariantsBlockStateSupplier;
import com.diamssword.greenresurgence.datagen.SchematicBlockStateSupplier;
import com.diamssword.greenresurgence.genericBlocks.GenericBlockSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2741;
import net.minecraft.class_2750;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_4910;
import net.minecraft.class_4917;
import net.minecraft.class_4918;
import net.minecraft.class_4922;
import net.minecraft.class_4925;
import net.minecraft.class_4926;
import net.minecraft.class_4935;
import net.minecraft.class_4936;
import net.minecraft.class_4942;
import net.minecraft.class_4943;
import net.minecraft.class_4944;
import net.minecraft.class_4945;
import net.minecraft.class_4946;

public class ModelHelper {
    public final String subdomain;

    public ModelHelper(String subdomain) {
        this.subdomain = subdomain;
    }

    public class_4917 createVariantsStates(class_4917 base, int count) {
        if (count > 0) {
            return new MyVariantsBlockStateSupplier(base, count);
        }
        return base;
    }

    public class_2960 transformVariantModelId(class_2960 parent, int variants) {
        if (variants > 0) {
            return parent.method_48331("/0");
        }
        return parent;
    }

    public void registerModel(class_4946.class_4947 factory, class_2248 block, String name, class_4910 generator, int variants, class_4945 ... keys) {
        class_4946 tm = factory.get(block);
        class_4942 mod = tm.method_25914();
        if (variants <= 0) {
            mod.method_25852(this.getBlockModelId(name), factory.get(block).method_25921(), generator.field_22831);
        } else {
            for (int i = 0; i < variants; ++i) {
                class_4944 map = new class_4944();
                for (class_4945 textureKey : keys) {
                    class_2960 path = tm.method_25921().method_25867(textureKey);
                    String st = path.method_12832().substring(0, path.method_12832().lastIndexOf("/"));
                    String st1 = path.method_12832().substring(path.method_12832().lastIndexOf("/"));
                    map.method_25868(textureKey, new class_2960(path.method_12836(), st + st1 + st1 + i));
                }
                mod.method_25852(this.getBlockModelId(name + "/" + i), map, generator.field_22831);
            }
        }
    }

    private void registerModel(class_4942 model, String name, String suffix, class_4910 generator, int variants, class_4944 map, class_4945 ... keys) {
        if (variants <= 0) {
            model.method_25852(this.getBlockModelId(name + suffix), map, generator.field_22831);
        } else {
            for (int i = 0; i < variants; ++i) {
                class_4944 map1 = new class_4944();
                for (class_4945 textureKey : keys) {
                    class_2960 path = map.method_25867(textureKey);
                    String st = path.method_12832().substring(0, path.method_12832().lastIndexOf("/"));
                    String st1 = path.method_12832().substring(path.method_12832().lastIndexOf("/"));
                    map1.method_25868(textureKey, new class_2960(path.method_12836(), st + st1 + st1 + i));
                }
                model.method_25852(this.getBlockModelId(name + suffix + "/" + i), map1, generator.field_22831);
            }
        }
    }

    public void registerModel(class_4946.class_4947 factory, GenericBlockSet.ModelType model, class_2248 block, String name, class_4910 generator, int variants) {
        this.registerModel(factory, block, name, generator, variants, this.getTextureKeysFor(model));
    }

    public class_4945[] getTextureKeysFor(GenericBlockSet.ModelType type) {
        switch (type) {
            case SIMPLE: {
                return new class_4945[]{class_4945.field_23010};
            }
            case PILLAR: 
            case INVERSED_PILLAR: {
                return new class_4945[]{class_4945.field_23013, class_4945.field_23018};
            }
            case COMPOSTER: {
                return new class_4945[]{class_4945.field_23012, class_4945.field_23018, class_4945.field_23015, class_4945.field_23014, class_4945.field_27791};
            }
            case MACHINE: {
                return new class_4945[]{class_4945.field_23015, class_4945.field_23018, class_4945.field_23016, class_4945.field_23014};
            }
            case BOTOMLESS_MACHINE: {
                return new class_4945[]{class_4945.field_23015, class_4945.field_23018, class_4945.field_23016};
            }
            case TWO_TEXTURED_MACHINE: {
                return new class_4945[]{class_4945.field_23018, class_4945.field_23016};
            }
            case SLAB: 
            case SLAB_3TEX: {
                return new class_4945[]{class_4945.field_23016, class_4945.field_23018, class_4945.field_23017};
            }
            case CARPET: 
            case LADDER: {
                return new class_4945[]{class_4945.field_23012};
            }
        }
        return new class_4945[]{class_4945.field_23010};
    }

    public class_4946.class_4947 getModeleFactoryFor(GenericBlockSet.ModelType type, String name) {
        switch (type) {
            case SIMPLE: {
                return class_4946.method_25918(b1 -> class_4944.method_25875((class_2960)this.getBlockModelId(name)), (class_4942)new class_4942(Optional.of(new class_2960("minecraft", "block/cube_all")), Optional.empty(), this.getTextureKeysFor(type)));
            }
            case PILLAR: {
                return class_4946.method_25918(b1 -> this.textureMapPillar(name), (class_4942)new class_4942(Optional.of(new class_2960("minecraft", "block/cube_column_horizontal")), Optional.empty(), this.getTextureKeysFor(type)));
            }
            case COMPOSTER: {
                return class_4946.method_25918(b1 -> this.textureMapComposter(name), (class_4942)new class_4942(Optional.of(new class_2960("block/composter")), Optional.empty(), this.getTextureKeysFor(type)));
            }
            case INVERSED_PILLAR: {
                return class_4946.method_25918(b1 -> this.textureMapPillar(name), (class_4942)new class_4942(Optional.of(new class_2960("green_resurgence", "block/generic/cube_column_vertical")), Optional.empty(), this.getTextureKeysFor(type)));
            }
            case MACHINE: {
                return class_4946.method_25918(b1 -> this.textureMapMachine(name, false, false), (class_4942)new class_4942(Optional.of(new class_2960("minecraft", "block/orientable_with_bottom")), Optional.empty(), this.getTextureKeysFor(type)));
            }
            case BOTOMLESS_MACHINE: {
                return class_4946.method_25918(b1 -> this.textureMapMachine(name, true, false), (class_4942)new class_4942(Optional.of(new class_2960("minecraft", "block/orientable")), Optional.empty(), this.getTextureKeysFor(type)));
            }
            case TWO_TEXTURED_MACHINE: {
                return class_4946.method_25918(b1 -> this.textureMapMachine(name, true, true), (class_4942)new class_4942(Optional.of(new class_2960("green_resurgence", "block/generic/simple_orientable")), Optional.empty(), this.getTextureKeysFor(type)));
            }
            case WALL: {
                break;
            }
            case SLAB_3TEX: {
                return class_4946.method_25918(b1 -> this.textureOmniSlab(name, GenericBlockSet.ModelType.MACHINE), (class_4942)new class_4942(Optional.of(new class_2960("green_resurgence", "block/generic/omni_slab")), Optional.empty(), this.getTextureKeysFor(type)));
            }
            case SLAB: {
                return class_4946.method_25918(b1 -> this.textureOmniSlab(name, GenericBlockSet.ModelType.SIMPLE), (class_4942)new class_4942(Optional.of(new class_2960("green_resurgence", "block/generic/omni_slab")), Optional.empty(), this.getTextureKeysFor(type)));
            }
            case LADDER: {
                class_4944 map = new class_4944();
                map.method_25868(class_4945.field_23012, this.getBlockModelId(name));
                return class_4946.method_25918(b1 -> map, (class_4942)new class_4942(Optional.of(new class_2960("green_resurgence", "block/generic/ladder")), Optional.empty(), this.getTextureKeysFor(type)));
            }
            case CARPET: {
                return class_4946.method_25918(b1 -> new class_4944().method_25868(class_4945.field_23012, this.getBlockModelId(name)), (class_4942)new class_4942(Optional.of(new class_2960("green_resurgence", "block/generic/omni_carpet")), Optional.empty(), this.getTextureKeysFor(type)));
            }
        }
        return class_4946.method_25918(b1 -> class_4944.method_25875((class_2960)this.getBlockModelId(name)), (class_4942)new class_4942(Optional.of(new class_2960("minecraft", "block/cube_all")), Optional.empty(), this.getTextureKeysFor(type)));
    }

    public class_4946.class_4947[] getModelForStairs(String name, GenericBlockSet.ModelType model) {
        return new class_4946.class_4947[]{class_4946.method_25918(b1 -> this.textureMapStairs(name, model), (class_4942)new class_4942(Optional.of(new class_2960("minecraft", "block/stairs")), Optional.empty(), new class_4945[]{class_4945.field_23014, class_4945.field_23015, class_4945.field_23018})), class_4946.method_25918(b1 -> this.textureMapStairs(name, model), (class_4942)new class_4942(Optional.of(new class_2960("minecraft", "block/inner_stairs")), Optional.empty(), new class_4945[]{class_4945.field_23014, class_4945.field_23015, class_4945.field_23018})), class_4946.method_25918(b1 -> this.textureMapStairs(name, model), (class_4942)new class_4942(Optional.of(new class_2960("minecraft", "block/outer_stairs")), Optional.empty(), new class_4945[]{class_4945.field_23014, class_4945.field_23015, class_4945.field_23018}))};
    }

    public class_4944 textureMapPillar(String name) {
        class_4944 map = new class_4944();
        map.method_25868(class_4945.field_23018, this.getBlockModelId(name).method_48331("_side"));
        map.method_25868(class_4945.field_23013, this.getBlockModelId(name).method_48331("_top"));
        return map;
    }

    public class_4944 textureMapComposter(String name) {
        class_4944 map = new class_4944();
        map.method_25868(class_4945.field_23018, this.getBlockModelId(name).method_48331("_side"));
        map.method_25868(class_4945.field_23015, this.getBlockModelId(name).method_48331("_top"));
        map.method_25868(class_4945.field_23012, this.getBlockModelId(name).method_48331("_side"));
        map.method_25868(class_4945.field_23014, this.getBlockModelId(name).method_48331("_bottom"));
        map.method_25868(class_4945.field_27791, this.getBlockModelId(name).method_48331("_bottom"));
        return map;
    }

    public class_4944 textureMapMachine(String name, boolean noBottom, boolean noTop) {
        class_4944 map = new class_4944();
        map.method_25868(class_4945.field_23018, this.getBlockModelId(name).method_48331("_side"));
        if (!noTop) {
            map.method_25868(class_4945.field_23015, this.getBlockModelId(name).method_48331("_top"));
        }
        map.method_25868(class_4945.field_23016, this.getBlockModelId(name).method_48331("_front"));
        if (!noBottom) {
            map.method_25868(class_4945.field_23014, this.getBlockModelId(name).method_48331("_bottom"));
        }
        return map;
    }

    public class_4944 textureOmniSlab(String name, GenericBlockSet.ModelType type) {
        class_4944 map = new class_4944();
        if (type == GenericBlockSet.ModelType.SIMPLE) {
            map.method_25868(class_4945.field_23018, this.getBlockModelId(name));
            map.method_25868(class_4945.field_23016, this.getBlockModelId(name));
            map.method_25868(class_4945.field_23017, this.getBlockModelId(name));
        } else {
            map.method_25868(class_4945.field_23018, this.getBlockModelId(name).method_48331("_side"));
            map.method_25868(class_4945.field_23016, this.getBlockModelId(name).method_48331("_front"));
            map.method_25868(class_4945.field_23017, this.getBlockModelId(name).method_48331("_back"));
        }
        return map;
    }

    public class_4944 textureMapStairs(String name, GenericBlockSet.ModelType type) {
        class_4944 map = new class_4944();
        if (type == GenericBlockSet.ModelType.SIMPLE) {
            map.method_25868(class_4945.field_23018, this.getBlockModelId(name));
            map.method_25868(class_4945.field_23014, this.getBlockModelId(name));
            map.method_25868(class_4945.field_23015, this.getBlockModelId(name));
        } else {
            map.method_25868(class_4945.field_23018, this.getBlockModelId(name).method_48331("_side"));
            map.method_25868(class_4945.field_23014, this.getBlockModelId(name).method_48331("_back"));
            map.method_25868(class_4945.field_23015, this.getBlockModelId(name).method_48331("_front"));
        }
        return map;
    }

    public void registerTrapdoor(class_4910 generator, String name, class_2248 trapdoorBlock) {
        class_4944 textureMap = class_4944.method_25869((class_2960)this.getBlockModelId(name));
        class_2960 identifier = class_4943.field_22915.method_25852(this.getBlockModelId(name).method_48331("_top"), textureMap, generator.field_22831);
        class_2960 identifier2 = class_4943.field_22916.method_25852(this.getBlockModelId(name), textureMap, generator.field_22831);
        class_2960 identifier3 = class_4943.field_22917.method_25852(this.getBlockModelId(name).method_48331("_open"), textureMap, generator.field_22831);
        generator.field_22830.accept(class_4910.method_25662((class_2248)trapdoorBlock, (class_2960)identifier, (class_2960)identifier2, (class_2960)identifier3));
    }

    public final void registerLantern(class_4910 generator, String name, class_2248 lantern) {
        class_4944 textureMap = new class_4944().method_25868(class_4945.field_23002, this.getBlockModelId(name));
        class_4944 textureMap_off = new class_4944().method_25868(class_4945.field_23002, this.getBlockModelId(name).method_48331("_off"));
        class_2960 identifier1 = new class_4942(Optional.of(new class_2960("minecraft", "block/template_lantern")), Optional.empty(), new class_4945[]{class_4945.field_23002}).method_25852(this.getBlockModelId(name), textureMap, generator.field_22831);
        class_2960 identifier2 = new class_4942(Optional.of(new class_2960("minecraft", "block/template_hanging_lantern")), Optional.empty(), new class_4945[]{class_4945.field_23002}).method_25852(this.getBlockModelId(name).method_48331("_top"), textureMap, generator.field_22831);
        class_2960 identifier3 = new class_4942(Optional.of(new class_2960("green_resurgence", "block/generic/side_lantern")), Optional.empty(), new class_4945[]{class_4945.field_23002}).method_25852(this.getBlockModelId(name).method_48331("_side"), textureMap, generator.field_22831);
        class_2960 identifier4 = new class_4942(Optional.of(new class_2960("minecraft", "block/template_lantern")), Optional.empty(), new class_4945[]{class_4945.field_23002}).method_25852(this.getBlockModelId(name).method_48331("_off"), textureMap_off, generator.field_22831);
        class_2960 identifier5 = new class_4942(Optional.of(new class_2960("minecraft", "block/template_hanging_lantern")), Optional.empty(), new class_4945[]{class_4945.field_23002}).method_25852(this.getBlockModelId(name).method_48331("_top_off"), textureMap_off, generator.field_22831);
        class_2960 identifier6 = new class_4942(Optional.of(new class_2960("green_resurgence", "block/generic/side_lantern")), Optional.empty(), new class_4945[]{class_4945.field_23002}).method_25852(this.getBlockModelId(name).method_48331("_side_off"), textureMap_off, generator.field_22831);
        generator.field_22830.accept(class_4925.method_25769((class_2248)lantern).method_25775(ModelHelper.fillLanternVariantMap((class_4926.class_4928<class_2350, Boolean>)class_4926.method_25784((class_2769)class_2741.field_12525, (class_2769)class_2741.field_12548), identifier1, identifier2, identifier3, identifier4, identifier5, identifier6)));
    }

    public final void registerBed(class_4910 generator, String name, class_2248 lantern) {
        class_4945 key = class_4945.method_27043((String)"bed");
        class_4944 textureMap = new class_4944().method_25868(key, this.getBlockModelId(name));
        class_2960 identifier1 = new class_4942(Optional.of(new class_2960("green_resurgence", "block/generic/bed")), Optional.empty(), new class_4945[]{key}).method_25852(this.getBlockModelId(name), textureMap, generator.field_22831);
        generator.field_22830.accept(class_4925.method_25769((class_2248)lantern).method_25775((class_4926)class_4926.method_25783((class_2769)class_2741.field_12481).method_25793((Comparable)class_2350.field_11035, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)identifier1)).method_25793((Comparable)class_2350.field_11039, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)identifier1).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891)).method_25793((Comparable)class_2350.field_11034, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)identifier1).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22893)).method_25793((Comparable)class_2350.field_11043, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)identifier1).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22892))));
    }

    public final void registerGlassPane(class_4910 generator, String name, class_2248 glassPane, boolean isIron) {
        class_4944 textureMap = new class_4944().method_25868(class_4945.field_23031, this.getBlockModelId(name)).method_25868(class_4945.field_23032, isIron ? this.getBlockModelId(name) : this.getBlockModelId(name).method_48331("_pane_top"));
        class_2960 identifier = class_4943.field_22953.method_25852(this.getBlockModelId(name).method_48331("_post"), textureMap, generator.field_22831);
        class_2960 identifier2 = class_4943.field_22954.method_25852(this.getBlockModelId(name).method_48331("_side"), textureMap, generator.field_22831);
        class_2960 identifier3 = class_4943.field_22955.method_25852(this.getBlockModelId(name).method_48331("_side_alt"), textureMap, generator.field_22831);
        class_2960 identifier4 = class_4943.field_22951.method_25852(this.getBlockModelId(name).method_48331("_noside"), textureMap, generator.field_22831);
        class_2960 identifier5 = class_4943.field_22952.method_25852(this.getBlockModelId(name).method_48331("_noside_alt"), textureMap, generator.field_22831);
        generator.field_22830.accept(class_4922.method_25758((class_2248)glassPane).method_25763(class_4935.method_25824().method_25828(class_4936.field_22887, (Object)identifier)).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_12489, (Comparable)Boolean.valueOf(true)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)identifier2)).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_12487, (Comparable)Boolean.valueOf(true)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)identifier2).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891)).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_12540, (Comparable)Boolean.valueOf(true)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)identifier3)).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_12527, (Comparable)Boolean.valueOf(true)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)identifier3).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891)).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_12489, (Comparable)Boolean.valueOf(false)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)identifier4)).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_12487, (Comparable)Boolean.valueOf(false)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)identifier5)).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_12540, (Comparable)Boolean.valueOf(false)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)identifier5).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891)).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_12527, (Comparable)Boolean.valueOf(false)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)identifier4).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22893)));
    }

    public final void registerFence(class_4910 generator, String name, class_2248 fence, int variants, boolean isWall) {
        class_4945 key = isWall ? class_4945.field_23027 : class_4945.field_23011;
        class_4944 textureMap = new class_4944().method_25868(key, this.getBlockModelId(name.replace("_fence", "")));
        this.registerModel(isWall ? class_4943.field_22991 : class_4943.field_22988, name, "_post", generator, variants, textureMap, key);
        this.registerModel(isWall ? class_4943.field_22992 : class_4943.field_22989, name, "_side", generator, variants, textureMap, key);
        class_2960 identifier = this.getBlockModelId(name).method_48331("_post");
        class_2960 identifier2 = this.getBlockModelId(name).method_48331("_side");
        class_4922 bs = class_4922.method_25758((class_2248)fence).method_25763(class_4935.method_25824().method_25828(class_4936.field_22887, (Object)identifier)).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_12489, (Comparable)Boolean.valueOf(true)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)identifier2).method_25828(class_4936.field_22888, (Object)true)).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_12487, (Comparable)Boolean.valueOf(true)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)identifier2).method_25828(class_4936.field_22888, (Object)true).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891)).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_12540, (Comparable)Boolean.valueOf(true)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)identifier2).method_25828(class_4936.field_22888, (Object)true).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22892)).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_12527, (Comparable)Boolean.valueOf(true)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)identifier2).method_25828(class_4936.field_22888, (Object)true).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22893));
        generator.field_22830.accept(this.createVariantsStates((class_4917)bs, variants));
    }

    public void registerDoor(class_4910 generator, String name, class_2248 doorBlock) {
        class_4944 textureMap = class_4944.method_25869((class_2960)this.getBlockModelId(name));
        class_2960 identifier = new class_4942(Optional.of(new class_2960("green_resurgence", "block/generic/door_left")), Optional.empty(), new class_4945[]{class_4945.field_23012}).method_25852(this.getBlockModelId(name).method_48331("_left"), textureMap, generator.field_22831);
        class_2960 identifier2 = new class_4942(Optional.of(new class_2960("green_resurgence", "block/generic/door_left_open")), Optional.empty(), new class_4945[]{class_4945.field_23012}).method_25852(this.getBlockModelId(name).method_48331("_left_open"), textureMap, generator.field_22831);
        class_2960 identifier3 = new class_4942(Optional.of(new class_2960("green_resurgence", "block/generic/door_right")), Optional.empty(), new class_4945[]{class_4945.field_23012}).method_25852(this.getBlockModelId(name).method_48331("_right"), textureMap, generator.field_22831);
        class_2960 identifier4 = new class_4942(Optional.of(new class_2960("green_resurgence", "block/generic/door_right_open")), Optional.empty(), new class_4945[]{class_4945.field_23012}).method_25852(this.getBlockModelId(name).method_48331("_right_open"), textureMap, generator.field_22831);
        generator.field_22830.accept(ModelHelper.createDoorBlockState(doorBlock, identifier, identifier2, identifier3, identifier4));
    }

    public static class_4917 createDoorBlockState(class_2248 doorBlock, class_2960 LeftHingeClosedModelId, class_2960 LeftHingeOpenModelId, class_2960 RightHingeClosedModelId, class_2960 RightHingeOpenModelId) {
        return class_4925.method_25769((class_2248)doorBlock).method_25775(ModelHelper.fillDoorVariantMap((class_4926.class_4929<class_2350, class_2750, Boolean>)class_4926.method_25785((class_2769)class_2741.field_12481, (class_2769)class_2741.field_12520, (class_2769)class_2741.field_12537), LeftHingeClosedModelId, LeftHingeOpenModelId, RightHingeClosedModelId, RightHingeOpenModelId));
    }

    public static class_4926.class_4929<class_2350, class_2750, Boolean> fillDoorVariantMap(class_4926.class_4929<class_2350, class_2750, Boolean> variantMap, class_2960 leftHingeClosedModelId, class_2960 leftHingeOpenModelId, class_2960 rightHingeClosedModelId, class_2960 rightHingeOpenModelId) {
        return variantMap.method_25806((Comparable)class_2350.field_11039, (Comparable)class_2750.field_12588, (Comparable)Boolean.valueOf(false), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)leftHingeClosedModelId).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22892)).method_25806((Comparable)class_2350.field_11039, (Comparable)class_2750.field_12588, (Comparable)Boolean.valueOf(true), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)leftHingeOpenModelId).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22892)).method_25806((Comparable)class_2350.field_11043, (Comparable)class_2750.field_12588, (Comparable)Boolean.valueOf(false), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)leftHingeClosedModelId).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22893)).method_25806((Comparable)class_2350.field_11043, (Comparable)class_2750.field_12588, (Comparable)Boolean.valueOf(true), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)leftHingeOpenModelId).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22893)).method_25806((Comparable)class_2350.field_11034, (Comparable)class_2750.field_12586, (Comparable)Boolean.valueOf(false), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)rightHingeClosedModelId)).method_25806((Comparable)class_2350.field_11034, (Comparable)class_2750.field_12586, (Comparable)Boolean.valueOf(true), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)rightHingeOpenModelId)).method_25806((Comparable)class_2350.field_11035, (Comparable)class_2750.field_12586, (Comparable)Boolean.valueOf(false), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)rightHingeClosedModelId).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891)).method_25806((Comparable)class_2350.field_11035, (Comparable)class_2750.field_12586, (Comparable)Boolean.valueOf(true), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)rightHingeOpenModelId).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891)).method_25806((Comparable)class_2350.field_11039, (Comparable)class_2750.field_12586, (Comparable)Boolean.valueOf(false), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)rightHingeClosedModelId).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22892)).method_25806((Comparable)class_2350.field_11039, (Comparable)class_2750.field_12586, (Comparable)Boolean.valueOf(true), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)rightHingeOpenModelId).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22892)).method_25806((Comparable)class_2350.field_11043, (Comparable)class_2750.field_12586, (Comparable)Boolean.valueOf(false), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)rightHingeClosedModelId).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22893)).method_25806((Comparable)class_2350.field_11043, (Comparable)class_2750.field_12586, (Comparable)Boolean.valueOf(true), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)rightHingeOpenModelId).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22893)).method_25806((Comparable)class_2350.field_11034, (Comparable)class_2750.field_12588, (Comparable)Boolean.valueOf(false), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)leftHingeClosedModelId)).method_25806((Comparable)class_2350.field_11034, (Comparable)class_2750.field_12588, (Comparable)Boolean.valueOf(true), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)leftHingeOpenModelId)).method_25806((Comparable)class_2350.field_11035, (Comparable)class_2750.field_12588, (Comparable)Boolean.valueOf(false), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)leftHingeClosedModelId).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891)).method_25806((Comparable)class_2350.field_11035, (Comparable)class_2750.field_12588, (Comparable)Boolean.valueOf(true), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)leftHingeOpenModelId).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891));
    }

    public static class_4926.class_4928<class_2350, Boolean> fillConnectedPillarVariantMap(class_4926.class_4928<class_2350, Boolean> variantMap, class_2960 down, class_2960 up) {
        return variantMap.method_25797((Comparable)class_2350.field_11039, (Comparable)Boolean.valueOf(true), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)up).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22893)).method_25797((Comparable)class_2350.field_11043, (Comparable)Boolean.valueOf(true), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)up).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22890)).method_25797((Comparable)class_2350.field_11035, (Comparable)Boolean.valueOf(true), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)up).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22892)).method_25797((Comparable)class_2350.field_11034, (Comparable)Boolean.valueOf(true), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)up).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891)).method_25797((Comparable)class_2350.field_11039, (Comparable)Boolean.valueOf(false), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)down).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22893)).method_25797((Comparable)class_2350.field_11043, (Comparable)Boolean.valueOf(false), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)down).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22890)).method_25797((Comparable)class_2350.field_11035, (Comparable)Boolean.valueOf(false), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)down).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22892)).method_25797((Comparable)class_2350.field_11034, (Comparable)Boolean.valueOf(false), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)down).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891));
    }

    public static class_4926.class_4928<class_2350, Boolean> fillLanternVariantMap(class_4926.class_4928<class_2350, Boolean> variantMap, class_2960 down, class_2960 up, class_2960 side, class_2960 down_off, class_2960 up_off, class_2960 side_off) {
        return variantMap.method_25797((Comparable)class_2350.field_11036, (Comparable)Boolean.valueOf(true), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)up)).method_25797((Comparable)class_2350.field_11033, (Comparable)Boolean.valueOf(true), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)down)).method_25797((Comparable)class_2350.field_11039, (Comparable)Boolean.valueOf(true), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)side).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22893)).method_25797((Comparable)class_2350.field_11043, (Comparable)Boolean.valueOf(true), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)side).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22890)).method_25797((Comparable)class_2350.field_11035, (Comparable)Boolean.valueOf(true), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)side).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22892)).method_25797((Comparable)class_2350.field_11034, (Comparable)Boolean.valueOf(true), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)side).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891)).method_25797((Comparable)class_2350.field_11036, (Comparable)Boolean.valueOf(false), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)up_off)).method_25797((Comparable)class_2350.field_11033, (Comparable)Boolean.valueOf(false), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)down_off)).method_25797((Comparable)class_2350.field_11039, (Comparable)Boolean.valueOf(false), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)side_off).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22893)).method_25797((Comparable)class_2350.field_11043, (Comparable)Boolean.valueOf(false), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)side_off).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22890)).method_25797((Comparable)class_2350.field_11035, (Comparable)Boolean.valueOf(false), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)side_off).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22892)).method_25797((Comparable)class_2350.field_11034, (Comparable)Boolean.valueOf(false), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)side_off).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891));
    }

    public static class_4926.class_4928<class_2350, SideShelfBlock.Model> fillConnectedBlockVariantMap(class_4926.class_4928<class_2350, SideShelfBlock.Model> variantMap, class_2960 single, class_2960 center, class_2960 left, class_2960 right) {
        class_4926.class_4928 res = variantMap.method_25797((Comparable)class_2350.field_11039, (Comparable)((Object)SideShelfBlock.Model.SINGLE), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)single).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22893)).method_25797((Comparable)class_2350.field_11043, (Comparable)((Object)SideShelfBlock.Model.SINGLE), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)single).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22890)).method_25797((Comparable)class_2350.field_11035, (Comparable)((Object)SideShelfBlock.Model.SINGLE), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)single).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22892)).method_25797((Comparable)class_2350.field_11034, (Comparable)((Object)SideShelfBlock.Model.SINGLE), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)single).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891)).method_25797((Comparable)class_2350.field_11039, (Comparable)((Object)SideShelfBlock.Model.CENTER), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)center).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22893)).method_25797((Comparable)class_2350.field_11043, (Comparable)((Object)SideShelfBlock.Model.CENTER), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)center).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22890)).method_25797((Comparable)class_2350.field_11035, (Comparable)((Object)SideShelfBlock.Model.CENTER), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)center).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22892)).method_25797((Comparable)class_2350.field_11034, (Comparable)((Object)SideShelfBlock.Model.CENTER), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)center).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891)).method_25797((Comparable)class_2350.field_11039, (Comparable)((Object)SideShelfBlock.Model.LEFT), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)left).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22893)).method_25797((Comparable)class_2350.field_11043, (Comparable)((Object)SideShelfBlock.Model.LEFT), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)left).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22890)).method_25797((Comparable)class_2350.field_11035, (Comparable)((Object)SideShelfBlock.Model.LEFT), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)left).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22892)).method_25797((Comparable)class_2350.field_11034, (Comparable)((Object)SideShelfBlock.Model.LEFT), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)left).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891)).method_25797((Comparable)class_2350.field_11039, (Comparable)((Object)SideShelfBlock.Model.RIGHT), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)right).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22893)).method_25797((Comparable)class_2350.field_11043, (Comparable)((Object)SideShelfBlock.Model.RIGHT), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)right).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22890)).method_25797((Comparable)class_2350.field_11035, (Comparable)((Object)SideShelfBlock.Model.RIGHT), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)right).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22892)).method_25797((Comparable)class_2350.field_11034, (Comparable)((Object)SideShelfBlock.Model.RIGHT), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)right).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891));
        return res;
    }

    public static class_4926.class_4928<class_2350, Boolean> fillToggleableVariantMap(class_4926.class_4928<class_2350, Boolean> variantMap, class_2960 normal, class_2960 toggled, boolean allrotation) {
        class_4926.class_4928 res = variantMap.method_25797((Comparable)class_2350.field_11039, (Comparable)Boolean.valueOf(true), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)toggled).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22893)).method_25797((Comparable)class_2350.field_11043, (Comparable)Boolean.valueOf(true), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)toggled).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22890)).method_25797((Comparable)class_2350.field_11035, (Comparable)Boolean.valueOf(true), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)toggled).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22892)).method_25797((Comparable)class_2350.field_11034, (Comparable)Boolean.valueOf(true), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)toggled).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891)).method_25797((Comparable)class_2350.field_11039, (Comparable)Boolean.valueOf(false), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)normal).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22893)).method_25797((Comparable)class_2350.field_11043, (Comparable)Boolean.valueOf(false), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)normal).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22890)).method_25797((Comparable)class_2350.field_11035, (Comparable)Boolean.valueOf(false), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)normal).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22892)).method_25797((Comparable)class_2350.field_11034, (Comparable)Boolean.valueOf(false), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)normal).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891));
        if (allrotation) {
            res.method_25797((Comparable)class_2350.field_11036, (Comparable)Boolean.valueOf(true), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)toggled).method_25828(class_4936.field_22885, (Object)class_4936.class_4937.field_22893));
            res.method_25797((Comparable)class_2350.field_11033, (Comparable)Boolean.valueOf(true), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)toggled).method_25828(class_4936.field_22885, (Object)class_4936.class_4937.field_22891));
            res.method_25797((Comparable)class_2350.field_11036, (Comparable)Boolean.valueOf(false), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)normal).method_25828(class_4936.field_22885, (Object)class_4936.class_4937.field_22893));
            res.method_25797((Comparable)class_2350.field_11033, (Comparable)Boolean.valueOf(false), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)normal).method_25828(class_4936.field_22885, (Object)class_4936.class_4937.field_22891));
        }
        return res;
    }

    public static class_4926.class_4928<class_2350, Integer> fillMultistateVariantMap(class_4926.class_4928<class_2350, Integer> variantMap, class_2960 base, int max) {
        for (int i = 1; i <= max; ++i) {
            variantMap.method_25797((Comparable)class_2350.field_11039, (Comparable)Integer.valueOf(i), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)base.method_48331("_" + i)).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22893)).method_25797((Comparable)class_2350.field_11043, (Comparable)Integer.valueOf(i), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)base.method_48331("_" + i)).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22890)).method_25797((Comparable)class_2350.field_11035, (Comparable)Integer.valueOf(i), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)base.method_48331("_" + i)).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22892)).method_25797((Comparable)class_2350.field_11034, (Comparable)Integer.valueOf(i), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)base.method_48331("_" + i)).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891));
        }
        return variantMap;
    }

    public class_2960 getBlockModelId(String baseID) {
        return new class_2960("green_resurgence", "block/" + this.subdomain + "/" + baseID);
    }

    public class_2960 getBlockModelId(String baseID, String prefixPath) {
        return new class_2960("green_resurgence", "block/" + this.subdomain + "/" + prefixPath + baseID);
    }

    public SchematicBlockStateSupplier alterSchematic(class_2248 b, String schemName, String key, String replace) {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put(key, replace);
        return new SchematicBlockStateSupplier(b, schemName, m);
    }

    public SchematicBlockStateSupplier alterSchematic(class_2248 b, String schemName, Map<String, String> keys) {
        return new SchematicBlockStateSupplier(b, schemName, keys);
    }
}

