/*
 * Decompiled with CFR 0.152.
 */
package com.diamssword.greenresurgence.genericBlocks;

import com.diamssword.greenresurgence.blocks.SideShelfBlock;
import com.diamssword.greenresurgence.datagen.LangGenerator;
import com.diamssword.greenresurgence.datagen.ModelHelper;
import com.diamssword.greenresurgence.datagen.SchematicBlockStateSupplier;
import com.diamssword.greenresurgence.genericBlocks.AllDirectionVine;
import com.diamssword.greenresurgence.genericBlocks.BedGeneric;
import com.diamssword.greenresurgence.genericBlocks.DoorDoubleBlock;
import com.diamssword.greenresurgence.genericBlocks.DoorLongBlock;
import com.diamssword.greenresurgence.genericBlocks.GenericBlock;
import com.diamssword.greenresurgence.genericBlocks.GenericBlockToggleable;
import com.diamssword.greenresurgence.genericBlocks.GenericBlocks;
import com.diamssword.greenresurgence.genericBlocks.GenericConnectedPillar;
import com.diamssword.greenresurgence.genericBlocks.GenericPillar;
import com.diamssword.greenresurgence.genericBlocks.GenericPillarMultiState;
import com.diamssword.greenresurgence.genericBlocks.GenericPillarToggleable;
import com.diamssword.greenresurgence.genericBlocks.GenericTable;
import com.diamssword.greenresurgence.genericBlocks.LanternGeneric;
import com.diamssword.greenresurgence.genericBlocks.LecternShapedBlock;
import com.diamssword.greenresurgence.genericBlocks.OmniBlock;
import com.diamssword.greenresurgence.genericBlocks.OmniBlockToggleable;
import com.diamssword.greenresurgence.genericBlocks.RotatableSlabBlock;
import com.diamssword.greenresurgence.items.BlockVariantItem;
import io.wispforest.owo.itemgroup.OwoItemSettings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricBlockLootTableProvider;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricLanguageProvider;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricTagProvider;
import net.minecraft.class_1747;
import net.minecraft.class_1765;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2323;
import net.minecraft.class_2350;
import net.minecraft.class_2354;
import net.minecraft.class_2378;
import net.minecraft.class_2389;
import net.minecraft.class_2498;
import net.minecraft.class_2510;
import net.minecraft.class_2533;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import net.minecraft.class_3619;
import net.minecraft.class_3620;
import net.minecraft.class_4910;
import net.minecraft.class_4915;
import net.minecraft.class_4917;
import net.minecraft.class_4925;
import net.minecraft.class_4926;
import net.minecraft.class_4935;
import net.minecraft.class_4936;
import net.minecraft.class_4941;
import net.minecraft.class_4942;
import net.minecraft.class_4944;
import net.minecraft.class_4945;
import net.minecraft.class_4946;
import net.minecraft.class_4970;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_8177;

public class GenericBlockSet {
    public final String subdomain;
    private final ModelHelper helper;
    private final List<GenericBlockRegisterInstance> blocks = new ArrayList<GenericBlockRegisterInstance>();
    private final List<GeneratedBlockInstance> generatedBlocks = new ArrayList<GeneratedBlockInstance>();
    private final List<GeneratedItemInstance> generatedItems = new ArrayList<GeneratedItemInstance>();
    private final Map<String, BlockVariantItem> itemGroups = new HashMap<String, BlockVariantItem>();
    private int tabIndex;

    public GenericBlockSet(String subdomain) {
        this.subdomain = subdomain;
        this.helper = new ModelHelper(this.subdomain);
    }

    public void setTabIndex(int ind) {
        this.tabIndex = ind;
    }

    public class_1799 displayStack() {
        return this.generatedBlocks.isEmpty() ? new class_1799((class_1935)class_1802.field_8600) : new class_1799((class_1935)this.generatedBlocks.get((int)0).block);
    }

    public GenericBlockRegisterInstance create(String ... names) {
        GenericBlockRegisterInstance d = new GenericBlockRegisterInstance(names);
        this.blocks.add(d);
        return d;
    }

    public GenericBlockRegisterInstance add(String name, Transparency render, BlockType ... blocks) {
        GenericBlockRegisterInstance d = new GenericBlockRegisterInstance(name);
        for (BlockType block : blocks) {
            d.addSub(block);
        }
        d.setTransparency(render);
        this.blocks.add(d);
        return d;
    }

    private void genericRegisterHelper(String name, GenericBlockProp entry, class_2248 b) {
        class_2378.method_10230((class_2378)class_7923.field_41175, (class_2960)this.getBlockId(name, entry), (Object)b);
        class_1747 i = new class_1747(b, (class_1792.class_1793)this.addItemGroup(entry));
        class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)this.getBlockId(name, entry), (Object)i);
        this.generatedBlocks.add(new GeneratedBlockInstance(name + entry.subname, b, entry));
        this.generatedItems.add(new GeneratedItemInstance(name + entry.subname, (class_1792)i, entry));
    }

    public void register() {
        this.blocks.forEach(entry -> entry.blocks.values().forEach(v -> {
            if (v.itemGroup != null && !this.itemGroups.containsKey(v.itemGroup)) {
                this.itemGroups.put(v.itemGroup, new BlockVariantItem((class_1792.class_1793)new OwoItemSettings().group(GenericBlocks.GENERIC_GROUP).tab(this.tabIndex).maxCount(1)));
            }
            block18: for (String name : entry.names) {
                if (v.itemGroup != null) {
                    this.itemGroups.get(v.itemGroup).addVariant(this.getBlockId(name, (GenericBlockProp)v));
                }
                class_4970.class_2251 settings = this.processSettings((GenericBlockProp)v);
                if (v.multistate > 1 && v.type == BlockType.PILLAR) {
                    this.genericRegisterHelper(name, (GenericBlockProp)v, (class_2248)new GenericPillarMultiState(settings, (GenericBlockProp)v, (GenericBlockProp)v){
                        final /* synthetic */ GenericBlockProp val$v;
                        {
                            this.val$v = genericBlockProp;
                            super(settings, props);
                        }

                        @Override
                        public int getPropCount() {
                            return this.val$v.multistate;
                        }
                    });
                    continue;
                }
                switch (v.type) {
                    case SIMPLE: {
                        this.genericRegisterHelper(name, (GenericBlockProp)v, v.toggleable ? new GenericBlockToggleable(settings, (GenericBlockProp)v) : new GenericBlock(settings, (GenericBlockProp)v));
                        continue block18;
                    }
                    case ALL_SIDE_PANEL: {
                        this.genericRegisterHelper(name, (GenericBlockProp)v, new AllDirectionVine(settings, (GenericBlockProp)v));
                        continue block18;
                    }
                    case PILLAR: {
                        this.genericRegisterHelper(name, (GenericBlockProp)v, (class_2248)(v.toggleable ? new GenericPillarToggleable(settings, (GenericBlockProp)v) : new GenericPillar(settings, (GenericBlockProp)v)));
                        continue block18;
                    }
                    case CONNECTED_PILLAR: {
                        this.genericRegisterHelper(name, (GenericBlockProp)v, (class_2248)new GenericConnectedPillar(settings, (GenericBlockProp)v));
                        continue block18;
                    }
                    case OMNI_BLOCK: {
                        this.genericRegisterHelper(name, (GenericBlockProp)v, v.toggleable ? new OmniBlockToggleable(settings, (GenericBlockProp)v) : new OmniBlock(settings, (GenericBlockProp)v));
                        continue block18;
                    }
                    case ROTATABLE_SLAB: {
                        this.genericRegisterHelper(name, (GenericBlockProp)v, (class_2248)new RotatableSlabBlock(settings));
                        continue block18;
                    }
                    case PANE: {
                        this.genericRegisterHelper(name, (GenericBlockProp)v, (class_2248)new class_2389(settings));
                        continue block18;
                    }
                    case STAIRS: {
                        this.genericRegisterHelper(name, (GenericBlockProp)v, (class_2248)new class_2510(class_2246.field_10340.method_9564(), settings));
                        continue block18;
                    }
                    case LECTERN: {
                        this.genericRegisterHelper(name, (GenericBlockProp)v, new LecternShapedBlock(this.processSettings((GenericBlockProp)v, class_4970.class_2251.method_9637().method_31710(class_2246.field_10161.method_26403()).method_22488().method_50012(class_3619.field_15971))));
                        continue block18;
                    }
                    case FENCE: {
                        this.genericRegisterHelper(name, (GenericBlockProp)v, (class_2248)new class_2354(this.processSettings((GenericBlockProp)v, settings)));
                        continue block18;
                    }
                    case DOOR: {
                        class_2323 b = new DoorLongBlock(this.processSettings((GenericBlockProp)v, class_4970.class_2251.method_9637().method_31710(class_2246.field_10161.method_26403()).method_22488().method_50012(class_3619.field_15971).method_26236(class_2246::method_26122).method_26243(class_2246::method_26122).method_26245(class_2246::method_26122)), class_8177.field_42823);
                        class_2378.method_10230((class_2378)class_7923.field_41175, (class_2960)this.getBlockId(name, (GenericBlockProp)v), (Object)b);
                        class_1765 i = new class_1765((class_2248)b, (class_1792.class_1793)this.addItemGroup((GenericBlockProp)v));
                        class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)this.getBlockId(name, (GenericBlockProp)v), (Object)i);
                        this.generatedBlocks.add(new GeneratedBlockInstance(name, (class_2248)b, (GenericBlockProp)v));
                        this.generatedItems.add(new GeneratedItemInstance(name, (class_1792)i, (GenericBlockProp)v));
                        continue block18;
                    }
                    case DOOR_TWO: {
                        class_2323 b = new DoorDoubleBlock(this.processSettings((GenericBlockProp)v, class_4970.class_2251.method_9637().method_31710(class_2246.field_10161.method_26403()).method_22488().method_50012(class_3619.field_15971).method_26236(class_2246::method_26122).method_26243(class_2246::method_26122).method_26245(class_2246::method_26122)), class_8177.field_42823);
                        class_2378.method_10230((class_2378)class_7923.field_41175, (class_2960)this.getBlockId(name, (GenericBlockProp)v), (Object)b);
                        class_1765 i = new class_1765((class_2248)b, (class_1792.class_1793)this.addItemGroup((GenericBlockProp)v));
                        class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)this.getBlockId(name, (GenericBlockProp)v), (Object)i);
                        this.generatedBlocks.add(new GeneratedBlockInstance(name, (class_2248)b, (GenericBlockProp)v));
                        this.generatedItems.add(new GeneratedItemInstance(name, (class_1792)i, (GenericBlockProp)v));
                        continue block18;
                    }
                    case LANTERN: {
                        this.genericRegisterHelper(name, (GenericBlockProp)v, new LanternGeneric(this.processSettings((GenericBlockProp)v, class_4970.class_2251.method_9637().method_31710(class_3620.field_16005).method_51369().method_9632(3.5f).method_9626(class_2498.field_17734).method_9631(LanternGeneric::produceLight).method_22488().method_50012(class_3619.field_15971))));
                        continue block18;
                    }
                    case BED: {
                        this.genericRegisterHelper(name, (GenericBlockProp)v, (class_2248)new BedGeneric(this.processSettings((GenericBlockProp)v, class_4970.class_2251.method_9637().method_31710(class_3620.field_15979).method_9626(class_2498.field_11547).method_9632(0.2f).method_22488().method_50013().method_50012(class_3619.field_15971))));
                        continue block18;
                    }
                    case TRAPDOOR: {
                        this.genericRegisterHelper(name, (GenericBlockProp)v, (class_2248)new class_2533(this.processSettings((GenericBlockProp)v, class_4970.class_2251.method_9637().method_31710(class_2246.field_10161.method_26403()).method_22488().method_26235(class_2246::method_26114).method_26236(class_2246::method_26122).method_26243(class_2246::method_26122).method_26245(class_2246::method_26122)), class_8177.field_42823){

                            public boolean method_9522(class_2680 state, class_2680 stateFrom, class_2350 direction) {
                                return super.method_9522(state, stateFrom, direction);
                            }
                        });
                        continue block18;
                    }
                    case TABLE: {
                        this.genericRegisterHelper(name, (GenericBlockProp)v, new GenericTable(settings, (GenericBlockProp)v));
                    }
                }
            }
        }));
        this.itemGroups.keySet().forEach(v -> class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)new class_2960("green_resurgence", this.subdomain + "_" + v), (Object)((Object)this.itemGroups.get(v))));
    }

    private class_2960 getBlockId(String base, BlockType type, SubBlock sub) {
        return new class_2960("green_resurgence", this.subdomain + "_" + base + GenericBlockSet.getSuffix(type, sub));
    }

    private class_2960 getBlockId(String base, GenericBlockProp reg) {
        return new class_2960("green_resurgence", this.subdomain + "_" + base + reg.subname);
    }

    private OwoItemSettings addItemGroup(GenericBlockProp prop) {
        if (prop.itemGroup != null) {
            return new OwoItemSettings();
        }
        return new OwoItemSettings().group(GenericBlocks.GENERIC_GROUP).tab(this.tabIndex);
    }

    private class_4970.class_2251 processSettings(GenericBlockProp entry) {
        return this.processSettings(entry, class_4970.class_2251.method_9637());
    }

    private class_4970.class_2251 processSettings(GenericBlockProp entry, class_4970.class_2251 settings) {
        int l;
        settings = settings.method_9626(entry.sound);
        if (entry.transparency != Transparency.OPAQUE) {
            settings = settings.method_22488().method_26236(class_2246::method_26122);
        }
        if (entry.transparency == Transparency.NOTFULL) {
            settings = settings.method_51370().method_22488();
        }
        if ((l = entry.light) > 0) {
            settings = entry.toggleable ? settings.method_9631(st -> st.method_28501().contains(class_2741.field_12537) && (Boolean)st.method_11654((class_2769)class_2741.field_12537) != false ? l : 0) : (entry.multistate > 1 ? settings.method_9631(st -> {
                class_2248 patt9266$temp = st.method_26204();
                if (patt9266$temp instanceof GenericPillarMultiState) {
                    GenericPillarMultiState mb = (GenericPillarMultiState)patt9266$temp;
                    Integer v = (Integer)st.method_11654((class_2769)mb.getToggleProp());
                    if (v <= 1) {
                        return 0;
                    }
                    return (int)((float)v.intValue() / (float)mb.getPropCount() * (float)l);
                }
                return 0;
            }) : settings.method_9631(st -> l));
        }
        return settings;
    }

    public Map<class_2248, Transparency> getGlasses() {
        HashMap<class_2248, Transparency> res = new HashMap<class_2248, Transparency>();
        this.generatedBlocks.forEach(v -> {
            if (v.props.transparency == Transparency.CUTOUT || v.props.transparency == Transparency.TRANSPARENT) {
                res.put(v.block, v.props.transparency);
            }
        });
        return res;
    }

    public void blockDropGenerator(FabricBlockLootTableProvider generator) {
        for (GeneratedBlockInstance b : this.generatedBlocks) {
            if (b.props.noLoot) continue;
            generator.method_46025(b.block);
        }
    }

    public void tagGenerator(Function<class_6862<class_2248>, FabricTagProvider.FabricTagBuilder> factory) {
        for (GeneratedBlockInstance b : this.generatedBlocks) {
            if (b.props.type == BlockType.FENCE) {
                factory.apply((class_6862<class_2248>)class_3481.field_16584).add((Object)b.block);
            }
            if (b.props.type == BlockType.DOOR || b.props.type == BlockType.DOOR_TWO) {
                factory.apply((class_6862<class_2248>)class_3481.field_15495).add((Object)b.block);
                factory.apply((class_6862<class_2248>)class_3481.field_15494).add((Object)b.block);
            }
            if (b.props.type == BlockType.BED) {
                factory.apply((class_6862<class_2248>)class_3481.field_16443).add((Object)b.block);
            }
            if (b.props.type == BlockType.STAIRS) {
                factory.apply((class_6862<class_2248>)class_3481.field_15459).add((Object)b.block);
            }
            if (b.props.subtype == SubBlock.SLAB) {
                factory.apply((class_6862<class_2248>)class_3481.field_15469).add((Object)b.block);
            }
            if (b.props.type == BlockType.TRAPDOOR) {
                factory.apply((class_6862<class_2248>)class_3481.field_15487).add((Object)b.block);
            }
            for (class_6862<class_2248> tag : b.props.tags) {
                factory.apply(tag).add((Object)b.block);
            }
        }
    }

    public void langGenerator(FabricLanguageProvider.TranslationBuilder builder) {
        for (GeneratedBlockInstance b : this.generatedBlocks) {
            builder.add(b.block, LangGenerator.autoLocalizeString(b.name));
        }
        this.itemGroups.forEach((k, v) -> {
            Optional<GeneratedBlockInstance> f = this.generatedBlocks.stream().filter(v1 -> k.equals(v1.props.itemGroup)).findFirst();
            f.ifPresent(generatedBlockInstance -> builder.add("item.green_resurgence." + this.subdomain + "_" + k, "[" + LangGenerator.autoLocalizeString(generatedBlockInstance.props.itemGroup) + "]"));
        });
    }

    public void modelGenerator(class_4915 generator) {
        for (GeneratedItemInstance b : this.generatedItems) {
            if (!b.type.genItem) continue;
            if (b.type.itemModelPath != null) {
                generator.method_25733(b.item, new class_4942(Optional.of(this.helper.transformVariantModelId(b.type.itemModelPath.apply(b.name), b.type.variants)), Optional.empty(), new class_4945[0]));
                continue;
            }
            if (b.type.type == BlockType.PANE) {
                new class_4942(Optional.of(new class_2960("item/generated")), Optional.empty(), new class_4945[]{class_4945.field_23006}).method_25852(class_4941.method_25840((class_1792)b.item), class_4944.method_25895((class_2960)new class_2960("green_resurgence", "block/" + this.subdomain + "/" + b.name.replace("_pane", ""))), generator.field_22844);
                continue;
            }
            if (b.type.type == BlockType.FENCE) {
                new class_4942(Optional.of(new class_2960("block/fence_inventory")), Optional.empty(), new class_4945[]{class_4945.field_23011}).method_25852(class_4941.method_25840((class_1792)b.item), class_4944.method_25869((class_2960)new class_2960("green_resurgence", "block/" + this.subdomain + "/" + b.name.replace("_fence", (CharSequence)(b.type.variants > 0 ? "/" + b.name.replace("_fence", "") + "0" : "")))), generator.field_22844);
                continue;
            }
            if (b.type.type == BlockType.DOOR) {
                generator.method_25733(b.item, new class_4942(Optional.of(this.helper.getBlockModelId(b.name, b.type.modelPath).method_48331("_left")), Optional.empty(), new class_4945[0]));
                continue;
            }
            if (b.type.type == BlockType.DOOR_TWO) {
                generator.method_25733(b.item, new class_4942(Optional.of(this.helper.getBlockModelId(b.name, b.type.modelPath).method_48331("_left_closed")), Optional.empty(), new class_4945[0]));
                continue;
            }
            if (b.type.type == BlockType.TABLE) {
                generator.method_25733(b.item, new class_4942(Optional.of(this.helper.transformVariantModelId(this.helper.getBlockModelId(b.name, b.type.modelPath).method_48331("/full"), b.type.variants)), Optional.empty(), new class_4945[0]));
                continue;
            }
            if (b.type.multistate > 1) {
                generator.method_25733(b.item, new class_4942(Optional.of(this.helper.getBlockModelId(b.name, b.type.modelPath).method_48331("_1")), Optional.empty(), new class_4945[0]));
                continue;
            }
            generator.method_25733(b.item, new class_4942(Optional.of(this.helper.transformVariantModelId(this.helper.getBlockModelId(b.name, b.type.modelPath), b.type.variants)), Optional.empty(), new class_4945[0]));
        }
        this.itemGroups.forEach((k, v) -> {
            Optional<GeneratedBlockInstance> f = this.generatedBlocks.stream().filter(v1 -> k.equals(v1.props.itemGroup)).findFirst();
            f.ifPresent(generatedBlockInstance -> generator.method_25733((class_1792)class_7923.field_41178.method_10223(new class_2960("green_resurgence", this.subdomain + "_" + k)), new class_4942(Optional.of(new class_2960("green_resurgence", "item/" + this.subdomain + "_" + generatedBlockInstance.name)), Optional.empty(), new class_4945[0])));
        });
    }

    public void modelGenerator(class_4910 generator) {
        this.generatedBlocks.forEach(b -> {
            if (b.props.genBlockState) {
                boolean noModel = !b.props.genModel;
                int variants = b.props.variants;
                ModelType model = b.props.model;
                String Tname = b.name;
                if (b.props.subtype == SubBlock.CARPET) {
                    Tname = b.name.replace("_carpet", "");
                } else if (b.props.subtype == SubBlock.SLAB) {
                    Tname = b.name.replace("_slab", "");
                } else if (b.props.subtype == SubBlock.WALL) {
                    Tname = b.name.replace("_wall", "");
                }
                if (b.props.blockstateSupplier != null) {
                    generator.field_22830.accept((class_4917)b.props.blockstateSupplier.apply(b.block, b.name));
                    return;
                }
                switch (b.props.type) {
                    case SIMPLE: {
                        if (b.props.toggleable) {
                            class_4926.class_4927 map = class_4926.method_25783((class_2769)class_2741.field_12537).method_25793((Comparable)Boolean.valueOf(true), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)this.helper.getBlockModelId(b.name, b.props.modelPath).method_48331("_open"))).method_25793((Comparable)Boolean.valueOf(false), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)this.helper.getBlockModelId(b.name, b.props.modelPath)));
                            generator.field_22830.accept(this.helper.createVariantsStates((class_4917)class_4925.method_25769((class_2248)b.block).method_25775((class_4926)map), variants));
                        } else {
                            generator.field_22830.accept(this.helper.createVariantsStates((class_4917)class_4910.method_25644((class_2248)b.block, (class_2960)this.helper.getBlockModelId(b.name, b.props.modelPath)), variants));
                        }
                        if (noModel || b.props.toggleable) {
                            return;
                        }
                        class_4946.class_4947 factory = this.helper.getModeleFactoryFor(model, Tname);
                        this.helper.registerModel(factory, model, b.block, b.name, generator, variants);
                        break;
                    }
                    case PILLAR: {
                        if (b.props.toggleable) {
                            generator.field_22830.accept(this.helper.createVariantsStates((class_4917)class_4925.method_25770((class_2248)b.block, (class_4935)class_4935.method_25824().method_25828(class_4936.field_22887, (Object)this.helper.getBlockModelId(b.name, b.props.modelPath))).method_25775(ModelHelper.fillToggleableVariantMap((class_4926.class_4928<class_2350, Boolean>)class_4926.method_25784((class_2769)class_2741.field_12481, (class_2769)class_2741.field_12537), this.helper.getBlockModelId(b.name, b.props.modelPath), this.helper.getBlockModelId(b.name, b.props.modelPath).method_48331("_open"), false)), variants));
                        } else if (b.props.multistate > 1) {
                            GenericPillarMultiState b1 = (GenericPillarMultiState)b.block;
                            generator.field_22830.accept(this.helper.createVariantsStates((class_4917)class_4925.method_25770((class_2248)b1, (class_4935)class_4935.method_25824().method_25828(class_4936.field_22887, (Object)this.helper.getBlockModelId(b.name, b.props.modelPath))).method_25775(ModelHelper.fillMultistateVariantMap((class_4926.class_4928<class_2350, Integer>)class_4926.method_25784((class_2769)class_2741.field_12481, (class_2769)b1.getToggleProp()), this.helper.getBlockModelId(b.name, b.props.modelPath), b1.getPropCount())), variants));
                        } else {
                            generator.field_22830.accept(class_4925.method_25770((class_2248)b.block, (class_4935)class_4935.method_25824().method_25828(class_4936.field_22887, (Object)this.helper.getBlockModelId(b.name, b.props.modelPath))).method_25775(class_4910.method_25599()));
                        }
                        if (noModel || b.props.toggleable) {
                            return;
                        }
                        class_4946.class_4947 factory = this.helper.getModeleFactoryFor(model, Tname);
                        factory.get(b.block).method_25914().method_25852(this.helper.getBlockModelId(b.name), factory.get(b.block).method_25921(), generator.field_22831);
                        break;
                    }
                    case CONNECTED_PILLAR: {
                        generator.field_22830.accept(this.helper.createVariantsStates((class_4917)class_4925.method_25770((class_2248)b.block, (class_4935)class_4935.method_25824().method_25828(class_4936.field_22887, (Object)this.helper.getBlockModelId(b.name, b.props.modelPath))).method_25775(ModelHelper.fillConnectedBlockVariantMap((class_4926.class_4928<class_2350, SideShelfBlock.Model>)class_4926.method_25784((class_2769)class_2741.field_12481, SideShelfBlock.MODEL), this.helper.getBlockModelId(b.name, b.props.modelPath), this.helper.getBlockModelId(b.name, b.props.modelPath).method_48331("_middle"), this.helper.getBlockModelId(b.name, b.props.modelPath).method_48331("_left"), this.helper.getBlockModelId(b.name, b.props.modelPath).method_48331("_right"))), variants));
                        break;
                    }
                    case OMNI_BLOCK: {
                        if (b.props.toggleable) {
                            generator.field_22830.accept(this.helper.createVariantsStates((class_4917)class_4925.method_25770((class_2248)b.block, (class_4935)class_4935.method_25824().method_25828(class_4936.field_22887, (Object)this.helper.getBlockModelId(b.name, b.props.modelPath))).method_25775(ModelHelper.fillToggleableVariantMap((class_4926.class_4928<class_2350, Boolean>)class_4926.method_25784((class_2769)class_2741.field_12525, (class_2769)class_2741.field_12537), this.helper.getBlockModelId(b.name, b.props.modelPath), this.helper.getBlockModelId(b.name, b.props.modelPath).method_48331("_open"), true)), variants));
                        } else {
                            generator.field_22830.accept(this.helper.createVariantsStates((class_4917)class_4925.method_25770((class_2248)b.block, (class_4935)class_4935.method_25824().method_25828(class_4936.field_22887, (Object)this.helper.getBlockModelId(b.name, b.props.modelPath))).method_25775(class_4910.method_25640()), variants));
                        }
                        if (noModel || b.props.toggleable) {
                            return;
                        }
                        class_4946.class_4947 factory = this.helper.getModeleFactoryFor(model, Tname);
                        this.helper.registerModel(factory, model, b.block, b.name, generator, variants);
                        break;
                    }
                    case ALL_SIDE_PANEL: {
                        HashMap<String, String> m = new HashMap<String, String>();
                        m.put("id", b.name);
                        m.put("sub", this.subdomain);
                        generator.field_22830.accept(this.helper.createVariantsStates(this.helper.alterSchematic(b.block, "all_side_panel", m), variants));
                        if (noModel) {
                            return;
                        }
                        class_4946.class_4947 factory = this.helper.getModeleFactoryFor(model, Tname);
                        this.helper.registerModel(factory, model, b.block, b.name, generator, variants);
                        break;
                    }
                    case TABLE: {
                        generator.field_22830.accept(this.helper.alterSchematic(b.block, b.props.model == ModelType.TABLE_DECORLESS ? "table_decorless" : "table", "id", b.name));
                        break;
                    }
                    case PANE: {
                        this.helper.registerGlassPane(generator, b.name.replace("_pane", ""), b.block, false);
                        break;
                    }
                    case DOOR: {
                        this.helper.registerDoor(generator, b.name, b.block);
                        break;
                    }
                    case DOOR_TWO: {
                        HashMap<String, String> m = new HashMap<String, String>();
                        m.put("id", b.name);
                        m.put("sub", this.subdomain);
                        generator.field_22830.accept(this.helper.createVariantsStates(this.helper.alterSchematic(b.block, "door_double", m), variants));
                        if (noModel) {
                            return;
                        }
                        class_4946.class_4947 factory = this.helper.getModeleFactoryFor(model, Tname);
                        this.helper.registerModel(factory, model, b.block, b.name, generator, variants);
                        break;
                    }
                    case LANTERN: {
                        this.helper.registerLantern(generator, b.name, b.block);
                        break;
                    }
                    case FENCE: {
                        this.helper.registerFence(generator, b.name, b.block, variants, model == ModelType.WALL);
                        break;
                    }
                    case STAIRS: {
                        generator.field_22830.accept(this.helper.createVariantsStates(class_4910.method_25646((class_2248)b.block, (class_2960)this.helper.getBlockModelId(b.name, b.props.modelPath).method_48331("_inner"), (class_2960)this.helper.getBlockModelId(b.name, b.props.modelPath), (class_2960)this.helper.getBlockModelId(b.name, b.props.modelPath).method_48331("_outer")), variants));
                        if (noModel) {
                            return;
                        }
                        class_4946.class_4947[] facts = this.helper.getModelForStairs(b.name.replace("_stair", ""), model);
                        this.helper.registerModel(facts[0], b.block, b.name, generator, variants, class_4945.field_23014, class_4945.field_23015, class_4945.field_23018);
                        this.helper.registerModel(facts[1], b.block, b.name + "_inner", generator, variants, class_4945.field_23014, class_4945.field_23015, class_4945.field_23018);
                        this.helper.registerModel(facts[2], b.block, b.name + "_outer", generator, variants, class_4945.field_23014, class_4945.field_23015, class_4945.field_23018);
                        break;
                    }
                    case BED: {
                        this.helper.registerBed(generator, b.name, b.block);
                        break;
                    }
                    case TRAPDOOR: {
                        if (noModel) {
                            return;
                        }
                        this.helper.registerTrapdoor(generator, b.name, b.block);
                    }
                }
            }
        });
    }

    private static String getSuffix(BlockType type, SubBlock sub) {
        switch (type) {
            case FENCE: {
                return "_fence";
            }
            case STAIRS: {
                return "_stair";
            }
            case PANE: {
                return "_pane";
            }
        }
        switch (sub) {
            case NONE: {
                return "";
            }
            case PANE: {
                return "_pane";
            }
            case SLAB: {
                return "_slab";
            }
            case CARPET: {
                return "_carpet";
            }
            case WALL: {
                return "_wall";
            }
        }
        return "";
    }

    public record GeneratedBlockInstance(String name, class_2248 block, GenericBlockProp props) {
    }

    protected static class GenericBlockRegisterInstance {
        private final String[] names;
        private final Map<String, GenericBlockProp> blocks = new HashMap<String, GenericBlockProp>();

        private GenericBlockRegisterInstance(String ... names) {
            this.names = names;
        }

        private static HitBox DefaultHitbox(SubBlock sub) {
            switch (sub) {
                case SLAB: {
                    return HitBox.SLAB;
                }
                case CARPET: {
                    return HitBox.CARPET;
                }
            }
            return HitBox.FULL;
        }

        public GenericBlockRegisterInstance addSub(BlockType type, ModelType model, HitBox hitbox, SubBlock sub) {
            GenericBlockProp prop = new GenericBlockProp();
            prop.type = type;
            prop.solid = true;
            prop.sound = class_2498.field_11533;
            prop.model = model;
            prop.hitbox = hitbox;
            prop.subtype = sub;
            prop.subname = GenericBlockSet.getSuffix(type, sub);
            prop.genModel = true;
            prop.genBlockState = true;
            prop.genItem = true;
            prop.transparency = Transparency.UNDEFINED;
            prop.noLoot = false;
            prop.modelPath = "";
            this.blocks.put(GenericBlockSet.getSuffix(type, sub), prop);
            return this;
        }

        public GenericBlockRegisterInstance addSub(BlockType type, ModelType model, HitBox hitbox) {
            return this.addSub(type, model, hitbox, SubBlock.NONE);
        }

        public GenericBlockRegisterInstance addSub(BlockType type, ModelType model) {
            return this.addSub(type, model, HitBox.FULL, SubBlock.NONE);
        }

        public GenericBlockRegisterInstance addSub(BlockType type, ModelType model, SubBlock sub) {
            return this.addSub(type, model, GenericBlockRegisterInstance.DefaultHitbox(sub), sub);
        }

        public GenericBlockRegisterInstance addSub(BlockType type) {
            return this.addSub(type, type == BlockType.PILLAR ? ModelType.PILLAR : ModelType.SIMPLE, HitBox.FULL, SubBlock.NONE);
        }

        public GenericBlockRegisterInstance addModelPath(String path) {
            this.blocks.values().forEach(v -> {
                v.modelPath = path;
            });
            return this;
        }

        public GenericBlockRegisterInstance addTags(class_6862<class_2248> ... tags) {
            this.blocks.values().forEach(v -> Collections.addAll(v.tags, tags));
            return this;
        }

        public GenericBlockRegisterInstance addGroup(String id) {
            this.blocks.values().forEach(v -> {
                v.itemGroup = id;
            });
            return this;
        }

        public GenericBlockRegisterInstance setTransparency(Transparency trans) {
            this.blocks.values().forEach(v -> {
                v.transparency = trans;
            });
            return this;
        }

        public GenericBlockRegisterInstance setDamage(float damage) {
            this.blocks.values().forEach(v -> {
                v.damage = damage;
            });
            return this;
        }

        public GenericBlockRegisterInstance variant(int variants) {
            this.blocks.values().forEach(v -> {
                v.variants = variants;
            });
            return this;
        }

        public GenericBlockRegisterInstance light(int value) {
            this.blocks.values().forEach(v -> {
                v.light = value;
            });
            return this;
        }

        public GenericBlockRegisterInstance sound(class_2498 sound) {
            this.blocks.values().forEach(v -> {
                v.sound = sound;
            });
            return this;
        }

        public GenericBlockRegisterInstance notSolid() {
            this.blocks.values().forEach(v -> {
                v.solid = false;
            });
            return this;
        }

        public GenericBlockRegisterInstance notSolid(SubBlock sub) {
            this.blocks.values().forEach(v -> {
                if (v.subtype == sub) {
                    v.solid = false;
                }
            });
            return this;
        }

        public GenericBlockRegisterInstance noLoot() {
            this.blocks.values().forEach(v -> {
                v.noLoot = true;
            });
            return this;
        }

        public GenericBlockRegisterInstance noLoot(SubBlock sub) {
            this.blocks.values().forEach(v -> {
                if (v.subtype == sub) {
                    v.noLoot = true;
                }
            });
            return this;
        }

        public GenericBlockRegisterInstance seat(float level) {
            this.blocks.values().forEach(v -> {
                v.seatLevel = level;
                v.isSeat = true;
            });
            return this;
        }

        public GenericBlockRegisterInstance disableGen(boolean genBlockStateAndItem, SubBlock subtype) {
            this.blocks.values().forEach(v -> {
                if (v.subtype == subtype) {
                    v.genModel = false;
                    v.genBlockState = genBlockStateAndItem;
                    v.genItem = genBlockStateAndItem;
                }
            });
            return this;
        }

        public GenericBlockRegisterInstance disableGen(boolean genBlockStateAndItem) {
            this.blocks.values().forEach(v -> {
                v.genModel = false;
                v.genBlockState = genBlockStateAndItem;
                v.genItem = genBlockStateAndItem;
            });
            return this;
        }

        public GenericBlockRegisterInstance disableGen(boolean genBlockState, boolean genItem) {
            this.blocks.values().forEach(v -> {
                v.genModel = false;
                v.genBlockState = genBlockState;
                v.genItem = genItem;
            });
            return this;
        }

        public GenericBlockRegisterInstance customItemModelPath(Function<String, class_2960> factory) {
            this.blocks.values().forEach(v -> {
                v.itemModelPath = factory;
            });
            return this;
        }

        public GenericBlockRegisterInstance schematicBlockStateSupplier(BiFunction<class_2248, String, SchematicBlockStateSupplier> factory) {
            this.blocks.values().forEach(v -> {
                v.blockstateSupplier = factory;
            });
            return this;
        }

        public GenericBlockRegisterInstance togglable() {
            this.blocks.values().forEach(v -> {
                v.toggleable = true;
            });
            return this;
        }

        public GenericBlockRegisterInstance multistate(int max) {
            this.blocks.values().forEach(v -> {
                v.multistate = max;
            });
            return this;
        }
    }

    public static enum BlockType {
        SIMPLE,
        PILLAR,
        CONNECTED_PILLAR,
        STAIRS,
        PANE,
        LECTERN,
        DOOR,
        FENCE,
        ROTATABLE_SLAB,
        WALL,
        OMNI_BLOCK,
        LANTERN,
        BED,
        TRAPDOOR,
        TABLE,
        ALL_SIDE_PANEL,
        DOOR_TWO;

    }

    public static enum Transparency {
        TRANSPARENT,
        CUTOUT,
        OPAQUE,
        NOTFULL,
        UNDEFINED;

    }

    public static class GenericBlockProp {
        public boolean genItem;
        protected int multistate;
        protected Function<String, class_2960> itemModelPath;
        protected BiFunction<class_2248, String, SchematicBlockStateSupplier> blockstateSupplier;
        protected boolean solid;
        protected boolean noLoot;
        protected class_2498 sound;
        protected SubBlock subtype;
        protected Transparency transparency;
        protected String subname;
        protected String modelPath;
        protected ModelType model;
        protected BlockType type;
        protected int light;
        protected HitBox hitbox;
        protected boolean genModel;
        protected boolean genBlockState;
        protected boolean toggleable;
        protected float damage;
        protected float seatLevel;
        protected boolean isSeat;
        protected String itemGroup;
        protected int variants;
        protected List<class_6862<class_2248>> tags = new ArrayList<class_6862<class_2248>>();
    }

    private record GeneratedItemInstance(String name, class_1792 item, GenericBlockProp type) {
    }

    public static enum SubBlock {
        NONE,
        PANE,
        SLAB,
        CARPET,
        WALL;

    }

    public static enum ModelType {
        SIMPLE,
        PILLAR,
        SLAB,
        SLAB_3TEX,
        INVERSED_PILLAR,
        COMPOSTER,
        MACHINE,
        BOTOMLESS_MACHINE,
        TWO_TEXTURED_MACHINE,
        WALL,
        LADDER,
        CARPET,
        TABLE_DECORLESS;

    }

    public static enum HitBox {
        FULL(class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)),
        SLAB(class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0)),
        FIXED_SLAB(class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), false),
        FIXED_SLAB_TOP(class_2248.method_9541((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), false),
        TABLE(class_2248.method_9541((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), false),
        CARPET(class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0)),
        SMALL_SIDE_CARPET(class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)2.0), true, true),
        CORNER(class_2248.method_9541((double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)8.0, (double)16.0), true, true),
        CORNER_UP(class_2248.method_9541((double)0.0, (double)8.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0), true, true),
        LARGE_CARPET(class_2248.method_9541((double)0.0, (double)0.0, (double)-16.0, (double)32.0, (double)1.0, (double)32.0)),
        CARPET_FIXED(class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0), false),
        CENTER(class_2248.method_9541((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0), false),
        SMALL_BOTTOM(class_2248.method_9541((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)8.0, (double)10.0), false),
        MEDIUM(class_2248.method_9541((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)13.0, (double)13.0), false),
        SMALL_TOP(class_2248.method_9541((double)6.0, (double)8.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0), false),
        STAIR(class_259.method_1084((class_265)class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), (class_265)class_2248.method_9541((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0)), true, true),
        SMALL_WALL(class_2248.method_9541((double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)10.0, (double)10.0), true, true),
        WALL(class_2248.method_9541((double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)14.0, (double)10.0), true, true),
        SMALL_WALL_NEGATIVE(class_2248.method_9541((double)0.0, (double)-6.0, (double)6.0, (double)16.0, (double)10.0, (double)10.0), true, true);

        public final class_265 shape;
        public final boolean needRotate;
        public final boolean horizontal;

        private HitBox(class_265 shape) {
            this.shape = shape;
            this.needRotate = true;
            this.horizontal = false;
        }

        private HitBox(class_265 shape, boolean needRotate) {
            this.shape = shape;
            this.needRotate = needRotate;
            this.horizontal = false;
        }

        private HitBox(class_265 shape, boolean needRotate, boolean horizontal) {
            this.shape = shape;
            this.needRotate = needRotate;
            this.horizontal = horizontal;
        }
    }
}

