/*
 * Decompiled with CFR 0.152.
 */
package com.diamssword.greenresurgence.gui.components;

import com.diamssword.greenresurgence.GreenResurgence;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;
import net.minecraft.class_332;

@Environment(value=EnvType.CLIENT)
public class ScrollPart {
    public static final class_2960 SCROLLER_TEXTURE = GreenResurgence.asRessource("textures/gui/scroller.png");
    public int width;
    public int height;
    public int x;
    public int y;
    public int scroll = 0;
    public int lines;
    private Consumer<Integer> callback;

    public ScrollPart(int x, int y, int width, int height, int lines) {
        this.width = width;
        this.height = height;
        this.x = x;
        this.y = y;
        this.lines = lines;
    }

    public boolean isOver(double mouseX, double mouseY) {
        return mouseX >= (double)this.x && mouseX < (double)(this.x + this.width) && mouseY >= (double)this.y && mouseY <= (double)(this.y + this.height);
    }

    public void onScroll(Consumer<Integer> consumer) {
        this.callback = consumer;
    }

    public boolean mouseDrag(double mouseY) {
        double m = mouseY - (double)this.y;
        if (m > 0.0 && mouseY <= (double)(this.y + this.height)) {
            float perc = Math.min(Math.max((float)m / (float)this.height, 0.0f), 1.0f);
            this.scroll = (int)(perc * ((float)this.lines + 1.0f));
            this.onScroll();
            return true;
        }
        return false;
    }

    private void onScroll() {
        if (this.callback != null) {
            this.callback.accept(this.scroll);
        }
    }

    public void draw(class_332 ctx) {
        ctx.method_25293(SCROLLER_TEXTURE, this.x, this.y, this.width, 5, 32.0f, 0.0f, 32, 10, 64, 64);
        ctx.method_25293(SCROLLER_TEXTURE, this.x, this.y + this.height - 5, this.width, 5, 32.0f, 54.0f, 32, 10, 64, 64);
        ctx.method_25293(SCROLLER_TEXTURE, this.x, this.y + 5, this.width, this.height - 10, 32.0f, 10.0f, 32, 44, 64, 64);
        ctx.method_25293(SCROLLER_TEXTURE, this.x, (int)((float)this.y + (float)(this.height - this.width * 2) * this.scrollPercent()), this.width, this.width * 2, 0.0f, 0.0f, 32, 64, 64, 64);
    }

    public float scrollPercent() {
        return (float)this.scroll / Math.max((float)this.lines, 1.0f);
    }

    public void scroll(int value) {
        if (value < 0 && this.scrollPercent() < 1.0f) {
            ++this.scroll;
            this.onScroll();
        } else if (value > 0) {
            this.scroll = Math.max(0, this.scroll - 1);
            this.onScroll();
        }
    }
}

