/*
 * Decompiled with CFR 0.152.
 */
package com.diamssword.greenresurgence.gui.components.hud;

import com.diamssword.greenresurgence.gui.components.hud.IHideableComponent;
import com.mojang.blaze3d.systems.RenderSystem;
import io.wispforest.owo.ui.component.TextureComponent;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.OwoUIDrawContext;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.parsing.UIParsing;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Environment(value=EnvType.CLIENT)
public class BarComponent
extends TextureComponent
implements IHideableComponent {
    private float fillPercent = 1.0f;
    private boolean hidden;
    public boolean reversedIndex = false;

    public BarComponent(class_2960 texture, int u, int v, int regionWidth, int regionHeight, int textureWidth, int textureHeight, boolean reversed) {
        super(texture, u, v, regionWidth, regionHeight, textureWidth, textureHeight);
        this.reversedIndex = reversed;
    }

    public void update(float delta, int mouseX, int mouseY) {
        super.update(delta, mouseX, mouseY);
    }

    protected int determineHorizontalContentSize(Sizing sizing) {
        Sizing v = (Sizing)this.verticalSizing.get();
        if (v != null && !v.isContent() && this.height > 0) {
            return (int)((float)this.height * ((float)this.regionWidth / (float)this.regionHeight));
        }
        return this.regionWidth;
    }

    protected int determineVerticalContentSize(Sizing sizing) {
        Sizing v = (Sizing)this.horizontalSizing.get();
        if (v != null && !v.isContent() && this.width > 0) {
            return (int)((float)this.width * ((float)this.regionHeight / (float)this.regionWidth));
        }
        return this.regionHeight;
    }

    protected void applySizing() {
        Sizing horizontalSizing = (Sizing)this.horizontalSizing.get();
        Sizing verticalSizing = (Sizing)this.verticalSizing.get();
        Insets margins = (Insets)this.margins.get();
        if (verticalSizing.isContent()) {
            this.width = horizontalSizing.inflate(this.space.width() - margins.horizontal(), this::determineHorizontalContentSize);
            this.height = verticalSizing.inflate(this.space.height() - margins.vertical(), this::determineVerticalContentSize);
        } else {
            this.height = verticalSizing.inflate(this.space.height() - margins.vertical(), this::determineVerticalContentSize);
            this.width = horizontalSizing.inflate(this.space.width() - margins.horizontal(), this::determineHorizontalContentSize);
        }
    }

    public void draw(OwoUIDrawContext context, int mouseX, int mouseY, float partialTicks, float delta) {
        RenderSystem.enableDepthTest();
        if (this.hidden) {
            return;
        }
        if (this.blend) {
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
        }
        class_4587 matrices = context.method_51448();
        matrices.method_22903();
        matrices.method_46416((float)this.x, (float)this.y, 0.0f);
        float invScaleX = 100.0f;
        int w = (int)((float)this.width * invScaleX);
        int h = (int)((float)this.height * invScaleX);
        matrices.method_22905(0.01f, 0.01f, 0.0f);
        int barWidth = Math.round((float)w * this.fillPercent);
        int texBarWidth = Math.round((float)this.textureWidth * this.fillPercent);
        if (!this.reversedIndex) {
            context.method_25293(this.texture, 0, 0, w, h, (float)this.u, (float)this.v, this.regionWidth, this.regionHeight, this.textureWidth, this.textureHeight);
        }
        context.method_25293(this.texture, 0, 0, barWidth, h, (float)this.u, (float)(this.v + this.regionHeight), texBarWidth, this.regionHeight, this.textureWidth, this.textureHeight);
        if (this.reversedIndex) {
            context.method_25293(this.texture, 0, 0, w, h, (float)this.u, (float)this.v, this.regionWidth, this.regionHeight, this.textureWidth, this.textureHeight);
        }
        if (this.blend) {
            RenderSystem.disableBlend();
        }
        matrices.method_22909();
    }

    public float getFillPercent() {
        return this.fillPercent;
    }

    public void setFillPercent(float fillPercent) {
        this.fillPercent = fillPercent;
    }

    public static BarComponent parse(Element element) {
        UIParsing.expectAttributes((Element)element, (String[])new String[]{"texture"});
        class_2960 textureId = UIParsing.parseIdentifier((Node)element.getAttributeNode("texture"));
        boolean reversed = false;
        int u = 0;
        int v = 0;
        int regionWidth = 0;
        int regionHeight = 0;
        int textureWidth = 256;
        int textureHeight = 256;
        if (element.hasAttribute("u")) {
            u = UIParsing.parseSignedInt((Node)element.getAttributeNode("u"));
        }
        if (element.hasAttribute("v")) {
            v = UIParsing.parseSignedInt((Node)element.getAttributeNode("v"));
        }
        if (element.hasAttribute("reversed")) {
            reversed = UIParsing.parseBool((Node)element.getAttributeNode("reversed"));
        }
        if (element.hasAttribute("region-width")) {
            regionWidth = UIParsing.parseSignedInt((Node)element.getAttributeNode("region-width"));
        }
        if (element.hasAttribute("region-height")) {
            regionHeight = UIParsing.parseSignedInt((Node)element.getAttributeNode("region-height"));
        }
        if (element.hasAttribute("texture-width")) {
            textureWidth = UIParsing.parseSignedInt((Node)element.getAttributeNode("texture-width"));
        }
        if (element.hasAttribute("texture-height")) {
            textureHeight = UIParsing.parseSignedInt((Node)element.getAttributeNode("texture-height"));
        }
        return new BarComponent(new class_2960(textureId.method_12836(), "textures/gui/" + textureId.method_12832()), u, v, regionWidth, regionHeight, textureWidth, textureHeight, reversed);
    }

    @Override
    public void hidden(boolean hidden) {
        this.hidden = hidden;
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }
}

