/*
 * Decompiled with CFR 0.152.
 */
package com.diamssword.greenresurgence.gui.components.hud;

import com.diamssword.greenresurgence.DrawUtils;
import com.diamssword.greenresurgence.gui.components.hud.IHideableComponent;
import com.mojang.blaze3d.systems.RenderSystem;
import io.wispforest.owo.ui.base.BaseComponent;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.OwoUIDrawContext;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.parsing.UIModel;
import io.wispforest.owo.ui.parsing.UIParsing;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Environment(value=EnvType.CLIENT)
public class HotBarComponent
extends BaseComponent
implements IHideableComponent {
    private final int textureSize = 46;
    private int selected = 1;
    private int size = 5;
    private int hideTimer = 200;
    private class_2371<class_1799> stacks = class_2371.method_10213((int)this.size, (Object)class_1799.field_8037);
    protected boolean blend = false;
    protected final class_2960 texture;
    private boolean hidden;

    protected HotBarComponent(class_2960 texture) {
        this.texture = texture;
    }

    public HotBarComponent blend(boolean blend) {
        this.blend = blend;
        return this;
    }

    protected void applySizing() {
        Sizing horizontalSizing = (Sizing)this.horizontalSizing.get();
        Sizing verticalSizing = (Sizing)this.verticalSizing.get();
        Insets margins = (Insets)this.margins.get();
        this.height = verticalSizing.inflate(this.space.height() - margins.vertical(), this::determineVerticalContentSize);
        this.width = horizontalSizing.inflate(this.space.width() - margins.horizontal(), this::determineHorizontalContentSize);
    }

    public boolean blend() {
        return this.blend;
    }

    public void update(float delta, int mouseX, int mouseY) {
        super.update(delta, mouseX, mouseY);
    }

    protected int determineHorizontalContentSize(Sizing sizing) {
        return 20 * this.size + 4;
    }

    @Override
    public void hidden(boolean hidden) {
        this.hidden = hidden;
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    protected int determineVerticalContentSize(Sizing sizing) {
        return 24;
    }

    public void draw(OwoUIDrawContext context, int mouseX, int mouseY, float partialTicks, float delta) {
        int i;
        if (this.hidden || this.hideTimer == 0) {
            return;
        }
        RenderSystem.enableDepthTest();
        if (this.blend) {
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)((float)this.hideTimer / 100.0f));
            RenderSystem.enableDepthTest();
        }
        class_4587 matrices = context.method_51448();
        matrices.method_22903();
        matrices.method_46416((float)this.x, (float)this.y, 0.0f);
        class_310 mc = class_310.method_1551();
        context.method_25293(this.texture, 1, 1, 1, 22, 0.0f, 0.0f, 1, 22, 46, 46);
        for (i = 0; i < this.size; ++i) {
            context.method_25293(this.texture, 2 + 20 * i, 1, 20, 22, 1.0f, 0.0f, 20, 22, 46, 46);
        }
        context.method_25293(this.texture, 2 + 20 * this.size, 1, 1, 22, 21.0f, 0.0f, 1, 22, 46, 46);
        context.method_25293(this.texture, 20 * this.selected, 0, 24, 24, 22.0f, 0.0f, 24, 24, 46, 46);
        matrices.method_22909();
        matrices.method_22903();
        matrices.method_46416((float)this.x, (float)this.y, 0.0f);
        for (i = 0; i < this.size; ++i) {
            int n = i * 20 + 4;
            int o = 4;
            DrawUtils.renderHotbarItem(mc, context, n, o, delta, (class_1657)mc.field_1724, (class_1799)this.stacks.get(i), i);
        }
        matrices.method_22909();
        if (this.blend) {
            RenderSystem.disableBlend();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    public List<class_1799> getStacks() {
        return this.stacks;
    }

    public void setStacks(class_2371<class_1799> stacks) {
        if (!stacks.equals(this.stacks)) {
            this.hideTimer = 110;
        }
        this.stacks = stacks;
        if (this.size != stacks.size()) {
            this.size = stacks.size();
            this.dirty = true;
            this.applySizing();
        } else {
            this.size = stacks.size();
        }
        this.hideTimer = class_310.method_1551().field_1724.method_7337() ? 200 : Math.max(this.hideTimer - 1, 0);
    }

    public float getSelected() {
        return this.selected;
    }

    public float getSize() {
        return this.size;
    }

    public void setSelected(int selected) {
        int s = Math.min(selected, this.size - 1);
        if (this.selected != s) {
            this.hideTimer = 110;
        }
        this.selected = s;
    }

    public void setSize(int size) {
        this.size = size;
        this.stacks = class_2371.method_10213((int)size, (Object)class_1799.field_8037);
    }

    public void parseProperties(UIModel model, Element element, Map<String, Element> children) {
        super.parseProperties(model, element, children);
        UIParsing.apply(children, (String)"blend", UIParsing::parseBool, this::blend);
        UIParsing.apply(children, (String)"size", UIParsing::parseSignedInt, this::setSize);
    }

    public static HotBarComponent parse(Element element) {
        UIParsing.expectAttributes((Element)element, (String[])new String[]{"texture"});
        class_2960 textureId = UIParsing.parseIdentifier((Node)element.getAttributeNode("texture"));
        return new HotBarComponent(new class_2960(textureId.method_12836(), "textures/gui/" + textureId.method_12832()));
    }
}

