/*
 * Decompiled with CFR 0.152.
 */
package com.diamssword.greenresurgence.gui.playerContainers;

import com.diamssword.greenresurgence.containers.IGridContainer;
import com.diamssword.greenresurgence.gui.MultiInvHandledScreen;
import com.diamssword.greenresurgence.gui.RessourceGuiHelper;
import com.diamssword.greenresurgence.gui.components.InventoryComponent;
import com.diamssword.greenresurgence.gui.components.InventorySearchableComponent;
import com.diamssword.greenresurgence.gui.playerContainers.PlayerBasedGui;
import com.diamssword.greenresurgence.systems.crafting.UniversalResource;
import com.diamssword.greenresurgence.systems.faction.perimeter.components.FactionTerrainStorage;
import com.mojang.datafixers.util.Pair;
import io.wispforest.owo.ui.base.BaseParentComponent;
import io.wispforest.owo.ui.container.FlowLayout;
import java.util.List;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1058;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class FactionStorageScreen
extends PlayerBasedGui<FactionTerrainStorage.ScreenHandler> {
    private static InventorySearchableComponent storage;

    public FactionStorageScreen(FactionTerrainStorage.ScreenHandler handler, class_1661 inv, class_2561 title) {
        super(handler, "survival/faction_global_storage");
    }

    @Override
    protected void findInvComps(BaseParentComponent root) {
        root.children().forEach(c -> {
            if (c instanceof InventoryComponent) {
                InventoryComponent par = (InventoryComponent)c;
                this.invsComps.put(par.inventoryId, par);
                IGridContainer inv = ((FactionTerrainStorage.ScreenHandler)this.handler).getInventory(par.inventoryId);
                if (inv != null) {
                    par.setSize(inv.getWidth(), inv.getHeight());
                } else {
                    par.hidden(true);
                }
            } else if (c instanceof InventorySearchableComponent) {
                InventorySearchableComponent par;
                storage = par = (InventorySearchableComponent)((Object)c);
                IGridContainer inv = ((FactionTerrainStorage.ScreenHandler)this.handler).getInventory(par.inventoryId);
                if (inv != null) {
                    par.setSize(6, 6);
                    par.setInventory(((FactionTerrainStorage.ScreenHandler)this.handler).getSlotForInventory(par.inventoryId));
                    ((FactionTerrainStorage.ScreenHandler)this.handler).onSlotAdded(() -> par.setInventory(((FactionTerrainStorage.ScreenHandler)this.handler).getSlotForInventory(par.inventoryId)));
                }
            } else if (c instanceof BaseParentComponent) {
                BaseParentComponent c1 = (BaseParentComponent)c;
                this.findInvComps(c1);
            }
        });
    }

    protected void drawSlotList(List<class_1735> slots, String id, class_332 context, int mouseX, int mouseY) {
        for (class_1735 slot : slots) {
            if (slot.method_7682()) {
                this.drawSlot(context, slot, id);
            }
            if (!this.isPointOverSlot(slot, mouseX, mouseY) || !slot.method_7682()) continue;
            this.focusedSlot = slot;
            Pair<Integer, Integer> pos = this.getSlotPosition(slot, id);
            if (!this.focusedSlot.method_51306()) continue;
            MultiInvHandledScreen.drawSlotHighlight(context, (Integer)pos.getFirst(), (Integer)pos.getSecond(), 0);
        }
    }

    @Override
    protected void drawSlots(class_332 context, int mouseX, int mouseY, float delta) {
        for (String id : this.invsComps.keySet()) {
            this.drawSlotList(((FactionTerrainStorage.ScreenHandler)this.handler).getSlotForInventory(id), id, context, mouseX, mouseY);
        }
        this.drawSlotList(storage.getDisplayedSlots(), "storage", context, mouseX, mouseY);
    }

    @Override
    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
    }

    @Override
    protected boolean isClickOutsideBounds(double mouseX, double mouseY, int left, int top, int button) {
        if (storage != null && storage.isInBoundingBox(mouseX, mouseY)) {
            return false;
        }
        return super.isClickOutsideBounds(mouseX, mouseY, left, top, button);
    }

    @Override
    protected class_1735 getSlotAt(double x, double y) {
        if (storage != null) {
            for (class_1735 slot : storage.getDisplayedSlots()) {
                if (!this.isPointOverSlot(slot, x, y)) continue;
                return slot;
            }
        }
        for (int i = 0; i < ((FactionTerrainStorage.ScreenHandler)this.handler).field_7761.size(); ++i) {
            class_1735 slot;
            slot = (class_1735)((FactionTerrainStorage.ScreenHandler)this.handler).field_7761.get(i);
            if (!this.isPointOverSlot(slot, x, y) || !slot.method_7682()) continue;
            return slot;
        }
        return null;
    }

    @Override
    protected void onMouseClick(class_1735 slot, int slotId, int button, class_1713 actionType) {
        if (slot != null) {
            slotId = slot.field_7874;
        }
        if (slot instanceof InventorySearchableComponent.FalseSlot) {
            if (((FactionTerrainStorage.ScreenHandler)this.handler).method_34255().method_7960()) {
                return;
            }
            slotId = ((FactionTerrainStorage.ScreenHandler)this.handler).getSlotForInventory((String)"storage").get((int)0).field_7874;
        }
        this.field_22787.field_1761.method_2906(((FactionTerrainStorage.ScreenHandler)this.handler).field_7763, slotId, button, actionType, (class_1657)this.field_22787.field_1724);
    }

    @Override
    protected boolean isPointOverSlot(class_1735 slot, double pointX, double pointY) {
        String id = ((FactionTerrainStorage.ScreenHandler)this.handler).getInventoryForSlot(slot);
        if (id == null) {
            id = "storage";
        }
        Pair<Integer, Integer> pos = this.getSlotPosition(slot, id);
        return this.isPointWithinBounds((Integer)pos.getFirst(), (Integer)pos.getSecond(), 16, 16, pointX, pointY);
    }

    @Override
    public Pair<Integer, Integer> getSlotPosition(class_1735 s, String inventory) {
        if ("storage".equals(inventory) && storage != null) {
            List<class_1735> slots = storage.getDisplayedSlots();
            int i = slots.indexOf(s);
            if (i >= 0) {
                return new Pair((Object)(i % (Integer)storage.getSlotsSize().method_15442() * 18 + storage.x() - this.x), (Object)(i / (Integer)storage.getSlotsSize().method_15442() * 18 + storage.y() - this.y + 20));
            }
            return new Pair((Object)0, (Object)0);
        }
        return super.getSlotPosition(s, inventory);
    }

    @Override
    protected void build(FlowLayout rootComponent) {
        super.build(rootComponent);
    }

    @Override
    protected void drawBackground(class_332 ctx, float delta, int mouseY, int mouseX) {
    }

    @Override
    protected void drawSlot(class_332 context, class_1735 slot, String inventory) {
        Pair pair;
        Pair<Integer, Integer> pos = this.getSlotPosition(slot, inventory);
        class_1799 itemStack = slot.method_7677();
        boolean bl = false;
        boolean bl2 = slot == this.touchDragSlotStart && !this.touchDragStack.method_7960() && !this.touchIsRightClickDrag;
        class_1799 itemStack2 = ((FactionTerrainStorage.ScreenHandler)this.handler).method_34255();
        String string = null;
        if (slot == this.touchDragSlotStart && !this.touchDragStack.method_7960() && this.touchIsRightClickDrag && !itemStack.method_7960()) {
            itemStack = itemStack.method_46651(itemStack.method_7947() / 2);
        } else if (this.cursorDragging && this.cursorDragSlots.contains(slot) && !itemStack2.method_7960()) {
            if (this.cursorDragSlots.size() == 1) {
                return;
            }
            if (class_1703.method_7592((class_1735)slot, (class_1799)itemStack2, (boolean)true) && ((FactionTerrainStorage.ScreenHandler)this.handler).method_7615(slot)) {
                bl = true;
                int k = Math.min(itemStack2.method_7914(), slot.method_7676(itemStack2));
                int l = slot.method_7677().method_7960() ? 0 : slot.method_7677().method_7947();
                int m = class_1703.method_7617((Set)this.cursorDragSlots, (int)this.heldButtonType, (class_1799)itemStack2) + l;
                if (m > k) {
                    m = k;
                    string = class_124.field_1054.toString() + k;
                }
                itemStack = itemStack2.method_46651(m);
            } else {
                this.cursorDragSlots.remove(slot);
                this.calculateOffset();
            }
        }
        context.method_51448().method_22903();
        context.method_51448().method_46416(0.0f, 0.0f, 100.0f);
        if (itemStack.method_7960() && slot.method_7682() && (pair = slot.method_7679()) != null) {
            class_1058 sprite = (class_1058)this.field_22787.method_1549((class_2960)pair.getFirst()).apply((class_2960)pair.getSecond());
            context.method_25298(((Integer)pos.getFirst()).intValue(), ((Integer)pos.getSecond()).intValue(), 0, 16, 16, sprite);
            bl2 = true;
        }
        if (!bl2) {
            if (bl) {
                context.method_25294(((Integer)pos.getFirst()).intValue(), ((Integer)pos.getSecond()).intValue(), (Integer)pos.getFirst() + 16, (Integer)pos.getSecond() + 16, -2130706433);
            }
            context.method_51428(itemStack, ((Integer)pos.getFirst()).intValue(), ((Integer)pos.getSecond()).intValue(), (Integer)pos.getFirst() + (Integer)pos.getSecond() * this.backgroundWidth);
            if (string != null) {
                context.method_51432(this.field_22793, itemStack, ((Integer)pos.getFirst()).intValue(), ((Integer)pos.getSecond()).intValue(), string);
            } else if (!itemStack.method_7960() && itemStack.method_7947() > 1) {
                RessourceGuiHelper.drawRessourceExtra(context, UniversalResource.fromItemOpti(itemStack), (Integer)pos.getFirst(), (Integer)pos.getSecond(), 0.0f, 0xFFFFFF);
            }
        }
        context.method_51448().method_22909();
    }

    public void drawItemInSlot(class_332 ctx, class_1799 stack, int x, int y, @Nullable String countOverride) {
        if (!stack.method_7960()) {
            class_746 clientPlayerEntity;
            float f;
            int l;
            ctx.method_51448().method_22903();
            if (stack.method_7947() != 1 || countOverride != null) {
                String string = countOverride == null ? RessourceGuiHelper.getCountDisplay(stack.method_7947(), false) : countOverride;
                ctx.method_51448().method_46416(0.0f, 0.0f, 200.0f);
                ctx.method_51433(this.field_22793, string, x + 19 - 2 - this.field_22793.method_1727(string), y + 6 + 3, 0xFFFFFF, true);
            }
            if (stack.method_31578()) {
                int i = stack.method_31579();
                int j = stack.method_31580();
                int k = x + 2;
                l = y + 13;
                ctx.method_51739(class_1921.method_51785(), k, l, k + 13, l + 2, -16777216);
                ctx.method_51739(class_1921.method_51785(), k, l, k + i, l + 1, j | 0xFF000000);
            }
            float f2 = f = (clientPlayerEntity = this.field_22787.field_1724) == null ? 0.0f : clientPlayerEntity.method_7357().method_7905(stack.method_7909(), this.field_22787.method_1488());
            if (f > 0.0f) {
                int k = y + class_3532.method_15375((float)(16.0f * (1.0f - f)));
                l = k + class_3532.method_15386((float)(16.0f * f));
                ctx.method_51739(class_1921.method_51785(), x, k, x + 16, l, Integer.MAX_VALUE);
            }
            ctx.method_51448().method_22909();
        }
    }
}

