/*
 * Decompiled with CFR 0.152.
 */
package com.diamssword.greenresurgence.render.blockEntityRenderer;

import com.diamssword.greenresurgence.GreenResurgence;
import com.diamssword.greenresurgence.blockEntities.ImageBlockEntity;
import com.diamssword.greenresurgence.blocks.ImageBlock;
import com.diamssword.greenresurgence.render.images.TextureCache;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3545;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5614;
import net.minecraft.class_776;
import net.minecraft.class_7833;
import net.minecraft.class_827;
import org.joml.Matrix4f;

@Environment(value=EnvType.CLIENT)
public class ImageBlockEntityRenderer
implements class_827<ImageBlockEntity> {
    private static final class_2960 EMPTY_IMAGE = GreenResurgence.asRessource("textures/block/empty_image.png");
    private static final float THICKNESS = 0.0625f;
    private final class_776 blockRenderManager;

    public ImageBlockEntityRenderer(class_5614.class_5615 ctx) {
        this.blockRenderManager = ctx.method_32141();
    }

    public void render(ImageBlockEntity blockEntity, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay) {
        class_2960 id = TextureCache.instance().getImage(blockEntity.getContent());
        ImageBlockEntityRenderer.renderImage(id, blockEntity, (class_2350)blockEntity.method_11010().method_11654((class_2769)ImageBlock.FACING), matrices, vertexConsumers, light);
    }

    public static void renderImage(class_2960 image, ImageBlockEntity te, class_2350 facing, class_4587 matrixStack, class_4597 buffer1, int light) {
        float ratioY;
        float ratioX;
        matrixStack.method_22903();
        float width = te.getSize().field_1343;
        float height = te.getSize().field_1342;
        float imageRatio = 1.0f;
        class_2960 resourceLocation = EMPTY_IMAGE;
        if (image != null) {
            resourceLocation = image;
            class_3545<Integer, Integer> size = TextureCache.instance().getSize(image);
            if (size != null) {
                imageRatio = (float)((Integer)size.method_15442()).intValue() / (float)((Integer)size.method_15441()).intValue();
            }
        }
        if (!te.isStretch()) {
            height = width;
        }
        ImageBlockEntityRenderer.rotate(facing, matrixStack);
        float frameRatio = width / height;
        float ratio = imageRatio / frameRatio;
        if (te.isStretch()) {
            ratioX = 0.0f;
            ratioY = 0.0f;
        } else {
            if (ratio >= 1.0f) {
                ratioY = (1.0f - 1.0f / ratio) / 2.0f;
                ratioX = 0.0f;
            } else {
                ratioX = (1.0f - ratio) / 2.0f;
                ratioY = 0.0f;
            }
            ratioX *= width;
            ratioY *= height;
        }
        matrixStack.method_22904(te.isOffsetX() ? 0.0 : 0.5, te.isOffsetY() ? 0.0 : 0.5, -0.05);
        matrixStack.method_22907(class_7833.field_40718.rotationDegrees(te.getRotation()));
        matrixStack.method_22904((double)(-width / 2.0f), (double)(-height / 2.0f), 0.0);
        class_4588 builderFront = buffer1.getBuffer(class_1921.method_23576((class_2960)resourceLocation));
        ImageBlockEntityRenderer.vertex(builderFront, matrixStack, 0.0f + ratioX, ratioY, 0.0625f, 0.0f, 1.0f, light);
        ImageBlockEntityRenderer.vertex(builderFront, matrixStack, width - ratioX, ratioY, 0.0625f, 1.0f, 1.0f, light);
        ImageBlockEntityRenderer.vertex(builderFront, matrixStack, width - ratioX, height - ratioY, 0.0625f, 1.0f, 0.0f, light);
        ImageBlockEntityRenderer.vertex(builderFront, matrixStack, ratioX, height - ratioY, 0.0625f, 0.0f, 0.0f, light);
        matrixStack.method_22909();
    }

    public static void rotate(class_2350 facing, class_4587 matrixStack) {
        switch (facing) {
            case field_11043: {
                matrixStack.method_22904(1.0, 0.0, 1.0);
                matrixStack.method_22907(class_7833.field_40716.rotationDegrees(180.0f));
                break;
            }
            case field_11035: {
                break;
            }
            case field_11034: {
                matrixStack.method_22904(0.0, 0.0, 1.0);
                matrixStack.method_22907(class_7833.field_40716.rotationDegrees(90.0f));
                break;
            }
            case field_11039: {
                matrixStack.method_22904(1.0, 0.0, 0.0);
                matrixStack.method_22907(class_7833.field_40716.rotationDegrees(270.0f));
                break;
            }
            case field_11036: {
                matrixStack.method_22904(0.0, 0.0, 1.0);
                matrixStack.method_22907(class_7833.field_40713.rotationDegrees(90.0f));
                break;
            }
            case field_11033: {
                matrixStack.method_22904(0.0, 1.0, 0.0);
                matrixStack.method_22907(class_7833.field_40714.rotationDegrees(90.0f));
            }
        }
    }

    private static void vertex(class_4588 builder, class_4587 matrixStack, float x, float y, float z, float u, float v, int light) {
        class_4587.class_4665 entry = matrixStack.method_23760();
        Matrix4f matrix4f = entry.method_23761();
        builder.method_22918(matrix4f, x, y, z).method_1336(255, 255, 255, 255).method_22913(u, v).method_22922(class_4608.field_21444).method_22916(light).method_23763(entry.method_23762(), 0.0f, 0.0f, -1.0f).method_1344();
    }
}

