/*
 * Decompiled with CFR 0.152.
 */
package com.diamssword.greenresurgence.render.images;

import com.diamssword.greenresurgence.GreenResurgence;
import com.diamssword.greenresurgence.render.images.RenderUtils;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1011;

@Environment(value=EnvType.CLIENT)
public class ImageTools {
    private static final int MAX_IMAGE_SIZE = 1920;

    public static BufferedImage fromNativeImage(class_1011 nativeImage) {
        BufferedImage bufferedImage = new BufferedImage(nativeImage.method_4307(), nativeImage.method_4323(), 1);
        for (int x = 0; x < nativeImage.method_4307(); ++x) {
            for (int y = 0; y < nativeImage.method_4323(); ++y) {
                int rgba = nativeImage.method_4315(x, y);
                int alpha = RenderUtils.getAlpha(rgba);
                int red = RenderUtils.getRed(rgba);
                int green = RenderUtils.getGreen(rgba);
                int blue = RenderUtils.getBlue(rgba);
                bufferedImage.setRGB(x, y, RenderUtils.getArgb(alpha, blue, green, red));
            }
        }
        return bufferedImage;
    }

    public static class_1011 toNativeImage(BufferedImage bufferedImage) {
        class_1011 nativeImage = new class_1011(bufferedImage.getWidth(), bufferedImage.getHeight(), false);
        for (int x = 0; x < bufferedImage.getWidth(); ++x) {
            for (int y = 0; y < bufferedImage.getHeight(); ++y) {
                int rgba = bufferedImage.getRGB(x, y);
                int alpha = RenderUtils.getAlpha(rgba);
                int red = RenderUtils.getRed(rgba);
                int green = RenderUtils.getGreen(rgba);
                int blue = RenderUtils.getBlue(rgba);
                nativeImage.method_4305(x, y, RenderUtils.getArgb(alpha, blue, green, red));
            }
        }
        return nativeImage;
    }

    public static byte[] toBytes(BufferedImage image) throws IOException {
        ImageIO.setUseCache(false);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)image, "jpg", baos);
        baos.flush();
        byte[] data = baos.toByteArray();
        baos.close();
        return data;
    }

    public static BufferedImage fromBytes(byte[] data) throws IOException {
        ImageIO.setUseCache(false);
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        BufferedImage image = ImageIO.read(bais);
        bais.close();
        return image;
    }

    public static byte[] optimizeImage(BufferedImage image) throws IOException {
        byte[] data;
        float ratio = (float)image.getHeight() / (float)image.getWidth();
        int newWidth = image.getWidth();
        int newHeight = image.getHeight();
        if (image.getHeight() > 1920 || image.getWidth() > 1920) {
            if (ratio < 1.0f) {
                newHeight = (int)(1920.0f * ratio);
                newWidth = 1920;
            } else {
                newWidth = (int)(1920.0f / ratio);
                newHeight = 1920;
            }
        }
        image = ImageTools.resize(image, newWidth, newHeight);
        float factor = 0.5f;
        while ((data = ImageTools.compressToBytes(image, factor)).length > 200000) {
            GreenResurgence.LOGGER.debug("Trying to compress image: {}% {} bytes (max {})", new Object[]{Math.round(factor * 100.0f), data.length, 200000});
            if (!((factor -= 0.025f) <= 0.0f)) continue;
            throw new IOException("Image could not be compressed (too large)");
        }
        GreenResurgence.LOGGER.debug("Image compressed to {}% ({} bytes)", (Object)Math.round(factor * 100.0f), (Object)data.length);
        return data;
    }

    public static BufferedImage resize(BufferedImage img, int newW, int newH) {
        Image tmp = img.getScaledInstance(newW, newH, 4);
        BufferedImage bufferedImage = new BufferedImage(newW, newH, 1);
        Graphics2D g2d = bufferedImage.createGraphics();
        g2d.drawImage(tmp, 0, 0, null);
        g2d.dispose();
        return bufferedImage;
    }

    public static BufferedImage compress(BufferedImage img, float factor) throws IOException {
        return ImageTools.fromBytes(ImageTools.compressToBytes(img, factor));
    }

    public static byte[] compressToBytes(BufferedImage img, float factor) throws IOException {
        ImageWriter jpgWriter = ImageIO.getImageWritersByFormatName("jpg").next();
        ImageWriteParam jpgWriteParam = jpgWriter.getDefaultWriteParam();
        jpgWriteParam.setCompressionMode(2);
        jpgWriteParam.setCompressionQuality(factor);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        MemoryCacheImageOutputStream stream = new MemoryCacheImageOutputStream(baos);
        jpgWriter.setOutput(stream);
        IIOImage outputImage = new IIOImage(img, null, null);
        jpgWriter.write(null, outputImage, jpgWriteParam);
        jpgWriter.dispose();
        baos.flush();
        byte[] data = baos.toByteArray();
        baos.close();
        return data;
    }

    public static BufferedImage loadImage(File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        BufferedImage bufferedImage = ImageIO.read(fis);
        if (bufferedImage == null) {
            throw new IOException("Failed to read image");
        }
        return bufferedImage;
    }
}

