/*
 * Decompiled with CFR 0.152.
 */
package com.diamssword.greenresurgence.systems.character;

import com.diamssword.greenresurgence.systems.character.customPoses.BeingCarriedPose;
import com.diamssword.greenresurgence.systems.character.customPoses.CarryingPose;
import com.diamssword.greenresurgence.systems.character.customPoses.IPlayerCustomPose;
import com.diamssword.greenresurgence.systems.character.customPoses.KnucklesHandWield;
import com.diamssword.greenresurgence.systems.character.customPoses.PushingCartPose;
import com.diamssword.greenresurgence.systems.character.customPoses.TwoHandWield;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_1657;

public class PosesManager {
    public static final String CARRIED = "carried";
    public static final String TWOHANDWIELD = "two_hand_wield";
    public static final String KNUCLESHANDWIELD = "knuckles_hand_wield";
    public static final String CARRYINGENTITY = "carrying_entity";
    public static final String PUSHINGCART = "pushing_cart";
    private static final Map<String, Function<class_1657, IPlayerCustomPose>> posesRegister = new HashMap<String, Function<class_1657, IPlayerCustomPose>>();

    public static IPlayerCustomPose createPose(String id, class_1657 player) {
        if (posesRegister.containsKey(id)) {
            return posesRegister.get(id).apply(player);
        }
        return null;
    }

    static {
        posesRegister.put(CARRIED, BeingCarriedPose::new);
        posesRegister.put(TWOHANDWIELD, TwoHandWield::new);
        posesRegister.put(KNUCLESHANDWIELD, KnucklesHandWield::new);
        posesRegister.put(CARRYINGENTITY, CarryingPose::new);
        posesRegister.put(PUSHINGCART, PushingCartPose::new);
    }
}

