/*
 * Decompiled with CFR 0.152.
 */
package com.diamssword.greenresurgence.systems.crafting;

import com.diamssword.greenresurgence.GreenResurgence;
import com.diamssword.greenresurgence.network.Channels;
import com.diamssword.greenresurgence.network.DictionaryPackets;
import com.diamssword.greenresurgence.systems.crafting.RecipeCollection;
import com.diamssword.greenresurgence.systems.crafting.SimpleRecipe;
import com.diamssword.greenresurgence.systems.faction.BaseInteractions;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_2248;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;

public class RecipeLoader
implements SimpleSynchronousResourceReloadListener {
    private final Map<class_2960, RecipeCollection> registry = new HashMap<class_2960, RecipeCollection>();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final Logger LOGGER = LogUtils.getLogger();
    private boolean shouldSync = false;

    public Optional<RecipeCollection> getCollection(class_2960 id) {
        return Optional.ofNullable(this.registry.get(id));
    }

    public class_2960 getFabricId() {
        return GreenResurgence.asRessource("grecipes");
    }

    public void method_14491(class_3300 manager) {
        this.registry.clear();
        BaseInteractions.registerBlocks();
        manager.method_14488("grecipes", v -> v.method_12832().endsWith(".json") && v.method_12832().split("/").length > 2).forEach((id, re) -> {
            try (BufferedReader reader = re.method_43039();){
                JsonObject jsonElement = (JsonObject)class_3518.method_15276((Gson)GSON, (Reader)reader, JsonObject.class);
                if (jsonElement.has("type")) {
                    String type = jsonElement.get("type").getAsString();
                    if (type.equals("simple")) {
                        SimpleRecipe recip = SimpleRecipe.deserializer(jsonElement);
                        class_2960 id1 = new class_2960(id.method_12836(), id.method_12832().substring(id.method_12832().indexOf("/") + 1));
                        if (!this.registry.containsKey(id1 = new class_2960(id1.method_12836(), id1.method_12832().substring(0, id1.method_12832().lastIndexOf("/"))))) {
                            this.registry.put(id1, new RecipeCollection(id1));
                        }
                        recip.blocksResult().ifPresent(v1 -> BaseInteractions.allowedBlocks.add((class_2248)v1));
                        String id2 = id.method_12832().substring(id.method_12832().lastIndexOf("/") + 1).replace(".json", "");
                        this.registry.get(id1).add(id2, recip);
                    } else if (type.equals("multi")) {
                        List<SimpleRecipe> recip = SimpleRecipe.deserializerMulti(jsonElement);
                        class_2960 id1 = new class_2960(id.method_12836(), id.method_12832().substring(id.method_12832().indexOf("/") + 1));
                        if (!this.registry.containsKey(id1 = new class_2960(id1.method_12836(), id1.method_12832().substring(0, id1.method_12832().lastIndexOf("/"))))) {
                            this.registry.put(id1, new RecipeCollection(id1));
                        }
                        String id2 = id.method_12832().substring(id.method_12832().lastIndexOf("/") + 1).replace(".json", "");
                        recip.forEach(v -> v.blocksResult().ifPresent(v1 -> BaseInteractions.allowedBlocks.add((class_2248)v1)));
                        HashMap<String, SimpleRecipe> m = new HashMap<String, SimpleRecipe>();
                        for (int i = 0; i < recip.size(); ++i) {
                            m.put(id2 + i, recip.get(i));
                        }
                        this.registry.get(id1).addAll(m);
                    } else {
                        LOGGER.error("unsupported 'type': '{}' for {} from {}", new Object[]{type, id, this.getFabricId()});
                    }
                } else {
                    LOGGER.error("missing 'type' field for {} from {}", id, (Object)this.getFabricId());
                }
            }
            catch (JsonParseException | IOException | IllegalArgumentException exception) {
                LOGGER.error("Couldn't parse data file {} from {}", new Object[]{id, this.getFabricId(), exception});
            }
        });
        this.shouldSync = true;
    }

    public void worldTick(MinecraftServer server) {
        if (this.shouldSync) {
            this.shouldSync = false;
            Channels.MAIN.serverHandle(server).send((Record)BaseInteractions.getPacket());
            Channels.serverHandle(server).send((Record)new DictionaryPackets.RecipeList(this));
        }
    }

    public static void serializer(class_2540 write, RecipeLoader val) {
        class_2499 list = new class_2499();
        val.registry.forEach((k, v) -> {
            class_2487 tag = new class_2487();
            tag.method_10582("id", k.toString());
            List<SimpleRecipe> recs = v.getRecipes(null);
            class_2499 list1 = new class_2499();
            recs.forEach(r -> {
                JsonObject sr = r.serialize();
                sr.addProperty("unserial", "simple");
                list1.add((Object)class_2519.method_23256((String)sr.toString()));
            });
            tag.method_10566("recipes", (class_2520)list1);
            list.add((Object)tag);
        });
        class_2487 res = new class_2487();
        res.method_10566("list", (class_2520)list);
        write.method_10794(res);
    }

    public static RecipeLoader unserializer(class_2540 read) {
        RecipeLoader loader = new RecipeLoader();
        class_2487 comp = read.method_10798();
        class_2499 list = comp.method_10554("list", 10);
        list.forEach(el -> {
            class_2487 e = (class_2487)el;
            class_2960 id = new class_2960(e.method_10558("id"));
            loader.registry.putIfAbsent(id, new RecipeCollection(id));
            if (id != null) {
                class_2499 ls1 = e.method_10554("recipes", 8);
                ls1.forEach(el1 -> {
                    JsonObject ob = (JsonObject)class_3518.method_15284((Gson)GSON, (String)el1.method_10714(), JsonObject.class);
                    if (ob.get("unserial").getAsString().equals("simple")) {
                        try {
                            SimpleRecipe r1 = SimpleRecipe.deserializer(ob);
                            loader.registry.get(id).add(r1);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                });
            }
        });
        return loader;
    }
}

