/*
 * Decompiled with CFR 0.152.
 */
package com.diamssword.greenresurgence.systems.crafting;

import com.diamssword.greenresurgence.systems.crafting.Recipes;
import com.diamssword.greenresurgence.systems.crafting.UniversalResource;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class SimpleRecipe {
    private class_2960 id;
    private final UniversalResource result;
    private final List<UniversalResource> ingredients;

    public SimpleRecipe setID(class_2960 collection, String recipeID) {
        this.id = new class_2960(collection.method_12836(), collection.method_12832() + "/" + recipeID);
        return this;
    }

    public SimpleRecipe setID(class_2960 fullID) {
        this.id = fullID;
        return this;
    }

    public class_2960 getId() {
        return this.id;
    }

    public SimpleRecipe(class_1799 result, class_1799 ... ingredients) {
        this.result = UniversalResource.fromItem(result);
        this.ingredients = Arrays.stream(ingredients).map(UniversalResource::fromItem).toList();
    }

    public SimpleRecipe(class_2960 result) {
        this.result = UniversalResource.fromItem(result);
        this.ingredients = new ArrayList<UniversalResource>();
    }

    public SimpleRecipe(class_1792 result, class_1799 ... ingredients) {
        this(new class_1799((class_1935)result), ingredients);
    }

    public SimpleRecipe(UniversalResource res, List<UniversalResource> ingredients) {
        this.result = res;
        this.ingredients = ingredients;
    }

    public UniversalResource result(@Nullable class_1657 player) {
        return this.result;
    }

    public Optional<class_2248> blocksResult() {
        class_1792 class_17922;
        if (this.result.getType() == UniversalResource.Type.item && (class_17922 = this.result.asItem().method_7909()) instanceof class_1747) {
            class_1747 be = (class_1747)class_17922;
            return Optional.of(be.method_7711());
        }
        return Optional.empty();
    }

    public List<UniversalResource> ingredients(class_1657 player) {
        return this.ingredients;
    }

    public static SimpleRecipe deserializer(JsonObject ob) throws Exception {
        if (ob.has("ingredients") && ob.has("result")) {
            ArrayList<UniversalResource> ingsR = new ArrayList<UniversalResource>();
            for (JsonElement ing : ob.get("ingredients").getAsJsonArray()) {
                ingsR.add(UniversalResource.deserializer(ing.getAsJsonObject()));
            }
            UniversalResource res = UniversalResource.deserializer(ob.getAsJsonObject("result"));
            SimpleRecipe r = new SimpleRecipe(res, ingsR);
            if (ob.has("id")) {
                r.setID(new class_2960(ob.get("id").getAsString()));
            }
            return r;
        }
        throw new Exception("missing 'ingredients' or 'result' element");
    }

    public JsonObject serialize() {
        JsonObject res = new JsonObject();
        JsonArray ia = new JsonArray();
        this.ingredients.forEach(v -> ia.add((JsonElement)v.serializer()));
        res.add("ingredients", (JsonElement)ia);
        res.add("result", (JsonElement)this.result.serializer());
        if (this.id != null) {
            res.addProperty("id", this.id.toString());
        }
        return res;
    }

    public static List<SimpleRecipe> deserializerMulti(JsonObject ob) throws Exception {
        ArrayList<SimpleRecipe> res = new ArrayList<SimpleRecipe>();
        if (ob.has("ingredients") && ob.has("results")) {
            ArrayList<UniversalResource> ingsR = new ArrayList<UniversalResource>();
            for (JsonElement ing : ob.get("ingredients").getAsJsonArray()) {
                ingsR.add(UniversalResource.deserializer(ing.getAsJsonObject()));
            }
            for (JsonElement ing : ob.get("results").getAsJsonArray()) {
                res.add(new SimpleRecipe(UniversalResource.deserializer(ing.getAsJsonObject()), ingsR));
            }
        } else {
            throw new Exception("missing 'ingredients' or 'result' element");
        }
        return res;
    }

    public static void serializer(class_2540 write, SimpleRecipe val) {
        if (val.getId() != null) {
            write.method_10814(val.getId().toString());
        }
    }

    public static SimpleRecipe unserializer(class_2540 read) {
        String id = read.method_19772();
        if (!id.isEmpty()) {
            class_2960 id1 = new class_2960(id);
            return Recipes.getRecipe(id1).orElse(null);
        }
        return null;
    }
}

