/*
 * Decompiled with CFR 0.152.
 */
package com.diamssword.greenresurgence.systems.crafting;

import com.diamssword.greenresurgence.containers.player.CustomPlayerInventory;
import com.diamssword.greenresurgence.systems.crafting.CraftingProvider;
import com.diamssword.greenresurgence.systems.crafting.CraftingResult;
import com.diamssword.greenresurgence.systems.crafting.PendingCraft;
import com.diamssword.greenresurgence.systems.crafting.Recipes;
import com.diamssword.greenresurgence.systems.crafting.SimpleRecipe;
import com.diamssword.greenresurgence.systems.crafting.UniversalResource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class TimedCraftingProvider
extends CraftingProvider {
    List<PendingCraft> pendingCrafts = new ArrayList<PendingCraft>();
    PendingCraft currentCraft;
    int totalTime;
    int elapsedTime;
    private int updateNeeded = 0;
    private Runnable onNewRecipeListener;

    public TimedCraftingProvider() {
    }

    public TimedCraftingProvider(class_2487 tag) {
        if (tag.method_10545("pending")) {
            class_2499 ls = tag.method_10554("pending", 10);
            ls.forEach(v -> {
                Optional<SimpleRecipe> re;
                class_2487 comp;
                if (v instanceof class_2487 && (comp = (class_2487)v).method_10545("recipe") && (re = Recipes.getRecipe(new class_2960(comp.method_10558("recipe")))).isPresent()) {
                    PendingCraft d = new PendingCraft(re.get());
                    if (comp.method_10545("stacks")) {
                        d.stacks.method_7659(comp.method_10554("stacks", 10));
                    }
                    this.pendingCrafts.add(d);
                }
            });
        }
        if (tag.method_10545("time")) {
            this.elapsedTime = tag.method_10550("time");
        }
    }

    public class_2487 toNBT() {
        ArrayList<PendingCraft> ls = new ArrayList<PendingCraft>();
        if (this.currentCraft != null) {
            ls.add(this.currentCraft);
        }
        ls.addAll(this.pendingCrafts);
        class_2487 nbt = new class_2487();
        class_2499 nbl = new class_2499();
        ls.forEach(c -> {
            class_2487 nbt1 = new class_2487();
            nbt1.method_10582("recipe", c.recipe.getId().toString());
            nbt1.method_10566("stacks", (class_2520)c.stacks.method_7660());
            nbl.add((Object)nbt1);
        });
        nbt.method_10566("pending", (class_2520)nbl);
        nbt.method_10569("time", this.elapsedTime);
        return nbt;
    }

    public final CraftingProvider setForPlayer(CustomPlayerInventory player) {
        List<InventoryStorage> ls = player.getAllInventories().stream().map(i -> InventoryStorage.of((class_1263)i, null)).toList();
        this.setInventories((Storage[])ls.toArray(new InventoryStorage[0]));
        return this;
    }

    public void clearPendings() {
        this.pendingCrafts.clear();
        this.currentCraft = null;
        ++this.updateNeeded;
    }

    public void addPending(PendingCraft craft) {
        this.pendingCrafts.add(craft);
        ++this.updateNeeded;
    }

    public List<PendingCraft> getPendingCrafts() {
        ArrayList<PendingCraft> ls = new ArrayList<PendingCraft>();
        if (this.currentCraft != null) {
            ls.add(this.currentCraft);
        }
        ls.addAll(this.pendingCrafts);
        return ls;
    }

    public void onNewRecipeQueued(Runnable consumer) {
        this.onNewRecipeListener = consumer;
    }

    public void tick(class_1657 player) {
        if (this.currentCraft == null && !this.pendingCrafts.isEmpty()) {
            this.currentCraft = this.pendingCrafts.remove(0);
            ++this.updateNeeded;
            this.totalTime = TimedCraftingProvider.getCraftingTime(this.currentCraft.recipe, player);
            this.elapsedTime = 0;
        } else if (this.currentCraft != null) {
            if (this.elapsedTime >= this.totalTime) {
                UniversalResource res = this.currentCraft.recipe.result(player);
                if (res.getType().isItem && !player.method_7270(res.asItem())) {
                    player.method_5775(res.asItem());
                }
                ++this.updateNeeded;
                this.currentCraft = null;
            }
            ++this.elapsedTime;
        }
        if (this.updateNeeded > 0) {
            this.updateNeeded = 0;
            if (this.onNewRecipeListener != null) {
                this.onNewRecipeListener.run();
            }
        }
    }

    public static int getCraftingTime(SimpleRecipe recipe, @Nullable class_1657 player) {
        int time = 0;
        List<UniversalResource> ingredients = recipe.ingredients(player);
        for (UniversalResource ing : ingredients) {
            if (ing.getType() != UniversalResource.Type.time) continue;
            time += ing.getAmount();
        }
        return time;
    }

    @Override
    public boolean craftRecipe(SimpleRecipe recipe, class_1657 player) {
        PendingCraft pending = new PendingCraft(recipe);
        Storage<ItemVariant> stackCopy = pending.getAsStorage();
        List<UniversalResource> ingrs = recipe.ingredients(player);
        boolean complete = true;
        try (Transaction t1 = Transaction.openOuter();){
            for (UniversalResource ingr : ingrs) {
                if (ingr.getType().isItem) {
                    if (this.hasItem(ingr, (TransactionContext)t1, stackCopy)) continue;
                    complete = false;
                    continue;
                }
                if (ingr.getType().isFluid) {
                    if (this.hasFluid(ingr, (TransactionContext)t1, null)) continue;
                    complete = false;
                    continue;
                }
                if (ingr.getType() == UniversalResource.Type.time) continue;
                complete = false;
            }
            if (!complete) {
                t1.abort();
            } else {
                t1.commit();
            }
        }
        if (complete) {
            UniversalResource res = recipe.result(player);
            if (res.getType().isItem) {
                this.pendingCrafts.add(pending);
                ++this.updateNeeded;
            }
            return true;
        }
        return false;
    }

    @Override
    public CraftingResult getRecipeStatus(SimpleRecipe recipe, @Nullable class_1657 player) {
        HashMap<UniversalResource, Boolean> status = new HashMap<UniversalResource, Boolean>();
        List<UniversalResource> ingrs = recipe.ingredients(player);
        boolean complete = true;
        try (Transaction t1 = Transaction.openOuter();){
            for (UniversalResource ingr : ingrs) {
                boolean d;
                if (ingr.getType().isItem) {
                    d = this.hasItem(ingr, (TransactionContext)t1, null);
                    status.put(ingr, d);
                    if (d) continue;
                    complete = false;
                    continue;
                }
                if (ingr.getType().isFluid) {
                    d = this.hasFluid(ingr, (TransactionContext)t1, null);
                    status.put(ingr, d);
                    if (d) continue;
                    complete = false;
                    continue;
                }
                complete = false;
            }
            t1.abort();
        }
        return new CraftingResult(complete, status);
    }

    public void tickClient(class_1657 player) {
        if (this.currentCraft == null && !this.pendingCrafts.isEmpty()) {
            this.currentCraft = this.pendingCrafts.remove(0);
            this.totalTime = TimedCraftingProvider.getCraftingTime(this.currentCraft.recipe, player);
            this.elapsedTime = 0;
            ++this.updateNeeded;
        }
        if (this.currentCraft != null) {
            if (this.elapsedTime >= this.totalTime) {
                this.currentCraft = null;
                ++this.updateNeeded;
            }
            ++this.elapsedTime;
        }
        if (this.updateNeeded > 0) {
            this.updateNeeded = 0;
            if (this.onNewRecipeListener != null) {
                this.onNewRecipeListener.run();
            }
        }
    }

    public float getCraftProgress() {
        if (this.totalTime > 0) {
            return (float)this.elapsedTime / (float)this.totalTime;
        }
        return 0.0f;
    }
}

