/*
 * Decompiled with CFR 0.152.
 */
package com.diamssword.greenresurgence.systems.crafting;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2522;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_3611;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public class UniversalResource {
    private class_1799[] itemCache = new class_1799[]{class_1799.field_8037};
    private class_3611[] fluidCache = new class_3611[0];
    private final int count;
    private final class_2487 data;
    private final class_2960 item;
    private final Type type;

    public static UniversalResource fromItemTag(class_6862<class_1792> key, int count) {
        return new UniversalResource(Type.itemtag, key.comp_327(), count, null);
    }

    public static UniversalResource fromItemTag(class_6862<class_1792> key, int count, class_2487 tag) {
        return new UniversalResource(Type.itemtag, key.comp_327(), count, tag);
    }

    public static UniversalResource fromItemOpti(class_1799 stack) {
        return new UniversalResource(stack);
    }

    public static UniversalResource fromItem(class_1799 stack) {
        return new UniversalResource(Type.item, class_7923.field_41178.method_10221((Object)stack.method_7909()), stack.method_7947(), null);
    }

    public static UniversalResource fromItem(class_2960 itemId) {
        return new UniversalResource(Type.item, itemId, 1, null);
    }

    public static UniversalResource fromItem(class_1799 stack, class_2487 tag) {
        return new UniversalResource(Type.item, class_7923.field_41178.method_10221((Object)stack.method_7909()), stack.method_7947(), tag);
    }

    protected UniversalResource(class_1799 stack) {
        this.count = stack.method_7947();
        this.data = stack.method_7969();
        this.item = new class_2960("empty");
        this.type = Type.item;
        this.itemCache = new class_1799[]{stack};
    }

    protected UniversalResource(Type type, class_2960 id, int count, @Nullable class_2487 tag) {
        this.count = count;
        this.data = tag;
        this.item = id;
        this.type = type;
        this.fillCache();
    }

    public Type getType() {
        return this.type;
    }

    private void fillCache() {
        if (this.type == Type.item) {
            this.itemCache = new class_1799[]{this.buildItemStack(this.item)};
        } else if (this.type == Type.itemtag) {
            ArrayList r = new ArrayList();
            class_7923.field_41178.method_40286(class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)this.item)).forEach(i -> i.method_40230().ifPresent(v -> r.add(this.buildItemStack(v.method_29177()))));
            if (r.isEmpty()) {
                class_7923.field_41175.method_40286(class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)this.item)).forEach(i -> i.method_40230().ifPresent(v -> r.add(this.buildItemStack(v.method_29177()))));
            }
            this.itemCache = r.toArray(new class_1799[0]);
        } else if (this.type == Type.fluid) {
            this.fluidCache = new class_3611[]{(class_3611)class_7923.field_41173.method_10223(this.item)};
        } else if (this.type == Type.fluidtag) {
            ArrayList r = new ArrayList();
            class_7923.field_41173.method_40286(class_6862.method_40092((class_5321)class_7924.field_41270, (class_2960)this.item)).forEach(i -> i.method_40230().ifPresent(v -> r.add((class_3611)class_7923.field_41173.method_10223(v.method_29177()))));
            this.fluidCache = r.toArray(new class_3611[0]);
        }
    }

    private class_1799 buildItemStack(class_2960 id) {
        class_1799 i = new class_1799((class_1935)class_7923.field_41178.method_10223(id), this.count);
        if (this.data != null) {
            i.method_7980(this.data);
        }
        return i;
    }

    public class_3611[] getAllFluids() {
        return this.fluidCache;
    }

    public class_1799[] getAllStacks() {
        return this.itemCache;
    }

    public class_2960 getID() {
        return this.item;
    }

    public class_2960[] getAllPossibleIds() {
        if (this.type == Type.itemtag) {
            class_2960[] r = new class_2960[this.itemCache.length];
            for (int i = 0; i < r.length; ++i) {
                r[i] = class_7923.field_41178.method_10221((Object)this.itemCache[i].method_7909());
            }
            return r;
        }
        if (this.type == Type.fluidtag) {
            class_2960[] r = new class_2960[this.fluidCache.length];
            for (int i = 0; i < r.length; ++i) {
                r[i] = class_7923.field_41173.method_10221((Object)this.fluidCache[i]);
            }
            return r;
        }
        return new class_2960[]{this.getID()};
    }

    public class_1799 asItem() {
        if (this.type.isItem) {
            return this.itemCache[0].method_7972();
        }
        return class_1799.field_8037.method_7972();
    }

    public Optional<class_3611> asFluid() {
        if (this.type.isFluid) {
            return Optional.of(this.fluidCache[0]);
        }
        return Optional.empty();
    }

    public class_1799 getCurrentItem(float time) {
        class_1799[] itemStacks = this.itemCache;
        return itemStacks.length == 0 ? class_1799.field_8037 : itemStacks[class_3532.method_15375((float)(time / 30.0f)) % itemStacks.length].method_7972();
    }

    public Optional<class_3611> getCurrentFluid(float time) {
        class_3611[] itemStacks = this.fluidCache;
        return itemStacks.length == 0 ? Optional.empty() : Optional.of(itemStacks[class_3532.method_15375((float)(time / 30.0f)) % itemStacks.length]);
    }

    public int getAmount() {
        return this.count;
    }

    public class_2561 getName() {
        if (this.type.isItem) {
            return this.asItem().method_7964();
        }
        if (this.type.isFluid) {
            return this.asFluid().get().method_15785().method_15759().method_26204().method_9518();
        }
        return class_2561.method_30163((String)"Energy");
    }

    public class_2561 getName(float time) {
        if (this.type.isItem) {
            return this.getCurrentItem(time).method_7964();
        }
        if (this.type.isFluid) {
            Optional<class_3611> f = this.getCurrentFluid(time);
            if (f.isPresent()) {
                return f.get().method_15785().method_15759().method_26204().method_9518();
            }
            return class_2561.method_30163((String)"(Fluid Manquant)");
        }
        return class_2561.method_30163((String)"\u26a1 Energie");
    }

    public class_2487 extra() {
        return this.data;
    }

    public boolean equals(Object obj) {
        if (obj instanceof UniversalResource) {
            UniversalResource re = (UniversalResource)obj;
            if (re.type == this.type && re.item.equals((Object)this.item) && re.count == this.count) {
                if (re.extra() == null && this.extra() == null) {
                    return true;
                }
                if (re.extra() != null && this.extra() != null) {
                    return re.extra().equals((Object)this.extra());
                }
                return false;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.type.hashCode() + this.getID().hashCode() + this.count;
    }

    public static UniversalResource deserializer(JsonObject ob) throws Exception {
        Type type = Type.item;
        String name = "";
        if (ob.has("type")) {
            switch (ob.get("type").getAsString()) {
                case "tag": {
                    type = Type.itemtag;
                    break;
                }
                case "fluid": {
                    type = Type.fluid;
                    break;
                }
                case "fluidtag": {
                    type = Type.fluidtag;
                    break;
                }
                case "energy": {
                    type = Type.energy;
                    break;
                }
                case "time": {
                    type = Type.time;
                }
            }
        }
        if ((type.isFluid || type.isItem) && !ob.has("name")) {
            throw new Exception("Ingredient is missing 'name' field");
        }
        name = ob.has("name") ? ob.get("name").getAsString() : type.toString().toLowerCase();
        class_2487 tag = null;
        int c = 1;
        if (ob.has("count")) {
            c = ob.get("count").getAsInt();
        }
        if (ob.has("nbt")) {
            tag = class_2522.method_10718((String)ob.get("nbt").getAsString());
        }
        return new UniversalResource(type, new class_2960(name), c, tag);
    }

    public class_2487 toNBT() {
        class_2487 res = new class_2487();
        res.method_10582("name", this.item.toString());
        switch (this.type) {
            case item: {
                res.method_10582("type", "item");
                break;
            }
            case fluid: {
                res.method_10582("type", "fluid");
                break;
            }
            case itemtag: {
                res.method_10582("type", "tag");
            }
        }
        res.method_10569("count", this.count);
        if (this.data != null) {
            res.method_10566("nbt", (class_2520)this.data);
        }
        return res;
    }

    public static UniversalResource fromNBT(class_2487 tag) {
        class_2960 id = new class_2960(tag.method_10558("name"));
        Type type = Type.item;
        switch (tag.method_10558("type")) {
            case "fluid": {
                type = Type.fluid;
                break;
            }
            case "tag": {
                type = Type.itemtag;
                break;
            }
            case "fluidtag": {
                type = Type.fluidtag;
                break;
            }
            case "energy": {
                type = Type.energy;
                break;
            }
            case "time": {
                type = Type.time;
            }
        }
        int count = tag.method_10550("count");
        class_2487 extra = null;
        if (tag.method_10545("nbt")) {
            extra = tag.method_10562("nbt");
        }
        return new UniversalResource(type, id, count, extra);
    }

    public JsonObject serializer() {
        JsonObject res = new JsonObject();
        res.addProperty("name", this.item.toString());
        switch (this.type) {
            case item: {
                res.addProperty("type", "item");
                break;
            }
            case fluid: {
                res.addProperty("type", "fluid");
                break;
            }
            case itemtag: {
                res.addProperty("type", "tag");
                break;
            }
            case fluidtag: {
                res.addProperty("type", "fluidtag");
                break;
            }
            case energy: {
                res.addProperty("type", "energy");
                break;
            }
            case time: {
                res.addProperty("type", "time");
            }
        }
        res.addProperty("count", (Number)this.count);
        if (this.data != null) {
            res.addProperty("nbt", this.data.toString());
        }
        return res;
    }

    public static enum Type {
        item(true, false),
        fluid(false, true),
        itemtag(true, false),
        fluidtag(false, true),
        time(false, false),
        energy(false, false);

        public final boolean isFluid;
        public final boolean isItem;

        private Type(boolean isItem, boolean isFluid) {
            this.isItem = isItem;
            this.isFluid = isFluid;
        }
    }
}

