/*
 * Decompiled with CFR 0.152.
 */
package com.diamssword.greenresurgence.systems.faction;

import com.diamssword.greenresurgence.events.BaseEventCallBack;
import com.diamssword.greenresurgence.events.PlaceBlockCallback;
import com.diamssword.greenresurgence.network.AdventureInteract;
import com.diamssword.greenresurgence.network.Channels;
import com.diamssword.greenresurgence.network.CurrentZonePacket;
import com.diamssword.greenresurgence.systems.Components;
import com.diamssword.greenresurgence.systems.faction.perimeter.FactionList;
import com.diamssword.greenresurgence.systems.faction.perimeter.components.FactionGuild;
import com.diamssword.greenresurgence.systems.faction.perimeter.components.FactionMember;
import com.diamssword.greenresurgence.systems.faction.perimeter.components.FactionZone;
import com.diamssword.greenresurgence.systems.faction.perimeter.components.Perms;
import com.diamssword.greenresurgence.systems.faction.perimeter.components.SpecialPlacement;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.event.player.AttackBlockCallback;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1934;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_7922;
import net.minecraft.class_7923;

public class BaseInteractions {
    public static List<class_2248> allowedBlocks = new ArrayList<class_2248>();
    public static List<class_1792> allowedItems = new ArrayList<class_1792>();

    public static void registerBlocks() {
        allowedBlocks.clear();
        allowedItems.clear();
        allowedBlocks.add(class_2246.field_10102);
        allowedBlocks.add(class_2246.field_10161);
        allowedBlocks.add(class_2246.field_10149);
        allowedBlocks.add(class_2246.field_10034);
    }

    public static void register() {
        AttackBlockCallback.EVENT.register(BaseInteractions::destroyBlock);
        BaseEventCallBack.ENTER.register(BaseInteractions::onEnter);
        BaseEventCallBack.LEAVE.register(BaseInteractions::onLeave);
        PlaceBlockCallback.EVENT.register(BaseInteractions::placeBlock);
    }

    private static class_1269 placeBlock(class_1750 ctx, class_2680 state) {
        class_1657 class_16572;
        if (ctx.method_8036() != null && (class_16572 = ctx.method_8036()) instanceof class_3222) {
            class_3222 pl = (class_3222)class_16572;
            if (pl.field_13974.method_14257().equals((Object)class_1934.field_9215)) {
                FactionList list = (FactionList)ctx.method_8045().getComponent(Components.BASE_LIST);
                if (list.isAllowedAt((class_2382)ctx.method_8037(), new FactionMember((class_1657)pl), Perms.PLACE)) {
                    if (allowedBlocks.contains(state.method_26204())) {
                        Optional<FactionZone> terr;
                        SpecialPlacement sp = SpecialPlacement.REGISTRY.get(state.method_26204());
                        if (sp != null && (terr = list.getTerrainAt((class_2382)ctx.method_8037())).isPresent()) {
                            return sp.onPlacement(ctx.method_8036(), terr.get(), ctx.method_8037()) ? class_1269.field_5811 : class_1269.field_5814;
                        }
                        return class_1269.field_5811;
                    }
                    return class_1269.field_5814;
                }
                return class_1269.field_5814;
            }
        }
        return class_1269.field_5811;
    }

    public static AdventureInteract.AllowedList getPacket() {
        Stream<class_2960> l1 = allowedItems.stream().map(arg_0 -> ((class_7922)class_7923.field_41178).method_10221(arg_0));
        Stream<class_2960> l2 = allowedBlocks.stream().map(arg_0 -> ((class_7922)class_7923.field_41175).method_10221(arg_0));
        return new AdventureInteract.AllowedList(l2.toList().toArray(new class_2960[0]), l1.toList().toArray(new class_2960[0]));
    }

    public static void onEnter(class_3222 player, FactionGuild base) {
        player.method_7353((class_2561)class_2561.method_43470((String)("Vous entrez dans " + base.getName())), true);
        if (base.needSurvival(new FactionMember((class_1657)player))) {
            if (player.field_13974.method_14257().equals((Object)class_1934.field_9216)) {
                player.method_7336(class_1934.field_9215);
            }
            Channels.MAIN.serverHandle((class_1657)player).send((Record)CurrentZonePacket.from(base, (class_1657)player));
        }
    }

    public static boolean shouldOverlayBlock(class_2248 b) {
        return allowedBlocks.contains(b);
    }

    public static void onLeave(class_3222 player, FactionGuild base) {
        player.method_7353((class_2561)class_2561.method_43470((String)("Vous sortez de " + base.getName())), true);
        if (player.field_13974.method_14257().equals((Object)class_1934.field_9215)) {
            player.method_7336(class_1934.field_9216);
        }
    }

    public static class_1269 destroyBlock(class_1657 player, class_1937 w, class_1268 hand, class_2338 pos, class_2350 dir) {
        if (player instanceof class_3222) {
            class_3222 pl = (class_3222)player;
            if (pl.field_13974.method_14257().equals((Object)class_1934.field_9215)) {
                class_2248 st;
                FactionList list = (FactionList)w.getComponent(Components.BASE_LIST);
                if (list.isAllowedAt((class_2382)pos, new FactionMember((class_1657)pl), Perms.BREAK) && allowedBlocks.contains(st = w.method_8320(pos).method_26204())) {
                    Optional<FactionZone> terr;
                    SpecialPlacement sp = SpecialPlacement.REGISTRY.get(st);
                    if (sp != null && (terr = list.getTerrainAt((class_2382)pos)).isPresent()) {
                        return sp.onBreak(player, terr.get(), pos) ? class_1269.field_5811 : class_1269.field_5814;
                    }
                    return class_1269.field_5811;
                }
                return class_1269.field_5814;
            }
        } else if (w.field_9236 && !player.method_7337()) {
            if (CurrentZonePacket.currentZone != null) {
                for (FactionZone box : CurrentZonePacket.currentZone.zones) {
                    if (!box.getBounds().method_14662((class_2382)pos) || !allowedBlocks.contains(w.method_8320(pos).method_26204())) continue;
                    return class_1269.field_5811;
                }
            }
            return class_1269.field_5814;
        }
        return class_1269.field_5811;
    }

    public static boolean canUseItem(class_1657 player, class_1268 hand) {
        class_1792 st = player.method_5998(hand).method_7909();
        if (st instanceof class_1747) {
            class_1747 be = (class_1747)st;
            return allowedBlocks.contains(be.method_7711());
        }
        return allowedItems.contains(st);
    }
}

