/*
 * Decompiled with CFR 0.152.
 */
package com.diamssword.greenresurgence.systems.faction.perimeter;

import com.diamssword.greenresurgence.network.Channels;
import com.diamssword.greenresurgence.network.CurrentZonePacket;
import com.diamssword.greenresurgence.systems.faction.perimeter.components.FactionGuild;
import com.diamssword.greenresurgence.systems.faction.perimeter.components.FactionMember;
import com.diamssword.greenresurgence.systems.faction.perimeter.components.FactionZone;
import com.diamssword.greenresurgence.systems.faction.perimeter.components.Perms;
import dev.onyxstudios.cca.api.v3.component.tick.ServerTickingComponent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Stream;
import net.minecraft.class_1937;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3218;

public class FactionList
implements ServerTickingComponent {
    private final List<FactionGuild> guilds = new ArrayList<FactionGuild>();
    private final class_1937 provider;

    public FactionList(class_1937 provider) {
        this.provider = provider;
    }

    public List<FactionGuild> getAll() {
        return this.guilds;
    }

    public Map<UUID, String> getNames() {
        HashMap<UUID, String> res = new HashMap<UUID, String>();
        this.guilds.forEach(v -> res.put(v.getId(), v.getName()));
        return res;
    }

    public Optional<FactionGuild> getAt(class_2382 pos) {
        return this.guilds.stream().filter(b -> b.isIn(pos)).findFirst();
    }

    public Optional<FactionZone> getTerrainAt(class_2382 pos) {
        for (FactionGuild base : this.guilds) {
            Optional<FactionZone> b = base.getTerrainAt(pos);
            if (!b.isPresent()) continue;
            return b;
        }
        return Optional.empty();
    }

    public boolean isAllowedAt(class_2382 pos, FactionMember member, Perms perm) {
        Optional<FactionGuild> base = this.getAt(pos);
        return base.map(baseInstance -> baseInstance.isAllowed(member, perm)).orElse(false);
    }

    public boolean addGuild(FactionGuild guild) {
        if (this.guilds.stream().noneMatch(v -> v.getId().equals(guild.getId()))) {
            this.guilds.add(guild);
            guild.getOwner().asPlayer(this.provider).ifPresent(p -> {
                if (!p.method_37908().field_9236) {
                    CurrentZonePacket.sendDebugZone(this.provider, null);
                    Channels.MAIN.serverHandle(p).send((Record)new CurrentZonePacket.MyGuild(guild.getId(), guild.getName()));
                }
            });
            return true;
        }
        return false;
    }

    public boolean delete(UUID id) {
        Optional<FactionGuild> t = this.get(id);
        if (t.isPresent()) {
            this.guilds.remove(t.get());
            return true;
        }
        return false;
    }

    public Optional<FactionGuild> get(UUID id) {
        return this.guilds.stream().filter(v -> v.getId().equals(id)).findFirst();
    }

    public Optional<FactionGuild> getForPlayer(UUID playerID, boolean ownerOnly) {
        Stream<FactionGuild> ls = this.guilds.stream().filter(v -> v.getOwner().isPlayer() && v.getOwner().getId().equals(playerID));
        Optional<FactionGuild> f = ls.findFirst();
        if (f.isEmpty() && !ownerOnly) {
            f = this.guilds.stream().filter(v -> v.getMembers().contains(playerID)).findFirst();
        }
        return f;
    }

    public void readFromNbt(class_2487 tag) {
        class_2499 ls = tag.method_10554("guilds", 10);
        this.guilds.clear();
        ls.forEach(c -> {
            FactionGuild b = FactionGuild.fromNBT((class_2487)c);
            if (b != null) {
                this.guilds.add(b);
            }
        });
    }

    public void writeToNbt(class_2487 tag) {
        class_2499 ls = new class_2499();
        this.guilds.forEach(b -> {
            class_2487 t = new class_2487();
            b.writeNbt(t);
            ls.add((Object)t);
        });
        tag.method_10566("guilds", (class_2520)ls);
    }

    public void serverTick() {
        if (this.provider.method_8510() % 40L == 0L) {
            this.guilds.forEach(b -> b.tick((class_3218)this.provider));
        }
    }
}

