/*
 * Decompiled with CFR 0.152.
 */
package com.diamssword.greenresurgence.systems.faction.perimeter.components;

import com.diamssword.greenresurgence.events.BaseEventCallBack;
import com.diamssword.greenresurgence.network.Channels;
import com.diamssword.greenresurgence.network.CurrentZonePacket;
import com.diamssword.greenresurgence.systems.faction.perimeter.components.FactionMember;
import com.diamssword.greenresurgence.systems.faction.perimeter.components.FactionPerm;
import com.diamssword.greenresurgence.systems.faction.perimeter.components.FactionTerrainStorage;
import com.diamssword.greenresurgence.systems.faction.perimeter.components.FactionZone;
import com.diamssword.greenresurgence.systems.faction.perimeter.components.Perms;
import com.diamssword.greenresurgence.systems.faction.perimeter.components.TerrainEnergyStorage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

public class FactionGuild {
    private String name;
    private final UUID id;
    private FactionMember owner;
    private List<class_3222> inBase = new ArrayList<class_3222>();
    private final Map<String, FactionPerm> roles = new HashMap<String, FactionPerm>();
    private final Map<String, Integer> rolesPriority = new HashMap<String, Integer>();
    private String startingRole;
    private Map<FactionMember, String> members = new HashMap<FactionMember, String>();
    private final Map<FactionMember, FactionPerm> allies = new HashMap<FactionMember, FactionPerm>();
    private final List<FactionZone> terrains = new ArrayList<FactionZone>();
    public FactionTerrainStorage storage = new FactionTerrainStorage();
    public TerrainEnergyStorage energyStorage = new TerrainEnergyStorage();

    public UUID getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public FactionMember getOwner() {
        return this.owner;
    }

    public List<FactionMember> getMembers() {
        return this.members.keySet().stream().toList();
    }

    public boolean changeRole(FactionMember member, String role, class_1937 world) {
        if (this.roles.containsKey(role)) {
            this.members.put(member, role);
            this.onMemberUpdate(member, world);
        }
        return false;
    }

    public Map<FactionMember, String> getMembersAndRoles() {
        HashMap<FactionMember, String> m = new HashMap<FactionMember, String>();
        m.putAll(this.members);
        m.put(this.owner, "Chef");
        return m;
    }

    public Map<String, FactionPerm> getRoles() {
        return this.roles;
    }

    public Map<String, Integer> getRolesAndPriorities() {
        return this.rolesPriority;
    }

    public FactionPerm getRole(String name) {
        return this.roles.get(name);
    }

    public int getPriorityOfRole(String role) {
        return this.rolesPriority.getOrDefault(role, 1);
    }

    private void onMemberUpdate(FactionMember member, class_1937 world) {
        if (!world.field_9236 && member.isPlayer()) {
            member.asPlayer(world).ifPresent(v -> {
                CurrentZonePacket.sendDebugZone(world, v);
                Channels.MAIN.serverHandle(v).send((Record)new CurrentZonePacket.MyGuild(this.getId(), this.getName()));
            });
        }
    }

    public boolean replacePerm(String oldName, FactionPerm newPerm) {
        if (oldName.equals(newPerm.getName())) {
            this.roles.put(oldName, newPerm);
            return true;
        }
        if (!this.roles.containsKey(newPerm.getName())) {
            HashMap<FactionMember, String> list = new HashMap<FactionMember, String>();
            this.members.forEach((k, v) -> {
                if (v.equals(oldName)) {
                    list.put((FactionMember)k, newPerm.getName());
                } else {
                    list.put((FactionMember)k, (String)v);
                }
            });
            this.roles.put(newPerm.getName(), newPerm);
            this.rolesPriority.put(newPerm.getName(), this.rolesPriority.get(oldName));
            this.rolesPriority.remove(oldName);
            this.members = list;
            this.roles.remove(oldName);
            return true;
        }
        return false;
    }

    public boolean addMember(FactionMember member, String role, class_1937 world) {
        if (this.roles.containsKey(role) && !this.members.containsKey(member)) {
            this.members.put(member, role);
            this.onMemberUpdate(member, world);
            return true;
        }
        return false;
    }

    public void addZone(class_2338 center, int size, @Nullable class_1937 world) {
        this.terrains.add(new FactionZone(this, center, size));
        this.getOwner().asPlayer(world).ifPresent(p -> {
            if (!p.method_37908().field_9236) {
                CurrentZonePacket.sendDebugZone(p.method_37908(), null);
            }
        });
    }

    public static FactionGuild createForPlayer(class_1657 player, class_2338 pos) {
        FactionGuild r = new FactionGuild();
        r.owner = new FactionMember(player);
        r.terrains.add(new FactionZone(r, pos, 16));
        r.name = player.method_5477().getString() + "'s Claim" + r.getId().toString().substring(r.getId().toString().length() - 5);
        r.addDefaultRole();
        return r;
    }

    private void addDefaultRole() {
        this.startingRole = "Membre";
        FactionPerm f = new FactionPerm(this.startingRole);
        f.setPerm(Perms.BREAK, true);
        f.setPerm(Perms.PLACE, true);
        f.setPerm(Perms.INVENTORY, true);
        this.roles.put(this.startingRole, f);
        this.rolesPriority.put(this.startingRole, 1);
    }

    protected FactionGuild(UUID id) {
        this.id = id;
    }

    protected FactionGuild() {
        this.id = UUID.randomUUID();
    }

    public boolean isIn(class_2382 pos) {
        for (FactionZone b : this.terrains) {
            if (!b.isIn(pos)) continue;
            return true;
        }
        return false;
    }

    public List<FactionZone> getAllTerrains() {
        return this.terrains;
    }

    public Optional<FactionZone> getTerrainAt(class_2382 pos) {
        for (FactionZone b : this.terrains) {
            if (!b.isIn(pos)) continue;
            return Optional.of(b);
        }
        return Optional.empty();
    }

    public FactionPerm getPermsOf(FactionMember member) {
        if (this.owner.equals(member)) {
            return FactionPerm.ALL;
        }
        String p = this.members.get(member);
        if (p != null) {
            return this.roles.get(p);
        }
        FactionPerm p1 = this.allies.get(member);
        if (p1 != null) {
            return p1;
        }
        return FactionPerm.NONE;
    }

    public boolean needSurvival(FactionMember member) {
        if (this.owner.equals(member)) {
            return true;
        }
        String p = this.members.get(member);
        if (p != null) {
            return this.roles.get(p).needSurvival();
        }
        FactionPerm p1 = this.allies.get(member);
        if (p1 != null) {
            return p1.needSurvival();
        }
        return false;
    }

    public boolean isAllowed(FactionMember member, Perms perm) {
        if (this.owner.equals(member)) {
            return true;
        }
        String p = this.members.get(member);
        if (p != null) {
            return this.roles.get(p).isAllowed(perm);
        }
        FactionPerm p1 = this.allies.get(member);
        if (p1 != null) {
            return p1.isAllowed(perm);
        }
        return false;
    }

    public void tick(class_3218 world) {
        world.method_18456().forEach(p -> {
            if (this.inBase.contains(p)) {
                if (!this.isIn((class_2382)p.method_24515())) {
                    this.inBase.remove(p);
                    ((BaseEventCallBack)BaseEventCallBack.LEAVE.invoker()).enterOrLeave((class_3222)p, this);
                }
            } else if (this.isIn((class_2382)p.method_24515())) {
                this.inBase.add((class_3222)p);
                ((BaseEventCallBack)BaseEventCallBack.ENTER.invoker()).enterOrLeave((class_3222)p, this);
            }
        });
        this.inBase = new ArrayList<class_3222>(this.inBase.stream().filter(v -> !v.method_29504()).toList());
    }

    public String getStartingRole() {
        return this.startingRole;
    }

    public static FactionGuild fromNBT(class_2487 tag) {
        UUID id = tag.method_25926("id");
        if (id != null) {
            FactionGuild res = new FactionGuild(id);
            res.name = tag.method_10558("name");
            class_2499 ls = tag.method_10554("terrains", 10);
            ls.forEach(c -> {
                FactionZone b = new FactionZone(res, (class_2487)c);
                res.terrains.add(b);
            });
            res.owner = new FactionMember(tag.method_10562("owner"));
            class_2499 lsRoles = tag.method_10554("roles", 10);
            res.roles.clear();
            res.members.clear();
            res.rolesPriority.clear();
            for (class_2520 el : lsRoles) {
                FactionPerm perm = FactionPerm.fromNBT((class_2487)el);
                if (perm == null) continue;
                res.roles.put(perm.getName(), perm);
                res.rolesPriority.put(perm.getName(), ((class_2487)el).method_10550("priority"));
            }
            String br = tag.method_10558("defaultRole");
            res.startingRole = res.roles.containsKey(br) ? br : (String)res.roles.keySet().stream().findFirst().get();
            class_2487 ml = tag.method_10562("members");
            for (String k : ml.method_10541()) {
                if (!res.roles.containsKey(k)) continue;
                class_2499 tm = ml.method_10554(k, 10);
                tm.forEach(v -> res.members.put(new FactionMember((class_2487)v), k));
            }
            class_2499 lsAllies = tag.method_10554("allies", 10);
            res.allies.clear();
            lsAllies.forEach(v -> {
                class_2487 tc = (class_2487)v;
                res.allies.put(new FactionMember(tc.method_10562("member")), FactionPerm.fromNBT(tc.method_10562("perms")));
            });
            return res;
        }
        return null;
    }

    public void writeNbt(class_2487 tag) {
        tag.method_25927("id", this.id);
        tag.method_10582("name", this.name);
        class_2487 t3 = new class_2487();
        this.owner.writeNbt(t3);
        tag.method_10566("owner", (class_2520)t3);
        class_2499 zones = new class_2499();
        this.terrains.forEach(b -> {
            class_2487 tg = new class_2487();
            b.writeNbt(tg);
            zones.add((Object)tg);
        });
        tag.method_10566("terrains", (class_2520)zones);
        class_2487 t1 = new class_2487();
        this.storage.toNBT(t1);
        tag.method_10566("storage", (class_2520)t1);
        class_2487 t2 = new class_2487();
        this.energyStorage.toNBT(t2);
        tag.method_10566("energy", (class_2520)t1);
        class_2499 permLS = new class_2499();
        class_2487 memberLs = new class_2487();
        for (FactionPerm p : this.roles.values()) {
            class_2487 nb = p.toNBT();
            nb.method_10569("priority", this.rolesPriority.getOrDefault(p.getName(), 1).intValue());
            permLS.add((Object)nb);
            List<FactionMember> membs = this.getMembersWithRole(p.getName());
            if (membs.isEmpty()) continue;
            class_2499 ls = new class_2499();
            membs.forEach(c -> {
                class_2487 e = new class_2487();
                c.writeNbt(e);
                ls.add((Object)e);
            });
            memberLs.method_10566(p.getName(), (class_2520)ls);
        }
        tag.method_10566("roles", (class_2520)permLS);
        tag.method_10582("defaultRole", this.startingRole);
        tag.method_10566("members", (class_2520)memberLs);
        class_2499 lsAl = new class_2499();
        this.allies.forEach((k, v) -> {
            class_2487 e = new class_2487();
            class_2487 ne = new class_2487();
            k.writeNbt(ne);
            e.method_10566("member", (class_2520)ne);
            e.method_10566("perms", (class_2520)v.toNBT());
            lsAl.add((Object)e);
        });
        tag.method_10566("allies", (class_2520)lsAl);
    }

    public List<FactionMember> getMembersWithRole(String role) {
        ArrayList<FactionMember> res = new ArrayList<FactionMember>();
        this.members.forEach((a, b) -> {
            if (b.equals(role)) {
                res.add((FactionMember)a);
            }
        });
        return res;
    }

    public List<FactionMember> getMembersWithPerms(Perms ... perms) {
        ArrayList<FactionMember> m1 = new ArrayList<FactionMember>();
        this.roles.forEach((k, v) -> {
            if (v.isAllowed(perms)) {
                m1.addAll(this.getMembersWithRole((String)k));
            }
        });
        m1.add(this.owner);
        return m1;
    }

    public String getRoleFor(FactionMember m) {
        return this.members.get(m);
    }

    public boolean addRole(FactionPerm role) {
        if (!this.roles.containsKey(role.getName())) {
            this.roles.put(role.getName(), role);
            this.rolesPriority.put(role.getName(), 1);
            return true;
        }
        return false;
    }

    public boolean removeTerrainAt(class_2338 p, class_1937 world) {
        Optional<FactionZone> t = this.getTerrainAt((class_2382)p);
        return t.map(v -> {
            this.terrains.remove(t.get());
            this.getOwner().asPlayer(world).ifPresent(p1 -> {
                if (!p1.method_37908().field_9236) {
                    CurrentZonePacket.sendDebugZone(p1.method_37908(), null);
                }
            });
            return true;
        }).orElse(false);
    }
}

