package com.diamssword.greenresurgence;

import blue.endless.jankson.Jankson;
import io.wispforest.owo.config.ConfigWrapper;
import io.wispforest.owo.config.Option;
import io.wispforest.owo.util.Observable;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;

public class ResurgenceConfig extends ConfigWrapper<com.diamssword.greenresurgence.ConfigModel> {

    public final Keys keys = new Keys();

    private final Option<java.lang.Integer> serverOptions_cooldowns_respawnLootedBlockInSec = this.optionForKey(this.keys.serverOptions_cooldowns_respawnLootedBlockInSec);
    private final Option<java.lang.Integer> serverOptions_cooldowns_respawnGroundLootInSec = this.optionForKey(this.keys.serverOptions_cooldowns_respawnGroundLootInSec);
    private final Option<java.lang.Integer> serverOptions_cooldowns_respawnShelvesLootInSec = this.optionForKey(this.keys.serverOptions_cooldowns_respawnShelvesLootInSec);
    private final Option<java.lang.Integer> serverOptions_cooldowns_respawnCrumbelingBlockInSec = this.optionForKey(this.keys.serverOptions_cooldowns_respawnCrumbelingBlockInSec);
    private final Option<java.lang.Integer> serverOptions_cooldowns_deployableExpireInSec = this.optionForKey(this.keys.serverOptions_cooldowns_deployableExpireInSec);

    private ResurgenceConfig() {
        super(com.diamssword.greenresurgence.ConfigModel.class);
    }

    private ResurgenceConfig(Consumer<Jankson.Builder> janksonBuilder) {
        super(com.diamssword.greenresurgence.ConfigModel.class, janksonBuilder);
    }

    public static ResurgenceConfig createAndLoad() {
        var wrapper = new ResurgenceConfig();
        wrapper.load();
        return wrapper;
    }

    public static ResurgenceConfig createAndLoad(Consumer<Jankson.Builder> janksonBuilder) {
        var wrapper = new ResurgenceConfig(janksonBuilder);
        wrapper.load();
        return wrapper;
    }

    public final ServerOptions serverOptions = new ServerOptions();
    public class ServerOptions implements Server {
        public final Cooldowns_ cooldowns = new Cooldowns_();
        public class Cooldowns_ implements Cooldowns {
            public int respawnLootedBlockInSec() {
                return serverOptions_cooldowns_respawnLootedBlockInSec.value();
            }

            public void respawnLootedBlockInSec(int value) {
                serverOptions_cooldowns_respawnLootedBlockInSec.set(value);
            }

            public int respawnGroundLootInSec() {
                return serverOptions_cooldowns_respawnGroundLootInSec.value();
            }

            public void respawnGroundLootInSec(int value) {
                serverOptions_cooldowns_respawnGroundLootInSec.set(value);
            }

            public int respawnShelvesLootInSec() {
                return serverOptions_cooldowns_respawnShelvesLootInSec.value();
            }

            public void respawnShelvesLootInSec(int value) {
                serverOptions_cooldowns_respawnShelvesLootInSec.set(value);
            }

            public int respawnCrumbelingBlockInSec() {
                return serverOptions_cooldowns_respawnCrumbelingBlockInSec.value();
            }

            public void respawnCrumbelingBlockInSec(int value) {
                serverOptions_cooldowns_respawnCrumbelingBlockInSec.set(value);
            }

            public int deployableExpireInSec() {
                return serverOptions_cooldowns_deployableExpireInSec.value();
            }

            public void deployableExpireInSec(int value) {
                serverOptions_cooldowns_deployableExpireInSec.set(value);
            }

        }
    }
    public interface Server {
    }
    public interface Cooldowns {
        int respawnLootedBlockInSec();
        void respawnLootedBlockInSec(int value);
        int respawnGroundLootInSec();
        void respawnGroundLootInSec(int value);
        int respawnShelvesLootInSec();
        void respawnShelvesLootInSec(int value);
        int respawnCrumbelingBlockInSec();
        void respawnCrumbelingBlockInSec(int value);
        int deployableExpireInSec();
        void deployableExpireInSec(int value);
    }
    public static class Keys {
        public final Option.Key serverOptions_cooldowns_respawnLootedBlockInSec = new Option.Key("serverOptions.cooldowns.respawnLootedBlockInSec");
        public final Option.Key serverOptions_cooldowns_respawnGroundLootInSec = new Option.Key("serverOptions.cooldowns.respawnGroundLootInSec");
        public final Option.Key serverOptions_cooldowns_respawnShelvesLootInSec = new Option.Key("serverOptions.cooldowns.respawnShelvesLootInSec");
        public final Option.Key serverOptions_cooldowns_respawnCrumbelingBlockInSec = new Option.Key("serverOptions.cooldowns.respawnCrumbelingBlockInSec");
        public final Option.Key serverOptions_cooldowns_deployableExpireInSec = new Option.Key("serverOptions.cooldowns.deployableExpireInSec");
    }
}

