/*
 * Decompiled with CFR 0.152.
 */
package com.tom.createores;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.tom.createores.COECommand;
import com.tom.createores.Config;
import com.tom.createores.ForgeConfig;
import com.tom.createores.OreDataAttachment;
import com.tom.createores.OreVeinGenerator;
import com.tom.createores.Registration;
import com.tom.createores.client.CCClientInit;
import com.tom.createores.client.ClientRegistration;
import com.tom.createores.components.OreVeinAtlasDataComponent;
import com.tom.createores.jm.JMEventListener;
import com.tom.createores.network.NetworkHandler;
import com.tom.createores.recipe.DrillingRecipe;
import com.tom.createores.recipe.ExtractorRecipe;
import com.tom.createores.recipe.VeinRecipe;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.event.lifecycle.InterModEnqueueEvent;
import net.neoforged.fml.event.lifecycle.InterModProcessEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.TagsUpdatedEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import org.slf4j.Logger;

@Mod(value="createoreexcavation")
public class CreateOreExcavation {
    public static final String MODID = "createoreexcavation";
    public static final Logger LOGGER = LogUtils.getLogger();
    private static CreateRegistrate registrate;
    public static boolean journeyMap;
    private static final DeferredRegister<RecipeSerializer<?>> RECIPE_SERIALIZER;
    private static final DeferredRegister<RecipeType<?>> TYPE_REGISTER;
    private static final DeferredRegister<AttachmentType<?>> ATTACHMENT_TYPES;
    private static final DeferredRegister.DataComponents DATA_COMPONENTS;
    public static final RecipeTypeGroup<DrillingRecipe> DRILLING_RECIPES;
    public static final RecipeTypeGroup<ExtractorRecipe> EXTRACTING_RECIPES;
    public static final RecipeTypeGroup<VeinRecipe> VEIN_RECIPES;
    public static final TagKey<Item> DRILL_TAG;
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<OreVeinAtlasDataComponent>> ORE_VEIN_ATLAS_DATA_COMPONENT;
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Boolean>> ORE_VEIN_FINDER_FILTERED_COMPONENT;
    public static final Supplier<AttachmentType<OreDataAttachment>> ORE_DATA;

    public CreateOreExcavation(ModContainer mc, IEventBus bus) {
        bus.addListener(this::setup);
        bus.addListener(this::doClientStuff);
        bus.addListener(this::enqueueIMC);
        bus.addListener(this::processIMC);
        bus.addListener(this::registerCapabilities);
        registrate = CreateRegistrate.create((String)MODID).registerEventListeners(bus);
        mc.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.commonSpec);
        mc.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)Config.serverSpec);
        bus.register(ForgeConfig.class);
        bus.register(NetworkHandler.class);
        journeyMap = ModList.get().isLoaded("journeymap");
        if (CreateOreExcavation.isModLoaded("computercraft") && FMLEnvironment.dist == Dist.CLIENT) {
            CCClientInit.init(bus);
        }
        NeoForge.EVENT_BUS.register((Object)this);
        Registration.register();
        RECIPE_SERIALIZER.register(bus);
        TYPE_REGISTER.register(bus);
        ATTACHMENT_TYPES.register(bus);
        DATA_COMPONENTS.register(bus);
    }

    private static <T extends Recipe<?>> RecipeTypeGroup<T> recipe(String name, Supplier<RecipeSerializer<T>> serializer) {
        RecipeTypeGroup rg = new RecipeTypeGroup(ResourceLocation.tryBuild((String)MODID, (String)name));
        rg.recipeType = TYPE_REGISTER.register(name, () -> RecipeType.simple((ResourceLocation)ResourceLocation.tryBuild((String)MODID, (String)name)));
        rg.serializer = RECIPE_SERIALIZER.register(name, serializer);
        return rg;
    }

    private void setup(FMLCommonSetupEvent event) {
        LOGGER.info("Create Ore Excavation starting");
        Registration.postRegister();
        COECommand.init();
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        event.enqueueWork(ClientRegistration::register);
        if (journeyMap) {
            JMEventListener.register();
        }
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
    }

    private void processIMC(InterModProcessEvent event) {
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
    }

    @SubscribeEvent
    public void registerCommands(RegisterCommandsEvent evt) {
        COECommand.register(evt);
    }

    @SubscribeEvent
    public void reloadEvent(TagsUpdatedEvent evt) {
        OreVeinGenerator.invalidate();
    }

    public static CreateRegistrate registrate() {
        return registrate;
    }

    public static boolean isModLoaded(String id) {
        return ModList.get().isLoaded(id);
    }

    private void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)Registration.IO_TILE.get(), (be, side) -> (IItemHandler)be.getCapability(Capabilities.ItemHandler.BLOCK, (Direction)side));
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)Registration.IO_TILE.get(), (be, side) -> (IFluidHandler)be.getCapability(Capabilities.FluidHandler.BLOCK, (Direction)side));
        event.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, (BlockEntityType)Registration.IO_TILE.get(), (be, side) -> (IEnergyStorage)be.getCapability(Capabilities.EnergyStorage.BLOCK, (Direction)side));
    }

    static {
        RECIPE_SERIALIZER = DeferredRegister.create((ResourceKey)Registries.RECIPE_SERIALIZER, (String)MODID);
        TYPE_REGISTER = DeferredRegister.create((ResourceKey)Registries.RECIPE_TYPE, (String)MODID);
        ATTACHMENT_TYPES = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.ATTACHMENT_TYPES, (String)MODID);
        DATA_COMPONENTS = DeferredRegister.createDataComponents((ResourceKey)Registries.DATA_COMPONENT_TYPE, (String)MODID);
        DRILLING_RECIPES = CreateOreExcavation.recipe("drilling", DrillingRecipe.Serializer::new);
        EXTRACTING_RECIPES = CreateOreExcavation.recipe("extracting", ExtractorRecipe.Serializer::new);
        VEIN_RECIPES = CreateOreExcavation.recipe("vein", VeinRecipe.Serializer::new);
        DRILL_TAG = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.tryBuild((String)MODID, (String)"drills"));
        ORE_VEIN_ATLAS_DATA_COMPONENT = DATA_COMPONENTS.register("ore_vein_altas_data", () -> DataComponentType.builder().persistent(OreVeinAtlasDataComponent.CODEC).build());
        ORE_VEIN_FINDER_FILTERED_COMPONENT = DATA_COMPONENTS.register("ore_vein_finder_filtered", () -> DataComponentType.builder().persistent((Codec)Codec.BOOL).build());
        ORE_DATA = ATTACHMENT_TYPES.register("ore_vein", () -> AttachmentType.serializable(OreDataAttachment::new).build());
    }

    public static class RecipeTypeGroup<T extends Recipe<?>> {
        private DeferredHolder<RecipeSerializer<?>, RecipeSerializer<T>> serializer;
        private DeferredHolder<RecipeType<?>, RecipeType<T>> recipeType;
        private ResourceLocation id;

        public RecipeTypeGroup(ResourceLocation id) {
            this.id = id;
        }

        public RecipeType<T> getRecipeType() {
            return (RecipeType)this.recipeType.get();
        }

        public RecipeSerializer<T> getSerializer() {
            return (RecipeSerializer)this.serializer.get();
        }

        public ResourceLocation getId() {
            return this.id;
        }
    }
}

