/*
 * Decompiled with CFR 0.152.
 */
package com.tom.createores.block.entity;

import com.tom.createores.CreateOreExcavation;
import com.tom.createores.block.entity.ExcavatingBlockEntityImpl;
import com.tom.createores.recipe.ExtractorRecipe;
import com.tom.createores.util.IOBlockType;
import com.tom.createores.util.TooltipUtil;
import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import io.github.fabricators_of_create.porting_lib.transfer.fluid.FluidTank;
import java.util.List;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3956;

public class ExtractorBlockEntity
extends ExcavatingBlockEntityImpl<ExtractorRecipe> {
    private Tank fluidTankOut = new Tank();

    public ExtractorBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    @Override
    public <T> Storage<T> getCaps(IOBlockType type) {
        if (type == IOBlockType.FLUID_IN) {
            return this.fluidTank;
        }
        if (type == IOBlockType.FLUID_OUT) {
            return this.fluidTankOut;
        }
        return null;
    }

    @Override
    protected boolean canExtract() {
        return super.canExtract() && this.fluidTankOut.fillInternal(((ExtractorRecipe)this.current).getOutput(), true) == ((ExtractorRecipe)this.current).getOutput().getAmount();
    }

    @Override
    protected void onFinished() {
        this.fluidTankOut.fillInternal(((ExtractorRecipe)this.current).getOutput(), false);
        super.onFinished();
    }

    @Override
    protected void read(class_2487 tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        this.fluidTankOut.readFromNBT(tag.method_10562("tank"));
    }

    @Override
    protected void write(class_2487 tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        tag.method_10566("tank", (class_2520)this.fluidTankOut.writeToNBT(new class_2487()));
    }

    @Override
    public boolean addToGoggleTooltip(List<class_2561> tooltip, boolean isPlayerSneaking) {
        super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        TooltipUtil.forGoggles(tooltip, class_2561.method_43471((String)"info.coe.extractor.output"));
        this.containedFluidTooltip(tooltip, isPlayerSneaking, (Storage)this.fluidTankOut);
        return true;
    }

    @Override
    protected class_3956<ExtractorRecipe> getRecipeType() {
        return CreateOreExcavation.EXTRACTING_RECIPES.getRecipeType();
    }

    @Override
    protected String getTankInName() {
        return "tankIn";
    }

    private class Tank
    extends FluidTank {
        public Tank() {
            super(1296000L);
        }

        protected void onContentsChanged() {
            ExtractorBlockEntity.this.notifyUpdate();
        }

        public long insert(FluidVariant insertedVariant, long maxAmount, TransactionContext transaction) {
            return 0L;
        }

        public long fillInternal(FluidStack resource, boolean simulate) {
            long f;
            try (Transaction t = Transaction.openOuter();){
                f = super.insert(resource.getType(), resource.getAmount(), (TransactionContext)t);
                if (simulate) {
                    t.abort();
                } else {
                    t.commit();
                }
            }
            return f;
        }
    }
}

