/*
 * Decompiled with CFR 0.152.
 */
package com.tom.createores.block.entity;

import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.api.equipment.goggles.IHaveHoveringInformation;
import com.simibubi.create.content.equipment.armor.BacktankBlockEntity;
import com.simibubi.create.foundation.blockEntity.ComparatorUtil;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.tom.createores.OreDataCapability;
import com.tom.createores.Registration;
import com.tom.createores.block.entity.IDrill;
import com.tom.createores.client.ClientUtil;
import com.tom.createores.item.OreVeinAtlasItem;
import com.tom.createores.recipe.VeinRecipe;
import com.tom.createores.util.DimChunkPos;
import com.tom.createores.util.NumberFormatter;
import com.tom.createores.util.TooltipUtil;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1863;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3532;

public class SampleDrillBlockEntity
extends SmartBlockEntity
implements IHaveGoggleInformation,
IHaveHoveringInformation,
IDrill {
    public static final int DRILL_TIME = 200;
    private class_2960 veinClient;
    private long resourceRemClient;
    private VeinRecipe vein;
    private OreDataCapability.OreData data;
    private int progress = 0;
    private boolean drilling = false;
    private float airTankLevel = -1.0f;

    public SampleDrillBlockEntity(class_2591<?> typeIn, class_2338 pos, class_2680 state) {
        super(typeIn, pos, state);
        this.setLazyTickRate(20);
    }

    public boolean addToGoggleTooltip(List<class_2561> tooltip, boolean isPlayerSneaking) {
        VeinRecipe veinR = this.veinClient != null ? (VeinRecipe)this.field_11863.method_8433().method_8130(this.veinClient).filter(e -> e instanceof VeinRecipe).map(r -> (VeinRecipe)r).orElse(null) : null;
        class_2561 vein = veinR != null ? veinR.getName() : class_2561.method_43471((String)"chat.coe.veinFinder.nothing");
        TooltipUtil.forGoggles(tooltip, class_2561.method_43469((String)"chat.coe.veinFinder.found", (Object[])new Object[]{vein}));
        if (!this.field_11863.method_8320(this.field_11867.method_10074()).method_26234((class_1922)this.field_11863, this.field_11867.method_10074())) {
            TooltipUtil.forGoggles(tooltip, class_2561.method_43471((String)"info.coe.drill.noGround"));
        }
        if (this.drilling) {
            if (this.progress < 200) {
                TooltipUtil.forGoggles(tooltip, class_2561.method_43471((String)"info.coe.drill.progress").method_27693(": [").method_10852(ClientUtil.makeProgressBar((float)this.progress / 200.0f)).method_27693("]"));
            } else {
                TooltipUtil.forGoggles(tooltip, class_2561.method_43471((String)"info.coe.sample_drill.done"));
            }
        } else if (this.airTankLevel > 0.2f) {
            TooltipUtil.forGoggles(tooltip, class_2561.method_43471((String)"info.coe.sample_drill.click_to_start"));
        }
        if (this.resourceRemClient != 0L) {
            TooltipUtil.forGoggles(tooltip, class_2561.method_43469((String)"info.coe.drill.resourceRemaining", (Object[])new Object[]{NumberFormatter.formatNumber(this.resourceRemClient)}));
        }
        if (this.airTankLevel < 0.0f) {
            TooltipUtil.forGoggles(tooltip, class_2561.method_43471((String)"info.coe.sample_drill.no_air"));
        } else if (this.airTankLevel < 0.21f) {
            TooltipUtil.forGoggles(tooltip, class_2561.method_43471((String)"info.coe.sample_drill.low_air"));
        } else {
            TooltipUtil.forGoggles(tooltip, class_2561.method_43471((String)"info.coe.sample_drill.air").method_27693(": [").method_10852(ClientUtil.makeProgressBar(this.airTankLevel)).method_27693("]"));
        }
        return true;
    }

    private void updateVein() {
        class_1923 p = new class_1923(this.field_11867);
        this.data = OreDataCapability.getData(this.field_11863.method_8497(p.field_9181, p.field_9180));
        class_1863 m = this.field_11863.method_8433();
        if (this.data != null) {
            this.vein = this.data.getRecipe(m);
        }
    }

    public void tick() {
        class_2586 be;
        super.tick();
        if (!this.field_11863.field_9236 && this.drilling && this.progress < 200 && this.field_11863.method_8320(this.field_11867.method_10074()).method_26234((class_1922)this.field_11863, this.field_11867.method_10074()) && (be = this.field_11863.method_8321(this.field_11867.method_10084())) instanceof BacktankBlockEntity) {
            BacktankBlockEntity t = (BacktankBlockEntity)be;
            int air = t.getAirLevel();
            if (t.getComparatorOutput() > ComparatorUtil.fractionToRedstoneLevel((double)0.2f)) {
                int op = class_3532.method_15340((int)(air / 80), (int)1, (int)4);
                t.setAirLevel(air - op);
                this.progress += op;
                this.notifyUpdate();
            }
        }
    }

    public void lazyTick() {
        if (this.field_11863.field_9236) {
            return;
        }
        this.updateVein();
        class_2586 be = this.field_11863.method_8321(this.field_11867.method_10084());
        if (be instanceof BacktankBlockEntity) {
            BacktankBlockEntity t = (BacktankBlockEntity)be;
            this.airTankLevel = (float)t.getComparatorOutput() / (float)ComparatorUtil.fractionToRedstoneLevel((double)1.0);
        } else {
            this.airTankLevel = -1.0f;
        }
        this.notifyUpdate();
    }

    protected void write(class_2487 compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.method_10569("progress", this.progress);
        compound.method_10556("drilling", this.drilling);
        if (clientPacket) {
            if (this.vein != null) {
                compound.method_10582("veinId", this.vein.method_8114().toString());
                compound.method_10544("resRem", this.data.getResourcesRemaining(this.vein));
            }
            compound.method_10548("air", this.airTankLevel);
        }
    }

    protected void read(class_2487 compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.progress = compound.method_10550("progress");
        this.drilling = compound.method_10577("drilling");
        if (clientPacket) {
            if (compound.method_10545("veinId")) {
                this.veinClient = new class_2960(compound.method_10558("veinId"));
                this.resourceRemClient = compound.method_10537("resRem");
            } else {
                this.veinClient = null;
            }
            this.airTankLevel = compound.method_10583("air");
        }
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    public void clicked(class_1657 player) {
        if (this.progress >= 200) {
            if (this.vein == null) {
                player.method_7353((class_2561)class_2561.method_43469((String)"chat.coe.veinFinder.found", (Object[])new Object[]{class_2561.method_43471((String)"chat.coe.veinFinder.nothing")}), true);
            } else {
                class_1799 is = player.method_6047();
                if (is.method_7909() == Registration.VEIN_ATLAS_ITEM.get()) {
                    ((OreVeinAtlasItem)Registration.VEIN_ATLAS_ITEM.get()).addVein(player, is, this.vein, new DimChunkPos(this.field_11863, this.field_11867), this.data.getRandomMul());
                    return;
                }
                player.method_7353((class_2561)class_2561.method_43471((String)"chat.coe.sampleDrill.noAtlas"), true);
            }
        } else if (!this.drilling) {
            if (this.airTankLevel > 0.2f) {
                this.progress = 0;
                this.drilling = true;
                player.method_7353((class_2561)class_2561.method_43471((String)"chat.coe.sampleDrill.start"), true);
            } else if (this.airTankLevel < 0.0f) {
                player.method_7353((class_2561)class_2561.method_43471((String)"chat.coe.sampleDrill.noAir"), true);
            } else {
                player.method_7353((class_2561)class_2561.method_43471((String)"chat.coe.sampleDrill.lowAir"), true);
            }
        } else {
            player.method_7353((class_2561)class_2561.method_43471((String)"chat.coe.sampleDrill.running"), true);
        }
    }

    @Override
    public class_1799 getDrill() {
        return Registration.NORMAL_DRILL_ITEM.asStack();
    }

    @Override
    public class_2338 getBelow() {
        return this.field_11867.method_10074();
    }

    @Override
    public class_2350 getFacing() {
        return class_2350.field_11035;
    }

    @Override
    public boolean shouldRenderRubble() {
        return this.progress > 0;
    }

    @Override
    public float getYOffset() {
        return 1.7f;
    }

    @Override
    public float getDrillOffset() {
        return this.progress >= 200 ? 0.0f : (float)this.progress / 200.0f * 0.5f;
    }

    @Override
    public float getRotation() {
        if (this.progress >= 200) {
            return 0.0f;
        }
        if (this.progress > 0 && this.airTankLevel > 0.2f) {
            long ticks = this.method_10997().method_8510();
            float rot = ticks * 20L % 360L;
            return rot;
        }
        return 0.0f;
    }

    @Override
    public float getPrevRotation() {
        if (this.progress >= 200) {
            return 0.0f;
        }
        if (this.progress > 0 && this.airTankLevel > 0.2f) {
            long ticks = this.method_10997().method_8510() - 1L;
            float rot = ticks * 20L % 360L;
            return rot;
        }
        return 0.0f;
    }

    @Override
    public boolean shouldRenderShaft() {
        return (float)this.progress / 200.0f > 0.5f && this.progress < 200;
    }

    public void setDrilling(boolean drilling) {
        this.drilling = drilling;
    }

    public void setProgress(int progress) {
        this.progress = progress;
    }

    public void setAirTankLevel(float airTankLevel) {
        this.airTankLevel = airTankLevel;
    }
}

