/*
 * Decompiled with CFR 0.152.
 */
package com.tom.createores.jm;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.tom.createores.CreateOreExcavation;
import com.tom.createores.Registration;
import com.tom.createores.jm.OreDistanceInfo;
import com.tom.createores.jm.OreNearbyInfo;
import com.tom.createores.jm.OreVeinInfo;
import com.tom.createores.recipe.VeinRecipe;
import com.tom.createores.util.DimChunkPos;
import java.io.File;
import java.io.FileReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import journeymap.client.api.IClientAPI;
import journeymap.client.api.display.Displayable;
import journeymap.client.api.display.IThemeButton;
import journeymap.client.api.display.PolygonOverlay;
import net.minecraft.class_1799;
import net.minecraft.class_1863;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5321;
import net.minecraft.class_638;
import net.minecraft.class_7924;

public enum OreVeinsOverlay {
    INSTANCE;

    private static final Gson gson;
    private IClientAPI api;
    private Map<DimChunkPos, OreVeinInfo> chunkDataLegacy = new HashMap<DimChunkPos, OreVeinInfo>();
    private Map<DimChunkPos, OreVeinInfo> chunkDataAtlas = new HashMap<DimChunkPos, OreVeinInfo>();
    private Map<DimChunkPos, PolygonOverlay> chunkOverlays = new HashMap<DimChunkPos, PolygonOverlay>();
    private List<OreDistanceInfo> oreDistanceInfos = new ArrayList<OreDistanceInfo>();
    private List<OreNearbyInfo> oreNearbyInfos = new ArrayList<OreNearbyInfo>();
    private final class_310 mc = class_310.method_1551();
    private boolean activated = true;

    public void setApi(IClientAPI api) {
        this.api = api;
    }

    public void onMappingStarted() {
        class_638 level = this.mc.field_1687;
        if (level == null) {
            return;
        }
        File modFolder = this.api.getDataPath("createoreexcavation");
        File veins = new File(modFolder, "veins.json");
        if (veins.exists()) {
            class_1863 mngr = class_310.method_1551().method_1562().method_2877();
            try (FileReader rd = new FileReader(veins);){
                Map root = (Map)gson.fromJson((Reader)rd, Object.class);
                root.getOrDefault("veins", Collections.emptyList()).forEach(dimMap -> {
                    class_2960 dimKey = new class_2960((String)dimMap.get("dim"));
                    class_5321 lvl = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)dimKey);
                    dimMap.getOrDefault("veins", Collections.emptyList()).forEach(vein -> {
                        int x = ((Number)vein.get("x")).intValue();
                        int z = ((Number)vein.get("z")).intValue();
                        class_2960 key = new class_2960((String)vein.get("id"));
                        VeinRecipe v = mngr.method_8130(key).filter(r -> r instanceof VeinRecipe).map(r -> (VeinRecipe)r).orElse(null);
                        if (v != null) {
                            DimChunkPos p = new DimChunkPos((class_5321<class_1937>)lvl, x, z);
                            this.chunkDataLegacy.put(p, new OreVeinInfo(p, v, true));
                        }
                    });
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.chunkDataLegacy.forEach((k, data) -> {
            if (!k.dimension.equals((Object)level.method_27983())) {
                return;
            }
            this.showOverlay((Displayable)data.getOverlay());
            this.chunkOverlays.put((DimChunkPos)k, data.getOverlay());
        });
    }

    public void showOverlay(Displayable overlay) {
        try {
            this.api.show(overlay);
        }
        catch (Throwable t) {
            CreateOreExcavation.LOGGER.error(String.valueOf(t));
        }
    }

    public void showOverlays(Collection<? extends Displayable> overlays) {
        overlays.forEach(this::showOverlay);
    }

    public void removeOverlays(Collection<? extends Displayable> overlays) {
        overlays.forEach(o -> this.api.remove(o));
    }

    public void onMappingStopped() {
        File modFolder = this.api.getDataPath("createoreexcavation");
        File veins = new File(modFolder, "veins.json");
        modFolder.mkdirs();
        try {
            HashMap<class_2960, List> dimMap = new HashMap<class_2960, List>();
            this.chunkDataLegacy.forEach((k, v) -> {
                HashMap<String, Object> m = new HashMap<String, Object>();
                m.put("x", k.x);
                m.put("z", k.z);
                m.put("id", v.id.toString());
                dimMap.computeIfAbsent(k.dimension.method_29177(), __ -> new ArrayList()).add(m);
            });
            HashMap root = new HashMap();
            ArrayList vs = new ArrayList();
            root.put("veins", vs);
            dimMap.forEach((k, v) -> {
                HashMap<String, Object> d = new HashMap<String, Object>();
                vs.add(d);
                d.put("dim", k.toString());
                d.put("veins", v);
            });
            try (PrintWriter w = new PrintWriter(veins);){
                gson.toJson(root, (Appendable)w);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.chunkDataLegacy.clear();
        this.chunkDataAtlas.clear();
        this.chunkOverlays.clear();
        this.oreDistanceInfos.clear();
        this.oreNearbyInfos.clear();
    }

    private void toggleOverlay() {
        if (this.isActivated()) {
            this.removeOverlays(this.chunkOverlays.values());
            this.oreDistanceInfos.forEach(e -> this.api.remove((Displayable)e.getOverlay()));
            this.oreNearbyInfos.forEach(e -> this.api.remove((Displayable)e.getOverlay()));
        } else {
            this.showOverlays(this.chunkOverlays.values());
            this.oreDistanceInfos.forEach(e -> this.showOverlay((Displayable)e.getOverlay()));
            this.oreNearbyInfos.forEach(e -> this.showOverlay((Displayable)e.getOverlay()));
        }
        this.activated = !this.isActivated();
    }

    public boolean isActivated() {
        return this.activated;
    }

    public void toggle(IThemeButton button) {
        this.toggleOverlay();
        button.setToggled(Boolean.valueOf(this.activated));
    }

    public void setVeinInfo(class_1923 posIn, class_2960 id) {
        class_1863 mngr;
        VeinRecipe vein;
        DimChunkPos pos = new DimChunkPos((class_1937)this.mc.field_1687, posIn);
        if (this.chunkDataLegacy.containsKey(pos)) {
            PolygonOverlay ov = this.chunkOverlays.remove(pos);
            if (this.activated && ov != null) {
                this.api.remove((Displayable)ov);
            }
        }
        if ((vein = (VeinRecipe)(mngr = class_310.method_1551().method_1562().method_2877()).method_8130(id).filter(r -> r instanceof VeinRecipe).map(r -> (VeinRecipe)r).orElse(null)) != null) {
            OreVeinInfo info = new OreVeinInfo(pos, vein, true);
            this.chunkDataLegacy.put(pos, info);
            if (this.activated) {
                this.showOverlay((Displayable)info.getOverlay());
            }
            this.chunkOverlays.put(pos, info.getOverlay());
        }
    }

    public void addVeinNearbyInfo(class_1923 center, class_2960 id) {
        if (this.oreDistanceInfos.size() > 2) {
            OreDistanceInfo ov = this.oreDistanceInfos.remove(0);
            if (this.activated && ov != null) {
                this.api.remove((Displayable)ov.getOverlay());
            }
        }
        long time = this.mc.field_1687.method_8510();
        class_1863 mngr = class_310.method_1551().method_1562().method_2877();
        VeinRecipe vein = mngr.method_8130(id).filter(r -> r instanceof VeinRecipe).map(r -> (VeinRecipe)r).orElse(null);
        if (vein != null) {
            OreNearbyInfo v = new OreNearbyInfo((class_5321<class_1937>)this.mc.field_1687.method_27983(), center, vein, time + 600L);
            this.oreNearbyInfos.add(v);
            if (this.activated) {
                this.showOverlay((Displayable)v.getOverlay());
            }
        }
    }

    public void addVeinDistanceInfo(class_2338 center, int radius, class_2960 id) {
        if (this.oreDistanceInfos.size() > 2) {
            OreDistanceInfo ov = this.oreDistanceInfos.remove(0);
            if (this.activated && ov != null) {
                this.api.remove((Displayable)ov.getOverlay());
            }
        }
        long time = this.mc.field_1687.method_8510();
        class_1863 mngr = class_310.method_1551().method_1562().method_2877();
        VeinRecipe vein = mngr.method_8130(id).filter(r -> r instanceof VeinRecipe).map(r -> (VeinRecipe)r).orElse(null);
        if (vein != null) {
            OreDistanceInfo v = new OreDistanceInfo((class_5321<class_1937>)this.mc.field_1687.method_27983(), center, radius, vein, time + 600L);
            this.oreDistanceInfos.add(v);
            if (this.activated) {
                this.showOverlay((Displayable)v.getOverlay());
            }
        }
    }

    public void tick() {
        if (this.mc.field_1687 == null) {
            return;
        }
        long time = this.mc.field_1687.method_8510();
        if (time % 20L == 0L && this.isActivated()) {
            class_1799 atlas = class_1799.field_8037;
            int c = this.mc.field_1724.method_31548().method_5439();
            for (int i2 = 0; i2 < c; ++i2) {
                class_1799 is = this.mc.field_1724.method_31548().method_5438(i2);
                if (is.method_7909() != Registration.VEIN_ATLAS_ITEM.get()) continue;
                atlas = is;
                break;
            }
            HashSet<DimChunkPos> found = new HashSet<DimChunkPos>();
            if (!atlas.method_7960() && atlas.method_7969() != null) {
                class_2499 veins = atlas.method_7969().method_10554("veins", 10);
                for (int i3 = 0; i3 < veins.size(); ++i3) {
                    class_2487 v = veins.method_10602(i3);
                    if (v.method_10577("hide")) continue;
                    int x = v.method_10550("x");
                    int z = v.method_10550("z");
                    class_2960 vid = class_2960.method_12829((String)v.method_10558("id"));
                    class_2960 dim = class_2960.method_12829((String)v.method_10558("dim"));
                    if (!dim.equals((Object)this.mc.field_1687.method_27983().method_29177())) continue;
                    DimChunkPos pos = new DimChunkPos((class_5321<class_1937>)class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)dim), x, z);
                    Object var15_15 = class_310.method_1551().field_1687.method_8433().method_8130(vid).orElse(null);
                    if (!(var15_15 instanceof VeinRecipe)) continue;
                    VeinRecipe vr = var15_15;
                    found.add(pos);
                    OreVeinInfo info = new OreVeinInfo(pos, vr, false);
                    if (this.chunkDataAtlas.containsKey(pos)) {
                        if (this.chunkDataAtlas.get(pos).equals(info)) continue;
                        PolygonOverlay ov = this.chunkOverlays.remove(pos);
                        if (this.activated && ov != null) {
                            this.api.remove((Displayable)ov);
                        }
                    }
                    this.chunkDataAtlas.put(pos, info);
                    if (this.activated) {
                        this.showOverlay((Displayable)info.getOverlay());
                    }
                    this.chunkOverlays.put(pos, info.getOverlay());
                    this.chunkDataLegacy.remove(pos);
                }
            }
            this.chunkDataAtlas.keySet().removeIf(e -> {
                if (!found.contains(e)) {
                    PolygonOverlay ov = this.chunkOverlays.remove(e);
                    if (this.activated && ov != null) {
                        this.api.remove((Displayable)ov);
                    }
                    return true;
                }
                return false;
            });
        }
        if (!this.oreDistanceInfos.isEmpty()) {
            this.oreDistanceInfos.removeIf(i -> {
                boolean t = i.timedOut(time);
                if (t) {
                    this.api.remove((Displayable)i.getOverlay());
                }
                return t;
            });
        }
        if (!this.oreNearbyInfos.isEmpty()) {
            this.oreNearbyInfos.removeIf(i -> {
                boolean t = i.timedOut(time);
                if (t) {
                    this.api.remove((Displayable)i.getOverlay());
                }
                return t;
            });
        }
    }

    public static void addOreInfoToMap(class_2487 tag) {
        class_2960 id;
        int x = tag.method_10550("x");
        int z = tag.method_10550("z");
        class_2338 pos = new class_2338(x, 0, z);
        class_1923 center = new class_1923(pos);
        if (tag.method_10545("found")) {
            id = class_2960.method_12829((String)tag.method_10558("found"));
            INSTANCE.setVeinInfo(center, id);
        }
        if (tag.method_10545("nearby")) {
            id = class_2960.method_12829((String)tag.method_10558("nearby"));
            INSTANCE.addVeinNearbyInfo(center, id);
        }
        if (tag.method_10545("far")) {
            id = class_2960.method_12829((String)tag.method_10558("far"));
            int dist = tag.method_10550("dist");
            INSTANCE.addVeinDistanceInfo(pos, dist, id);
        }
    }

    static {
        gson = new GsonBuilder().create();
    }
}

