/*
 * Decompiled with CFR 0.152.
 */
package com.tom.createores.menu;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_474;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_6382;

public abstract class PagedListWidget<D, T>
extends class_339 {
    private class_474 forwardButton;
    private class_474 backButton;
    private int wh;
    private int page;
    protected Supplier<List<T>> list;
    protected T selected;
    private List<ListEntry> listEntries = new ArrayList<ListEntry>();

    public PagedListWidget(int x, int y, int w, int h, int wh) {
        super(x, y, w, h, (class_2561)class_2561.method_43473());
        this.forwardButton = this.addWidgetToGUI(new class_474(x + w - 24, y + h - 12, true, p_98297_ -> this.pageForward(), true));
        this.backButton = this.addWidgetToGUI(new class_474(x + 4, y + h - 12, false, p_98287_ -> this.pageBack(), true));
        this.wh = wh;
        int wc = this.getLines();
        for (int i = 0; i < wc; ++i) {
            this.listEntries.add(new ListEntry(i, this.makeElement(x, y + i * wh)));
        }
    }

    private void pageBack() {
        if (this.page > 0) {
            --this.page;
            this.updateContent();
        }
    }

    private void pageForward() {
        if ((this.page + 1) * this.getLines() < this.list.get().size()) {
            ++this.page;
            this.updateContent();
        }
    }

    protected void method_47399(class_6382 pNarrationElementOutput) {
    }

    protected void method_48579(class_332 pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        if (this.field_22764) {
            class_310 minecraft = class_310.method_1551();
            class_5250 c = class_2561.method_43470((String)(this.page + 1 + " / " + Math.max(class_3532.method_15386((float)((float)this.list.get().size() / (float)this.getLines())), 1)));
            pGuiGraphics.method_51439(minecraft.field_1772, (class_2561)c, this.method_46426() + this.method_25368() / 2 - minecraft.field_1772.method_27525((class_5348)c) / 2, this.method_46427() + this.method_25364() - 8, 0x404040, false);
        }
    }

    protected abstract <W extends class_339> W addWidgetToGUI(W var1);

    protected abstract D makeElement(int var1, int var2);

    protected abstract void updateElement(D var1, T var2);

    public void updateContent() {
        this.listEntries.forEach(ListEntry::update);
        this.page = class_3532.method_15340((int)this.page, (int)0, (int)Math.max(class_3532.method_15386((float)((float)this.list.get().size() / (float)this.getLines())), 0));
        this.backButton.field_22763 = this.page > 0;
        this.forwardButton.field_22763 = (this.page + 1) * this.getLines() < this.list.get().size();
    }

    public int getLines() {
        return (this.field_22759 - 16) / this.wh;
    }

    public void setVisible(boolean visible) {
        this.field_22764 = visible;
        this.backButton.field_22764 = visible;
        this.forwardButton.field_22764 = visible;
        this.listEntries.forEach(ListEntry::update);
    }

    private class ListEntry {
        private final int id;
        private final D disp;

        public ListEntry(int id, D disp) {
            this.id = id;
            this.disp = disp;
        }

        private T getId() {
            if (!PagedListWidget.this.field_22764) {
                return null;
            }
            List l = PagedListWidget.this.list.get();
            int j = PagedListWidget.this.page * PagedListWidget.this.getLines();
            if (j < 0) {
                j = 0;
            }
            if (this.id + j < l.size()) {
                return l.get(this.id + j);
            }
            return null;
        }

        private void update() {
            PagedListWidget.this.updateElement(this.disp, this.getId());
        }
    }
}

