/*
 * Decompiled with CFR 0.152.
 */
package com.tom.createores.emi;

import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.systems.RenderSystem;
import com.tom.createores.Registration;
import com.tom.createores.recipe.VeinRecipe;
import com.tom.createores.util.NumberFormatter;
import dev.emi.emi.EmiUtil;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.stack.serializer.EmiIngredientSerializer;
import java.util.ArrayList;
import java.util.List;
import net.createmod.catnip.gui.element.GuiGameElement;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1863;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_5684;

public class VeinEmiStack
extends EmiStack {
    private static class_1799 drill = new class_1799((class_1935)Registration.NORMAL_DRILL_ITEM.get());
    private VeinRecipe recipe;

    public VeinEmiStack(VeinRecipe recipe) {
        this.recipe = recipe;
    }

    public boolean isEmpty() {
        return this.recipe == null;
    }

    public void render(class_332 guiGraphics, int x, int y, float delta, int flags) {
        RenderSystem.enableDepthTest();
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_46416((float)x, (float)y, 0.0f);
        GuiGameElement.of((class_1799)this.recipe.icon).render(guiGraphics);
        guiGraphics.method_51448().method_22903();
        float s = 0.5f;
        guiGraphics.method_51448().method_46416(8.0f, 8.0f, 100.0f);
        guiGraphics.method_51448().method_22905(s, s, s);
        GuiGameElement.of((class_1799)drill).render(guiGraphics);
        guiGraphics.method_51448().method_22909();
        guiGraphics.method_51448().method_22909();
    }

    public class_2487 getNbt() {
        return null;
    }

    public Object getKey() {
        return this.recipe;
    }

    public class_2960 getId() {
        return this.recipe.method_8114();
    }

    public List<class_5684> getTooltip() {
        ArrayList list = Lists.newArrayList();
        ArrayList<Object> tooltip = new ArrayList<Object>();
        tooltip.add(this.getName());
        tooltip.addAll(this.getTooltipText());
        tooltip.add(class_2561.method_43470((String)EmiUtil.getModName((String)this.recipe.id.method_12836())).method_27695(new class_124[]{class_124.field_1078, class_124.field_1056}));
        tooltip.stream().map(class_2561::method_30937).map(class_5684::method_32662).forEach(list::add);
        list.addAll(super.getTooltip());
        return list;
    }

    public List<class_2561> getTooltipText() {
        ArrayList<class_2561> tooltip = new ArrayList<class_2561>();
        if (this.recipe.isInfiniteClient()) {
            tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.coe.infiniteVeins"));
        } else {
            tooltip.add((class_2561)class_2561.method_43469((String)"tooltip.coe.finiteVeins", (Object[])new Object[]{NumberFormatter.formatNumber(this.recipe.getMinAmountClient()), NumberFormatter.formatNumber(this.recipe.getMaxAmountClient())}));
        }
        return tooltip;
    }

    public class_2561 getName() {
        return this.recipe.veinName;
    }

    public EmiStack copy() {
        return this;
    }

    public static class Serializer
    implements EmiIngredientSerializer<VeinEmiStack> {
        public String getType() {
            return "coe:vein";
        }

        public EmiIngredient deserialize(JsonElement element) {
            class_2960 r;
            class_1863 mngr = class_310.method_1551().method_1562().method_2877();
            VeinRecipe rec = mngr.method_8130(r = class_2960.method_12829((String)element.getAsJsonObject().get("value").getAsString())).map(v -> {
                VeinRecipe e;
                return v instanceof VeinRecipe ? (e = (VeinRecipe)v) : null;
            }).orElse(null);
            return rec != null ? new VeinEmiStack(rec) : null;
        }

        public JsonElement serialize(VeinEmiStack stack) {
            JsonObject json = new JsonObject();
            json.addProperty("type", "coe:vein");
            json.addProperty("value", stack.recipe.method_8114().toString());
            return json;
        }
    }
}

