/*
 * Decompiled with CFR 0.152.
 */
package com.tom.createores.jm;

import com.tom.createores.recipe.VeinRecipe;
import com.tom.createores.util.DimChunkPos;
import journeymap.api.v2.client.display.PolygonOverlay;
import journeymap.api.v2.client.model.MapPolygon;
import journeymap.api.v2.client.model.ShapeProperties;
import journeymap.api.v2.client.model.TextProperties;
import journeymap.api.v2.client.util.PolygonHelper;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeHolder;

public class OreVeinInfo {
    private PolygonOverlay overlay;
    public final ResourceLocation id;

    public OreVeinInfo(DimChunkPos pos, RecipeHolder<VeinRecipe> vein, boolean legacy) {
        int color = legacy ? -8947849 : -256;
        ShapeProperties shapeProps = new ShapeProperties().setStrokeWidth(1.0f).setStrokeColor(color).setFillColor(color).setFillOpacity(0.2f);
        TextProperties textProps = new TextProperties().setColor(color).setOpacity(1.0f).setFontShadow(true);
        MapPolygon polygon = PolygonHelper.createChunkPolygon((int)pos.x(), (int)1, (int)pos.z());
        this.overlay = new PolygonOverlay("createoreexcavation", pos.dimension(), shapeProps, polygon);
        this.overlay.setOverlayGroupName("COE Veins").setLabel(((VeinRecipe)vein.value()).getName().getString()).setTextProperties(textProps);
        this.id = vein.id();
    }

    public PolygonOverlay getOverlay() {
        return this.overlay;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.overlay == null ? 0 : this.overlay.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OreVeinInfo other = (OreVeinInfo)obj;
        if (this.id == null ? other.id != null : !this.id.equals((Object)other.id)) {
            return false;
        }
        return !(this.overlay == null ? other.overlay != null : !this.overlay.equals((Object)other.overlay));
    }
}

