/*
 * Decompiled with CFR 0.152.
 */
package com.tom.createores.menu;

import com.tom.createores.Config;
import com.tom.createores.Registration;
import com.tom.createores.item.OreVeinAtlasItem;
import com.tom.createores.network.OreVeinAtlasClickPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.item.ItemStack;

public class OreVeinAtlasMenu
extends AbstractContainerMenu {
    private ItemStack heldItem;
    private SimpleContainerData sync;

    public OreVeinAtlasMenu(MenuType<?> type, int wid, Inventory pinv) {
        this(type, wid, pinv, pinv.player.getMainHandItem());
    }

    public OreVeinAtlasMenu(MenuType<?> type, int wid, Inventory pinv, ItemStack heldItem) {
        super(type, wid);
        this.heldItem = heldItem;
        this.sync = new SimpleContainerData(3);
        this.sync.set(0, Config.finiteAmountBase & 0xFFFF);
        this.sync.set(1, Config.finiteAmountBase >> 16 & 0xFFFF);
        this.sync.set(2, Config.defaultInfinite ? 1 : 0);
        this.addDataSlots((ContainerData)this.sync);
    }

    public ItemStack quickMoveStack(Player p_38941_, int p_38942_) {
        return ItemStack.EMPTY;
    }

    public boolean stillValid(Player pl) {
        return pl.getMainHandItem().getItem() == Registration.VEIN_ATLAS_ITEM.get();
    }

    public ItemStack getHeldItem() {
        return this.heldItem;
    }

    public void click(OreVeinAtlasClickPacket.Option opt, ResourceLocation id) {
        ((OreVeinAtlasItem)Registration.VEIN_ATLAS_ITEM.get()).menuClicked(this.heldItem, opt, id);
    }

    public int getFiniteBase() {
        return this.sync.get(1) << 16 | this.sync.get(0);
    }

    public boolean isDefaultInfinite() {
        return this.sync.get(2) != 0;
    }

    public void click2(OreVeinAtlasClickPacket.Option opt, int id) {
        ((OreVeinAtlasItem)Registration.VEIN_ATLAS_ITEM.get()).menuClicked2(this.heldItem, opt, id);
    }
}

