/*
 * Decompiled with CFR 0.152.
 */
package com.tom.createores.data;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.api.data.recipe.MechanicalCraftingRecipeBuilder;
import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import com.simibubi.create.content.processing.recipe.StandardProcessingRecipe;
import com.tom.createores.CreateOreExcavation;
import com.tom.createores.Registration;
import com.tom.createores.recipe.DrillingRecipe;
import com.tom.createores.recipe.ExcavatingRecipe;
import com.tom.createores.recipe.ExtractorRecipe;
import com.tom.createores.recipe.VeinRecipe;
import com.tom.createores.util.FluidIngredient;
import com.tom.createores.util.ThreeState;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadType;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.fluids.FluidStack;

public class COERecipes
extends RecipeProvider {
    private static Random seedRandom;

    public COERecipes(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries);
    }

    protected void buildRecipes(RecipeOutput consumer) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)Registration.NORMAL_DRILL_ITEM.get())).pattern("bi ").pattern("ibi").pattern(" ii").define(Character.valueOf('b'), Tags.Items.STORAGE_BLOCKS_IRON).define(Character.valueOf('i'), Tags.Items.INGOTS_IRON).group("create").unlockedBy("iron", InventoryChangeTrigger.TriggerInstance.hasItems((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.item().of(Tags.Items.INGOTS_IRON).build()})).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)Registration.DIAMOND_DRILL_ITEM.get())).pattern("bi ").pattern("idi").pattern(" ii").define(Character.valueOf('b'), Tags.Items.STORAGE_BLOCKS_DIAMOND).define(Character.valueOf('i'), Tags.Items.GEMS_DIAMOND).define(Character.valueOf('d'), (ItemLike)Registration.NORMAL_DRILL_ITEM.get()).group("create").unlockedBy("diamond", InventoryChangeTrigger.TriggerInstance.hasItems((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.item().of(Tags.Items.GEMS_DIAMOND).build()})).save(consumer);
        COERecipes.netheriteSmithing((RecipeOutput)consumer, (Item)((Item)Registration.DIAMOND_DRILL_ITEM.get()), (RecipeCategory)RecipeCategory.MISC, (Item)((Item)Registration.NETHERITE_DRILL_ITEM.get()));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)Registration.VEIN_FINDER_ITEM.get())).pattern("ea ").pattern("rs ").pattern("  s").define(Character.valueOf('e'), (ItemLike)Items.ENDER_EYE).define(Character.valueOf('a'), Tags.Items.GEMS_AMETHYST).define(Character.valueOf('s'), Tags.Items.RODS_WOODEN).define(Character.valueOf('r'), Tags.Items.ORES_REDSTONE).group("create").unlockedBy("diamond", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.ENDER_EYE})).save(consumer);
        MechanicalCraftingRecipeBuilder.shapedRecipe((ItemLike)((ItemLike)Registration.DRILL_BLOCK.get())).patternLine("BbtbB").patternLine("beSeb").patternLine("CmDmF").patternLine("bsssb").patternLine("BbbbB").key(Character.valueOf('B'), TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.parse((String)"c:storage_blocks/brass"))).key(Character.valueOf('b'), TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.parse((String)"c:plates/brass"))).key(Character.valueOf('e'), (ItemLike)AllItems.ELECTRON_TUBE.get()).key(Character.valueOf('S'), (ItemLike)AllBlocks.SPOUT.get()).key(Character.valueOf('C'), (ItemLike)AllBlocks.BRASS_CASING.get()).key(Character.valueOf('m'), (ItemLike)AllItems.PRECISION_MECHANISM.get()).key(Character.valueOf('D'), (ItemLike)AllBlocks.MECHANICAL_DRILL.get()).key(Character.valueOf('s'), (ItemLike)AllItems.STURDY_SHEET.get()).key(Character.valueOf('F'), (ItemLike)AllBlocks.BRASS_TUNNEL.get()).key(Character.valueOf('t'), (ItemLike)AllBlocks.COPPER_CASING.get()).build(consumer);
        MechanicalCraftingRecipeBuilder.shapedRecipe((ItemLike)((ItemLike)Registration.EXTRACTOR_BLOCK.get())).patternLine("BbPbB").patternLine("beHeb").patternLine("CmDmb").patternLine("bsssb").patternLine("BbbbB").key(Character.valueOf('B'), TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.parse((String)"c:storage_blocks/brass"))).key(Character.valueOf('b'), TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.parse((String)"c:plates/brass"))).key(Character.valueOf('e'), (ItemLike)AllItems.ELECTRON_TUBE.get()).key(Character.valueOf('H'), (ItemLike)AllBlocks.HOSE_PULLEY.get()).key(Character.valueOf('C'), (ItemLike)AllBlocks.BRASS_CASING.get()).key(Character.valueOf('m'), (ItemLike)AllItems.PRECISION_MECHANISM.get()).key(Character.valueOf('D'), (ItemLike)AllBlocks.MECHANICAL_DRILL.get()).key(Character.valueOf('s'), (ItemLike)AllItems.STURDY_SHEET.get()).key(Character.valueOf('P'), (ItemLike)AllBlocks.MECHANICAL_PUMP.get()).build(consumer);
        seedRandom = new Random(10387320L);
        ((DrillingBuilder)((DrillingBuilder)new DrillingBuilder((ItemLike)Items.RAW_IRON, 600, 1024, 128).setBiomeWhitelist(BiomeTags.IS_OVERWORLD)).veinSize(10.0f, 30.0f)).save("iron", consumer);
        ((DrillingBuilder)((DrillingBuilder)((DrillingBuilder)new DrillingBuilder((ItemLike)Items.RAW_GOLD, 600, 1024, 512).setBiomeWhitelist(BiomeTags.IS_OVERWORLD)).veinSize(2.0f, 4.0f)).setStress(192)).save("gold", consumer);
        ((DrillingBuilder)((DrillingBuilder)new DrillingBuilder((ItemLike)Items.RAW_COPPER, 600, 1024, 128).setBiomeWhitelist(BiomeTags.IS_OVERWORLD)).veinSize(10.0f, 30.0f)).save("copper", consumer);
        ((DrillingBuilder)((DrillingBuilder)new DrillingBuilder((ItemLike)Items.COAL, 200, 1024, 128).setBiomeWhitelist(BiomeTags.IS_OVERWORLD)).veinSize(15.0f, 40.0f)).save("coal", consumer);
        ((DrillingBuilder)((DrillingBuilder)((DrillingBuilder)new DrillingBuilder((ItemLike)Registration.RAW_DIAMOND.get(), 1200, 2048, 1024).setBiomeWhitelist(BiomeTags.IS_OVERWORLD)).setStress(512)).veinSize(0.5f, 2.0f)).save("diamond", consumer);
        ((DrillingBuilder)((DrillingBuilder)new DrillingBuilder((ItemLike)Registration.RAW_REDSTONE.get(), 600, 1024, 256).setBiomeWhitelist(BiomeTags.IS_OVERWORLD)).veinSize(10.0f, 30.0f)).save("redstone", consumer);
        ((DrillingBuilder)((DrillingBuilder)((DrillingBuilder)new DrillingBuilder((ItemLike)Registration.RAW_EMERALD.get(), 1200, 2048, 1024).setBiomeWhitelist(BiomeTags.IS_OVERWORLD)).veinSize(0.2f, 1.0f)).setStress(512)).save("emerald", consumer);
        ((DrillingBuilder)((DrillingBuilder)((DrillingBuilder)((DrillingBuilder)new DrillingBuilder(new ProcessingOutput(new ItemStack((ItemLike)Registration.RAW_DIAMOND.get()), 1.0f), 400, (Component)Component.translatable((String)"ore.coe.hardenedDiamond"), 4096, 2048).addOutput((ItemLike)Items.DIAMOND, 0.1f).setDrill(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)Registration.NETHERITE_DRILL_ITEM.get()}))).setDrillingFluid(FluidIngredient.fromFluid(Fluids.LAVA, 500)).setBiomeWhitelist(BiomeTags.IS_OVERWORLD)).setStress(1024)).veinSize(1.0f, 3.0f)).save("hardened_diamond", consumer);
        ((DrillingBuilder)((DrillingBuilder)new DrillingBuilder((ItemLike)AllItems.RAW_ZINC.get(), 600, 1024, 128).setBiomeWhitelist(BiomeTags.IS_OVERWORLD)).veinSize(8.0f, 24.0f)).save("zinc", consumer);
        ((DrillingBuilder)((DrillingBuilder)new DrillingBuilder((ItemLike)Items.LAPIS_LAZULI, 400, 1024, 128).setBiomeWhitelist(BiomeTags.IS_OVERWORLD)).veinSize(8.0f, 24.0f)).save("lapis", consumer);
        ((DrillingBuilder)((DrillingBuilder)new DrillingBuilder((ItemLike)Items.GLOWSTONE_DUST, 1200, 1024, 128).setBiomeWhitelist(BiomeTags.IS_NETHER)).veinSize(5.0f, 12.0f)).save("glowstone", consumer);
        ((DrillingBuilder)((DrillingBuilder)((DrillingBuilder)new DrillingBuilder((ItemLike)Items.QUARTZ, 1200, 1024, 128).setBiomeWhitelist(BiomeTags.IS_NETHER)).setStress(512)).veinSize(8.0f, 24.0f)).save("quartz", consumer);
        ((DrillingBuilder)((DrillingBuilder)((DrillingBuilder)((DrillingBuilder)new DrillingBuilder(new ItemStack((ItemLike)Blocks.ANCIENT_DEBRIS), 0.2f, 4000, 4096, 2048).addOutput((ItemLike)Items.GOLD_NUGGET, 0.8f).addOutput((ItemLike)Blocks.NETHERRACK, 0.8f).addOutput((ItemLike)Blocks.MAGMA_BLOCK, 0.5f).setBiomeWhitelist(BiomeTags.IS_NETHER)).setDrill(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)Registration.NETHERITE_DRILL_ITEM.get()}))).setDrillingFluid(FluidIngredient.fromFluid(Fluids.LAVA, 1000)).setStress(2048)).veinSize(0.5f, 0.8f)).save("netherite", consumer);
        ((DrillingBuilder)((DrillingBuilder)((DrillingBuilder)new DrillingBuilder(new ItemStack((ItemLike)Items.GOLD_NUGGET, 3), 400, 2048, 1024).setBiomeWhitelist(BiomeTags.IS_NETHER)).addOutput((ItemLike)Items.GOLD_NUGGET, 0.5f).veinSize(3.0f, 8.0f)).setStress(192)).save("nether_gold", consumer);
        ((ExtractorBuilder)((ExtractorBuilder)new ExtractorBuilder(new FluidStack((Fluid)Fluids.WATER, 500), 20, 512, 128).setBiomeWhitelist(BiomeTags.IS_OVERWORLD)).setFinite(ThreeState.NEVER)).save("water", consumer);
        COERecipes.processing("redstone_milling", AllRecipeTypes.MILLING, consumer, b -> ((StandardProcessingRecipe.Builder)((StandardProcessingRecipe.Builder)b.withItemIngredients(new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)Registration.RAW_REDSTONE.get()})})).output(new ItemStack((ItemLike)Items.REDSTONE, 3))).duration(250));
        COERecipes.processing("redstone_crushing", AllRecipeTypes.CRUSHING, consumer, b -> ((StandardProcessingRecipe.Builder)((StandardProcessingRecipe.Builder)b.withItemIngredients(new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)Registration.RAW_REDSTONE.get()})})).output(new ItemStack((ItemLike)Items.REDSTONE, 4))).duration(250));
        COERecipes.processing("diamond_cutting", AllRecipeTypes.CUTTING, consumer, b -> ((StandardProcessingRecipe.Builder)((StandardProcessingRecipe.Builder)b.withItemIngredients(new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)Registration.RAW_DIAMOND.get()})})).output((ItemLike)Items.DIAMOND)).duration(250));
        COERecipes.processing("emerald_cutting", AllRecipeTypes.CUTTING, consumer, b -> ((StandardProcessingRecipe.Builder)((StandardProcessingRecipe.Builder)b.withItemIngredients(new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)Registration.RAW_EMERALD.get()})})).output((ItemLike)Items.EMERALD)).duration(250));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)Registration.VEIN_ATLAS_ITEM.get())).pattern("ca").pattern("mb").define(Character.valueOf('c'), Tags.Items.CHESTS).define(Character.valueOf('a'), Tags.Items.GEMS_AMETHYST).define(Character.valueOf('m'), (ItemLike)Items.MAP).define(Character.valueOf('b'), (ItemLike)Items.WRITABLE_BOOK).group("create").unlockedBy("map", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.MAP})).save(consumer);
        MechanicalCraftingRecipeBuilder.shapedRecipe((ItemLike)((ItemLike)Registration.SAMPLE_DRILL_BLOCK.get())).patternLine("beb").patternLine("mCb").patternLine("sDs").key(Character.valueOf('b'), TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.parse((String)"c:plates/brass"))).key(Character.valueOf('e'), (ItemLike)AllItems.ELECTRON_TUBE.get()).key(Character.valueOf('C'), (ItemLike)AllBlocks.BRASS_CASING.get()).key(Character.valueOf('m'), (ItemLike)AllItems.PRECISION_MECHANISM.get()).key(Character.valueOf('D'), (ItemLike)AllBlocks.MECHANICAL_DRILL.get()).key(Character.valueOf('s'), (ItemLike)AllItems.STURDY_SHEET.get()).build(consumer);
    }

    private static <T extends StandardProcessingRecipe<?>> void processing(String name, AllRecipeTypes type, RecipeOutput consumer, Consumer<StandardProcessingRecipe.Builder<?>> f) {
        ResourceLocation id = COERecipes.i(name);
        StandardProcessingRecipe.Builder b = new StandardProcessingRecipe.Builder(((StandardProcessingRecipe.Serializer)type.getSerializer()).factory(), id);
        f.accept(b);
        b.build(consumer);
    }

    private static ResourceLocation i(String name) {
        return ResourceLocation.tryBuild((String)"createoreexcavation", (String)name);
    }

    public static class DrillingBuilder
    extends DrillingRecipe
    implements AbstractExcavatingBuilder<DrillingBuilder> {
        private VeinRecipe vein;

        public DrillingBuilder(ProcessingOutput output, int ticks, Component name, int spacing, int separation) {
            this.init(ticks, name, spacing, separation);
            this.output = NonNullList.create();
            this.output.add((Object)output);
            this.vein.icon = output.getStack();
        }

        public DrillingBuilder(ItemStack output, float chance, int ticks, int spacing, int separation) {
            this(new ProcessingOutput(output, chance), ticks, output.getHoverName(), spacing, separation);
        }

        public DrillingBuilder(ItemStack output, int ticks, int spacing, int separation) {
            this(new ProcessingOutput(output, 1.0f), ticks, output.getHoverName(), spacing, separation);
        }

        public DrillingBuilder(ItemLike output, int ticks, int spacing, int separation) {
            this(new ItemStack(output), ticks, spacing, separation);
        }

        public DrillingBuilder setDrillingFluid(FluidIngredient drillingFluid) {
            this.drillingFluid = Optional.of(drillingFluid);
            return this;
        }

        public DrillingBuilder addOutput(ProcessingOutput output) {
            this.output.add((Object)output);
            return this;
        }

        public DrillingBuilder addOutput(ItemStack output) {
            this.addOutput(new ProcessingOutput(output, 1.0f));
            return this;
        }

        public DrillingBuilder addOutput(ItemLike output) {
            this.addOutput(new ItemStack(output));
            return this;
        }

        public DrillingBuilder addOutput(ItemStack output, float chance) {
            this.addOutput(new ProcessingOutput(output, chance));
            return this;
        }

        public DrillingBuilder addOutput(ItemLike output, float chance) {
            this.addOutput(new ItemStack(output), chance);
            return this;
        }

        @Override
        public VeinRecipe vein() {
            return this.vein;
        }

        @Override
        public void initVein(int ticks, Component name, int spacing, int separation) {
            this.vein = new VeinRecipe();
            AbstractExcavatingBuilder.super.initVein(ticks, name, spacing, separation);
        }
    }

    public static interface AbstractExcavatingBuilder<T extends AbstractExcavatingBuilder<T>> {
        default public void init(int ticks, Component name, int spacing, int separation) {
            this.self().ticks = ticks;
            this.self().drill = Ingredient.of(CreateOreExcavation.DRILL_TAG);
            this.self().stressMul = 256;
            this.self().drillingFluid = Optional.empty();
            this.initVein(ticks, name, spacing, separation);
        }

        default public void initVein(int ticks, Component name, int spacing, int separation) {
            this.vein().veinName = name;
            this.vein().finite = ThreeState.DEFAULT;
            this.vein().amountMultiplierMin = 1.0f;
            this.vein().amountMultiplierMax = 2.0f;
            this.vein().placement = new RandomSpreadStructurePlacement(spacing / 8, separation / 16, RandomSpreadType.LINEAR, seedRandom.nextInt(Integer.MAX_VALUE));
        }

        default public ExcavatingRecipe self() {
            return (ExcavatingRecipe)((Object)this);
        }

        public VeinRecipe vein();

        default public T setDrill(Ingredient drill) {
            this.self().drill = drill;
            return (T)this;
        }

        default public T setStress(int stress) {
            this.self().stressMul = stress;
            return (T)this;
        }

        default public T setBiomeWhitelist(TagKey<Biome> tag) {
            this.vein().biomeWhitelist = tag;
            return (T)this;
        }

        default public T setBiomeBlacklist(TagKey<Biome> tag) {
            this.vein().biomeBlacklist = tag;
            return (T)this;
        }

        default public T veinSize(float min, float max) {
            this.vein().amountMultiplierMin = min;
            this.vein().amountMultiplierMax = max;
            return (T)this;
        }

        default public T setFinite(ThreeState finite) {
            this.vein().finite = finite;
            return (T)this;
        }

        default public T setPriority(int priority) {
            this.vein().priority = priority;
            return (T)this;
        }

        default public void save(String name, RecipeOutput consumer) {
            ResourceLocation vein;
            this.self().veinId = vein = COERecipes.i(this.vein().getGroup() + "/" + name);
            consumer.accept(vein, (Recipe)this.vein(), null);
            consumer.accept(COERecipes.i(this.self().getGroup() + "/" + name), (Recipe)this.self(), null);
        }
    }

    public static class ExtractorBuilder
    extends ExtractorRecipe
    implements AbstractExcavatingBuilder<ExtractorBuilder> {
        private VeinRecipe vein;

        public ExtractorBuilder(FluidStack output, int ticks, int spacing, int separation) {
            this(output, ticks, output.getDisplayName(), spacing, separation);
        }

        public ExtractorBuilder(FluidStack output, int ticks, Component name, int spacing, int separation) {
            this.init(ticks, name, spacing, separation);
            this.output = output;
            this.vein.icon = new ItemStack((ItemLike)output.getFluid().getBucket());
        }

        @Override
        public void initVein(int ticks, Component name, int spacing, int separation) {
            this.vein = new VeinRecipe();
            AbstractExcavatingBuilder.super.initVein(ticks, name, spacing, separation);
        }

        @Override
        public VeinRecipe vein() {
            return this.vein;
        }
    }
}

