/*
 * Decompiled with CFR 0.152.
 */
package com.tom.createores.menu;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.inventory.PageButton;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;

public abstract class PagedListWidget<D, T>
extends AbstractWidget {
    private PageButton forwardButton;
    private PageButton backButton;
    private int wh;
    private int page;
    protected Supplier<List<T>> list;
    protected T selected;
    private List<ListEntry> listEntries = new ArrayList<ListEntry>();

    public PagedListWidget(int x, int y, int w, int h, int wh) {
        super(x, y, w, h, (Component)Component.empty());
        this.forwardButton = this.addWidgetToGUI(new PageButton(x + w - 24, y + h - 12, true, p_98297_ -> this.pageForward(), true));
        this.backButton = this.addWidgetToGUI(new PageButton(x + 4, y + h - 12, false, p_98287_ -> this.pageBack(), true));
        this.wh = wh;
        int wc = this.getLines();
        for (int i = 0; i < wc; ++i) {
            this.listEntries.add(new ListEntry(i, this.makeElement(x, y + i * wh)));
        }
    }

    private void pageBack() {
        if (this.page > 0) {
            --this.page;
            this.updateContent();
        }
    }

    private void pageForward() {
        if ((this.page + 1) * this.getLines() < this.list.get().size()) {
            ++this.page;
            this.updateContent();
        }
    }

    protected void updateWidgetNarration(NarrationElementOutput pNarrationElementOutput) {
    }

    protected void renderWidget(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        if (this.visible) {
            Minecraft minecraft = Minecraft.getInstance();
            MutableComponent c = Component.literal((String)(this.page + 1 + " / " + Math.max(Mth.ceil((float)((float)this.list.get().size() / (float)this.getLines())), 1)));
            pGuiGraphics.drawString(minecraft.font, (Component)c, this.getX() + this.getWidth() / 2 - minecraft.font.width((FormattedText)c) / 2, this.getY() + this.getHeight() - 8, 0x404040, false);
        }
    }

    protected abstract <W extends AbstractWidget> W addWidgetToGUI(W var1);

    protected abstract D makeElement(int var1, int var2);

    protected abstract void updateElement(D var1, T var2);

    public void updateContent() {
        this.listEntries.forEach(ListEntry::update);
        this.page = Mth.clamp((int)this.page, (int)0, (int)Math.max(Mth.ceil((float)((float)this.list.get().size() / (float)this.getLines())), 0));
        this.backButton.active = this.page > 0;
        this.forwardButton.active = (this.page + 1) * this.getLines() < this.list.get().size();
    }

    public int getLines() {
        return (this.height - 16) / this.wh;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
        this.backButton.visible = visible;
        this.forwardButton.visible = visible;
        this.listEntries.forEach(ListEntry::update);
    }

    private class ListEntry {
        private final int id;
        private final D disp;

        public ListEntry(int id, D disp) {
            this.id = id;
            this.disp = disp;
        }

        private T getId() {
            if (!PagedListWidget.this.visible) {
                return null;
            }
            List l = PagedListWidget.this.list.get();
            int j = PagedListWidget.this.page * PagedListWidget.this.getLines();
            if (j < 0) {
                j = 0;
            }
            if (this.id + j < l.size()) {
                return l.get(this.id + j);
            }
            return null;
        }

        private void update() {
            PagedListWidget.this.updateElement(this.disp, this.getId());
        }
    }
}

