/*
 * Decompiled with CFR 0.152.
 */
package io.github.a5b84.helditeminfo;

import com.google.gson.JsonParseException;
import io.github.a5b84.helditeminfo.HeldItemInfoClient;
import io.github.a5b84.helditeminfo.TooltipBuilder;
import io.github.a5b84.helditeminfo.Util;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.ResourceLocationException;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public final class Appenders {
    private Appenders() {
    }

    public static void appendEnchantments(TooltipBuilder builder) {
        ItemStack stack = builder.stack;
        if (!Util.hasHideFlag(stack.m_41783_(), 1)) {
            ListTag enchantments;
            ListTag listTag = enchantments = stack.m_41720_() == Items.f_42690_ ? EnchantedBookItem.m_41163_((ItemStack)stack) : stack.m_41785_();
            if (!enchantments.isEmpty()) {
                List<ResourceLocation> filters = HeldItemInfoClient.filteredEnchantments;
                if (!filters.isEmpty()) {
                    ListTag filtered = new ListTag();
                    for (Tag tag : enchantments) {
                        if (!(tag instanceof CompoundTag)) continue;
                        try {
                            ResourceLocation id = ResourceLocation.parse((String)((CompoundTag)tag).m_128461_("id"));
                            if (filters.contains(id) != HeldItemInfoClient.config.showOnlyFilteredEnchantments()) continue;
                            filtered.add((Object)tag);
                        }
                        catch (ResourceLocationException resourceLocationException) {}
                    }
                    enchantments = filtered;
                }
                ArrayList enchantmentTexts = new ArrayList(enchantments.size());
                ItemStack.m_41709_(enchantmentTexts, (ListTag)enchantments);
                builder.appendAll(enchantmentTexts);
            }
        }
    }

    public static void appendContainerContent(TooltipBuilder builder) {
        if (!Appenders.appendContainerContent(builder, builder.stack.m_41783_()) && !Appenders.appendContainerContent(builder, builder.stack.m_41737_("BlockEntityTag"))) {
            boolean bl = false;
        } else {
            boolean bl = true;
        }
    }

    private static boolean appendContainerContent(TooltipBuilder builder, CompoundTag tag) {
        if (tag == null) {
            return false;
        }
        ListTag items = tag.m_128437_("Items", 10);
        if (tag.m_128425_("LootTable", 8)) {
            builder.append((Component)Component.m_237113_((String)"???????"));
            return true;
        }
        if (!items.isEmpty()) {
            boolean added = false;
            for (Tag itemElement : items) {
                CompoundTag itemNbt;
                if (!(itemElement instanceof CompoundTag) || !Appenders.appendItem(builder, itemNbt = (CompoundTag)itemElement)) continue;
                added = true;
            }
            return added;
        }
        return false;
    }

    public static boolean appendItem(TooltipBuilder builder, CompoundTag itemNbt) {
        if (itemNbt.m_128456_()) {
            return false;
        }
        ItemStack iStack = ItemStack.m_41712_((CompoundTag)itemNbt);
        if (iStack.m_41619_()) {
            return false;
        }
        MutableComponent text = builder.canAdd() ? iStack.m_41786_().m_6881_().m_130946_(" x" + iStack.m_41613_()).m_130940_(TooltipBuilder.DEFAULT_COLOR) : null;
        builder.append((Component)text);
        return true;
    }

    public static void appendLore(TooltipBuilder builder) {
        ListTag loreTag;
        CompoundTag displayTag = builder.stack.m_41737_("display");
        if (displayTag != null && !(loreTag = displayTag.m_128437_("Lore", 8)).isEmpty()) {
            ArrayList<MutableComponent> lore = new ArrayList<MutableComponent>();
            for (int i = 0; i < loreTag.size(); ++i) {
                String lineString = loreTag.m_128778_(i);
                if (HeldItemInfoClient.config.removePlusNbt() && lineString.equals("\"(+NBT)\"")) continue;
                try {
                    MutableComponent line = Component.Serializer.m_130701_((String)lineString);
                    if (line == null) continue;
                    int maxLines = Math.min(HeldItemInfoClient.config.maxLoreLines() - lore.size(), builder.getRemainingLines());
                    List<MutableComponent> newLines = Util.wrapLines((FormattedText)line, maxLines);
                    lore.addAll(newLines);
                    continue;
                }
                catch (JsonParseException var9) {
                    return;
                }
            }
            for (MutableComponent line : lore) {
                ComponentUtils.m_130750_((MutableComponent)line, (Style)Style.f_131099_.m_131140_(TooltipBuilder.DEFAULT_COLOR));
            }
            builder.appendAll(lore);
        }
    }

    public static void appendUnbreakable(TooltipBuilder builder) {
        CompoundTag tag;
        if (builder.stack.m_41720_().m_41465_() && (tag = builder.stack.m_41783_()) != null && tag.m_128471_("Unbreakable") && !Util.hasHideFlag(tag, 4)) {
            builder.append((Component)Component.m_237115_((String)"item.unbreakable").m_130940_(ChatFormatting.BLUE));
        }
    }
}

